/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.apache.commons.lang3.StringEscapeUtils;
import sootup.core.jimple.basic.EquivTo;
import sootup.core.model.Body;
import sootup.core.model.SootClass;
import sootup.core.model.SootMethod;
import sootup.core.util.EscapedWriter;
import sootup.core.util.printer.JimplePrinter;

public class Utils {
    @Nullable
    Path compileJavaOTF(String className, String javaSourceContent) {
        try {
            Path root = Files.createTempDirectory("JavaOTFCompileTempDir", new FileAttribute[0]);
            root.toFile().deleteOnExit();
            File sourceFile = new File(root.toFile(), className + ".java");
            if (!sourceFile.createNewFile()) {
                return null;
            }
            sourceFile.deleteOnExit();
            Path compileUnitPath = sourceFile.toPath();
            Files.write(compileUnitPath, javaSourceContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return this.compileJavaOTF(compileUnitPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    Path compileJavaOTF(Path sourceFile) {
        boolean b;
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        boolean bl = b = 0 == compiler.run(null, null, null, sourceFile.toString());
        if (b) {
            File file = new File(sourceFile.toString().replace(".java", ".class"));
            file.deleteOnExit();
            return file.toPath();
        }
        return null;
    }

    public static void outputJimple(SootClass cl, boolean print) {
        if (print) {
            File outputDir = new File("jimpleOutput");
            if (!outputDir.exists()) {
                outputDir.mkdir();
            }
            File file = new File(outputDir + File.separator + cl.getName() + ".jimple");
            try {
                PrintWriter writer = new PrintWriter(file);
                JimplePrinter printer = new JimplePrinter(new JimplePrinter.Option[0]);
                printer.printTo(cl, writer);
                writer.flush();
                writer.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static void print(SootClass cl, boolean print) {
        if (print) {
            PrintWriter writer = new PrintWriter(System.out);
            JimplePrinter printer = new JimplePrinter(new JimplePrinter.Option[0]);
            printer.printTo(cl, writer);
            writer.flush();
            writer.close();
        }
    }

    public static void print(SootMethod method, boolean print) {
        if (print) {
            PrintWriter writer = new PrintWriter(System.out);
            JimplePrinter printer = new JimplePrinter(new JimplePrinter.Option[0]);
            printer.printTo(method.getBody(), writer);
            writer.flush();
            writer.close();
        }
    }

    public static void assertEquiv(EquivTo expected, EquivTo actual) {
        if (!expected.equivTo(actual)) {
            throw new AssertionError((Object)("Expected '" + expected + "', actual is '" + actual + "'"));
        }
    }

    public static <T> void assertInstanceOfSatisfying(Object actual, Class<T> tClass, Consumer<T> checker) {
        try {
            checker.accept(tClass.cast(actual));
        }
        catch (ClassCastException e) {
            throw new AssertionError((Object)("Expected value of type " + tClass + (actual != null ? ", got type " + actual.getClass() + " with value " : ", got ") + actual));
        }
    }

    @Nonnull
    public static ArrayList<String> bodyStmtsAsStrings(@Nonnull Body body) {
        StringWriter writer = new StringWriter();
        try (PrintWriter writerOut = new PrintWriter(new EscapedWriter(writer));){
            JimplePrinter printer = new JimplePrinter(new JimplePrinter.Option[0]);
            printer.setOption(JimplePrinter.Option.OmitLocalsDeclaration);
            printer.printTo(body, writerOut);
        }
        return Utils.filterJimple(writer.toString());
    }

    @Nonnull
    public static ArrayList<String> filterJimple(String str) {
        return Utils.filterJimple(Arrays.stream(str.split("\n")).skip(1L));
    }

    public static ArrayList<String> filterJimple(Stream<String> stream) {
        return stream.map(String::trim).map(line -> line.endsWith(";") ? line.substring(0, line.length() - 1) : line).filter(line -> !line.isEmpty() && !"{".equals(line) && !"}".equals(line)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static void printJimpleForTest(SootMethod m3) {
        System.out.println(Utils.printedJimpleToArrayRepresentation(m3.getBody()));
    }

    public static String printedJimpleToArrayRepresentation(Body b) {
        ArrayList<String> arr = Utils.filterJimple(Utils.bodyStmtsAsStrings(b).stream());
        return Utils.printJimpleStmtsForTest(arr);
    }

    public static String printJimpleStmtsForTest(List<String> stmts) {
        StringBuilder sb = new StringBuilder();
        stmts.forEach(item -> sb.append('\"').append(StringEscapeUtils.escapeJava(item)).append('\"').append(',').append("\n"));
        if (stmts.size() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

