/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.util.printer;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Trap;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.Modifier;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.PackageName;
import sootup.core.types.ClassType;
import sootup.core.types.Type;
import sootup.core.util.printer.BriefStmtPrinter;
import sootup.core.util.printer.LabeledStmtPrinter;
import sootup.core.util.printer.LegacyJimplePrinter;
import sootup.core.util.printer.NormalStmtPrinter;
import sootup.core.util.printer.StmtPrinter;

public class JimplePrinter {
    private final Set<Option> options = EnumSet.noneOf(Option.class);
    private static int jimpleLnNum = 0;

    public JimplePrinter(Option ... options) {
        this.options.addAll(Arrays.asList(options));
    }

    private boolean useAbbreviations() {
        return this.options.contains((Object)Option.UseAbbreviations);
    }

    private boolean addJimpleLn() {
        return this.options.contains((Object)Option.AddJimpleLn);
    }

    public void setOption(Option opt) {
        this.options.add(opt);
    }

    public void clearOption(Option opt) {
        this.options.remove((Object)opt);
    }

    public int getJimpleLnNum() {
        return jimpleLnNum;
    }

    public void setJimpleLnNum(int newVal) {
        jimpleLnNum = newVal;
    }

    public void incJimpleLnNum() {
        ++jimpleLnNum;
    }

    private LabeledStmtPrinter determinePrinter() {
        if (this.useAbbreviations()) {
            return new BriefStmtPrinter();
        }
        if (this.options.contains((Object)Option.LegacyMode)) {
            return new LegacyJimplePrinter();
        }
        return new NormalStmtPrinter();
    }

    public void printTo(SootClass<?> cl, PrintWriter out) {
        LabeledStmtPrinter printer = this.determinePrinter();
        printer.enableImports(this.options.contains((Object)Option.UseImports));
        this.setJimpleLnNum(1);
        EnumSet<Modifier> modifiers = EnumSet.copyOf(cl.getModifiers());
        if (cl.isInterface() && Modifier.isAbstract(modifiers)) {
            modifiers.remove((Object)Modifier.ABSTRACT);
        }
        if (modifiers.size() != 0) {
            printer.modifier(Modifier.toString(modifiers));
            printer.literal(" ");
        }
        if (!Modifier.isInterface(modifiers) && !Modifier.isAnnotation(modifiers)) {
            printer.literal("class ");
        }
        printer.typeSignature(cl.getType());
        Optional<ClassType> superclassSignature = cl.getSuperclass();
        superclassSignature.ifPresent(javaClassSignature -> {
            printer.literal(" extends ");
            printer.typeSignature((Type)javaClassSignature);
        });
        Iterator<ClassType> interfaceIt = cl.getInterfaces().iterator();
        if (interfaceIt.hasNext()) {
            printer.literal(" implements ");
            printer.typeSignature(interfaceIt.next());
            while (interfaceIt.hasNext()) {
                printer.literal(", ");
                printer.typeSignature(interfaceIt.next());
            }
        }
        printer.newline();
        this.incJimpleLnNum();
        printer.literal("{");
        this.incJimpleLnNum();
        Iterator<SootField> fieldIt = cl.getFields().iterator();
        if (fieldIt.hasNext()) {
            printer.incIndent();
            while (fieldIt.hasNext()) {
                SootField f = fieldIt.next();
                printer.newline();
                printer.handleIndent();
                printer.literal(f.getDeclaration());
                printer.literal(";");
                printer.newline();
                if (!this.addJimpleLn()) continue;
                this.setJimpleLnNum(this.addJimpleLnTags(this.getJimpleLnNum(), (FieldSignature)f.getSignature()));
            }
            printer.decIndent();
        }
        this.printMethods(cl, printer, out);
        printer.literal("}");
        printer.newline();
        this.incJimpleLnNum();
        if (this.options.contains((Object)Option.UseImports)) {
            Map<String, PackageName> entries = printer.getImports();
            entries.remove(cl.getType().getClassName());
            for (Map.Entry<String, PackageName> item : entries.entrySet()) {
                out.println("import " + item.getValue() + "." + item.getKey() + ";");
            }
            out.println();
        }
        out.println(printer.toString());
    }

    private void printMethods(SootClass<?> cl, LabeledStmtPrinter printer, PrintWriter out) {
        Iterator<SootMethod> methodIt = cl.getMethods().iterator();
        if (methodIt.hasNext()) {
            printer.incIndent();
            printer.newline();
            this.incJimpleLnNum();
            while (methodIt.hasNext()) {
                SootMethod method = methodIt.next();
                if (method.hasBody()) {
                    Body body = method.getBody();
                    method.toString(printer);
                    printer.newline();
                    this.printBody(body, printer);
                } else {
                    printer.handleIndent();
                    method.toString(printer);
                    printer.literal(";");
                    this.incJimpleLnNum();
                }
                if (!methodIt.hasNext()) continue;
                printer.newline();
                this.incJimpleLnNum();
            }
            printer.decIndent();
        }
    }

    public void printTo(Body body, PrintWriter out) {
        LabeledStmtPrinter printer = this.determinePrinter();
        printer.enableImports(this.options.contains((Object)Option.UseImports));
        this.printBody(body, printer);
        out.print(printer);
    }

    public void printTo(StmtGraph<?> graph, PrintWriter out) {
        LabeledStmtPrinter printer = this.determinePrinter();
        this.printStmts(graph, printer);
        out.print(printer);
    }

    private void printBody(Body b, LabeledStmtPrinter printer) {
        if (this.addJimpleLn()) {
            this.setJimpleLnNum(this.addJimpleLnTags(this.getJimpleLnNum(), b.getMethodSignature()));
        }
        printer.handleIndent();
        printer.literal("{");
        printer.newline();
        this.incJimpleLnNum();
        printer.incIndent();
        if (!this.options.contains((Object)Option.OmitLocalsDeclaration)) {
            this.printLocalsInBody(b, printer);
        }
        this.printStatementsInBody(b, printer);
        printer.decIndent();
        printer.handleIndent();
        printer.literal("}");
        this.incJimpleLnNum();
        printer.newline();
    }

    private void printStatementsInBody(Body body, LabeledStmtPrinter printer) {
        StmtGraph<?> stmtGraph = body.getStmtGraph();
        this.printStmts(stmtGraph, printer);
    }

    private void printStmts(StmtGraph<?> stmtGraph, LabeledStmtPrinter printer) {
        Iterable<Stmt> linearizedStmtGraph = printer.initializeSootMethod(stmtGraph);
        Map<Stmt, String> labels = printer.getLabels();
        Iterator<Stmt> iterator = linearizedStmtGraph.iterator();
        while (iterator.hasNext()) {
            boolean currentStmtHasLabel;
            Stmt currentStmt;
            Stmt previousStmt = currentStmt = iterator.next();
            boolean bl = currentStmtHasLabel = labels.get(currentStmt) != null;
            if (previousStmt.branches() || stmtGraph.predecessors(currentStmt).size() != 1 || previousStmt.getExpectedSuccessorCount() == 0 || currentStmtHasLabel) {
                printer.newline();
            }
            if (currentStmtHasLabel) {
                printer.stmtRef(currentStmt, true);
                printer.literal(":");
                printer.newline();
            }
            if (printer.getReferences().containsKey(currentStmt)) {
                printer.stmtRef(currentStmt, false);
            }
            printer.stmt(currentStmt);
            this.incJimpleLnNum();
        }
        Iterator<Trap> trapIt = stmtGraph.getTraps().iterator();
        if (trapIt.hasNext()) {
            printer.newline();
            this.incJimpleLnNum();
        }
        while (trapIt.hasNext()) {
            Trap trap = trapIt.next();
            printer.noIndent();
            printer.literal(" catch ");
            printer.typeSignature(trap.getExceptionType());
            printer.literal(" from ");
            printer.literal(labels.get(trap.getBeginStmt()));
            printer.literal(" to ");
            printer.literal(labels.get(trap.getEndStmt()));
            printer.literal(" with ");
            printer.literal(labels.get(trap.getHandlerStmt()));
            printer.literal(";");
            printer.newline();
            this.incJimpleLnNum();
        }
    }

    private int addJimpleLnTags(int lnNum, MethodSignature meth) {
        return ++lnNum;
    }

    private int addJimpleLnTags(int lnNum, FieldSignature f) {
        return ++lnNum;
    }

    private void printLocalsInBody(Body body, StmtPrinter up) {
        List<Local> localList;
        LinkedHashMap typeToLocals = new LinkedHashMap(body.getLocalCount() * 2 + 1, 0.7f);
        for (Local local : body.getLocals()) {
            Type t = local.getType();
            if (typeToLocals.containsKey(t)) {
                localList = (List)typeToLocals.get(t);
            } else {
                localList = new ArrayList();
                typeToLocals.put(t, localList);
            }
            localList.add(local);
        }
        for (Type type : typeToLocals.keySet()) {
            localList = new ArrayList((Collection)typeToLocals.get(type));
            up.typeSignature(type);
            up.literal(" ");
            int len = localList.size();
            if (len > 0) {
                up.local((Local)localList.get(0));
                for (int i = 1; i < len; ++i) {
                    up.literal(", ");
                    up.local((Local)localList.get(i));
                }
            }
            up.literal(";");
            up.newline();
        }
        if (!typeToLocals.isEmpty()) {
            up.newline();
        }
    }

    public static enum Option {
        UseAbbreviations,
        OmitLocalsDeclaration,
        AddJimpleLn,
        UseImports,
        LegacyMode;

    }
}

