/*
 * Decompiled with CFR 0.152.
 */
package sootup.core.views;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sootup.core.IdentifierFactory;
import sootup.core.Project;
import sootup.core.Scope;
import sootup.core.frontend.ResolveException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SootClass;
import sootup.core.model.SootField;
import sootup.core.model.SootMethod;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.transform.BodyInterceptor;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.types.ClassType;

public interface View<T extends SootClass> {
    public Project getProject();

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors(AnalysisInputLocation<T> var1);

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors();

    @Nonnull
    public Collection<T> getClasses();

    @Nonnull
    public Optional<T> getClass(@Nonnull ClassType var1);

    public Optional<? extends SootField> getField(@Nonnull FieldSignature var1);

    public Optional<? extends SootMethod> getMethod(@Nonnull MethodSignature var1);

    @Nonnull
    public Optional<Scope> getScope();

    @Nonnull
    public TypeHierarchy getTypeHierarchy();

    @Nonnull
    public IdentifierFactory getIdentifierFactory();

    @Nonnull
    default public T getClassOrThrow(@Nonnull ClassType classType) {
        return (T)((SootClass)this.getClass(classType).orElseThrow(() -> new ResolveException("Could not find " + classType + " in View.")));
    }

    public <K> void putModuleData(@Nonnull ModuleDataKey<K> var1, @Nonnull K var2);

    @Nullable
    public <K> K getModuleData(@Nonnull ModuleDataKey<K> var1);

    default public <K> K computeModuleDataIfAbsent(@Nonnull ModuleDataKey<K> key, Supplier<K> dataSupplier) {
        K moduleData = this.getModuleData(key);
        if (moduleData != null) {
            return moduleData;
        }
        K computedModuleData = dataSupplier.get();
        this.putModuleData(key, computedModuleData);
        return computedModuleData;
    }

    public static abstract class ModuleDataKey<K> {
    }
}

