/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import sootup.core.jimple.common.constant.BooleanConstant;
import sootup.core.jimple.common.constant.ClassConstant;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.DoubleConstant;
import sootup.core.jimple.common.constant.FloatConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.java.core.language.JavaJimple;

public class ConstantUtil {
    public static Constant fromObject(Object obj) {
        if (obj == null) {
            return NullConstant.getInstance();
        }
        if (obj instanceof Boolean) {
            return BooleanConstant.getInstance((Boolean)obj);
        }
        if (obj instanceof Float) {
            return FloatConstant.getInstance(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return DoubleConstant.getInstance((Double)obj);
        }
        if (obj instanceof Integer) {
            return IntConstant.getInstance((Integer)obj);
        }
        if (obj instanceof Long) {
            return LongConstant.getInstance((Long)obj);
        }
        if (obj instanceof String) {
            return JavaJimple.getInstance().newStringConstant((String)obj);
        }
        if (obj instanceof String[]) {
            String[] enumData = (String[])obj;
            return JavaJimple.getInstance().newEnumConstant(enumData[1], enumData[0]);
        }
        if (obj instanceof ClassConstant) {
            return JavaJimple.getInstance().newClassConstant(((ClassConstant)obj).getValue());
        }
        throw new IllegalArgumentException("cannot convert Object to (Soot-)Constant.");
    }
}

