/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import sootup.core.IdentifierFactory;
import sootup.core.model.SootClass;
import sootup.core.signatures.FieldSignature;
import sootup.core.signatures.FieldSubSignature;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.signatures.PackageName;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.types.VoidType;
import sootup.java.core.types.AnnotationType;
import sootup.java.core.types.JavaClassType;

public class JavaIdentifierFactory
implements IdentifierFactory {
    @Nonnull
    private static final JavaIdentifierFactory INSTANCE = new JavaIdentifierFactory();
    @Nonnull
    protected final Map<String, PackageName> packages = new HashMap<String, PackageName>();
    @Nonnull
    protected final Map<String, AnnotationType> annotationTypes = new HashMap<String, AnnotationType>();
    @Nonnull
    protected final Map<String, PrimitiveType> primitiveTypeMap = Maps.newHashMapWithExpectedSize(8);
    @Nonnull
    private static final Pattern SOOT_METHOD_SUB_SIGNATURE_PATTERN = Pattern.compile("^(?<return>[^\\s]+)\\s+(?<method>[^(]+)\\((?<args>[^)]+)?\\)$");
    @Nonnull
    private static final Pattern JAVADOCLIKE_METHOD_SUB_SIGNATURE_PATTERN = Pattern.compile("^#(?<method>[^(]+)\\((?<args>[^)]+)?\\)\\s*:(?<return>.+)$");
    @Nonnull
    private static final Pattern ARGS_SPLITTER_PATTERN = Pattern.compile(",", 16);
    @Nonnull
    private static final Pattern SOOT_FIELD_SIGNATURE_PATTERN = Pattern.compile("^<(?<class>[^:]+):\\s+(?<type>[^\\s]+)\\s+(?<field>.+)>$");
    @Nonnull
    private static final Pattern JAVADOCLIKE_FIELD_SIGNATURE_PATTERN = Pattern.compile("^(?<class>[^#]*)#(?<field>[^(]+):(?<type>.+)$");
    @Nonnull
    private static final Pattern SOOT_FIELD_SUB_SIGNATURE_PATTERN = Pattern.compile("^(?<type>[^\\s]+)\\s+(?<field>.+)$");
    @Nonnull
    private static final Pattern JAVADOCLIKE_FIELD_SUB_SIGNATURE_PATTERN = Pattern.compile("^#(?<field>[^(]+):(?<type>.+)$");

    public static JavaIdentifierFactory getInstance() {
        return INSTANCE;
    }

    JavaIdentifierFactory() {
        this.packages.put(PackageName.DEFAULT_PACKAGE.getPackageName(), PackageName.DEFAULT_PACKAGE);
        this.primitiveTypeMap.put(PrimitiveType.LongType.getInstance().getName(), PrimitiveType.LongType.getInstance());
        this.primitiveTypeMap.put(PrimitiveType.IntType.getInstance().getName(), PrimitiveType.IntType.getInstance());
        this.primitiveTypeMap.put(PrimitiveType.ShortType.getInstance().getName(), PrimitiveType.ShortType.getInstance());
        this.primitiveTypeMap.put(PrimitiveType.CharType.getInstance().getName(), PrimitiveType.CharType.getInstance());
        this.primitiveTypeMap.put(PrimitiveType.ByteType.getInstance().getName(), PrimitiveType.ByteType.getInstance());
        this.primitiveTypeMap.put(PrimitiveType.BooleanType.getInstance().getName(), PrimitiveType.BooleanType.getInstance());
        this.primitiveTypeMap.put(PrimitiveType.DoubleType.getInstance().getName(), PrimitiveType.DoubleType.getInstance());
        this.primitiveTypeMap.put(PrimitiveType.FloatType.getInstance().getName(), PrimitiveType.FloatType.getInstance());
    }

    @Override
    public JavaClassType getClassType(String className, String packageName) {
        PackageName packageIdentifier = this.getPackageName(packageName);
        return new JavaClassType(className, packageIdentifier);
    }

    @Override
    public JavaClassType getClassType(String fullyQualifiedClassName) {
        String className = ClassUtils.getShortClassName(fullyQualifiedClassName);
        String packageName = ClassUtils.getPackageName(fullyQualifiedClassName);
        return this.getClassType(className, packageName);
    }

    @Override
    public Type getType(String typeDesc) {
        Type ret;
        String typeName;
        int len = typeDesc.length();
        StringBuilder stringBuilder = new StringBuilder();
        int nrDims = 0;
        int closed = 0;
        block14: for (int i = 0; i < len; ++i) {
            char c = typeDesc.charAt(i);
            switch (c) {
                case '[': {
                    ++nrDims;
                    continue block14;
                }
                case ']': {
                    ++closed;
                    continue block14;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        if (nrDims != closed) {
            throw new IllegalArgumentException("Invalid type descriptor(" + typeDesc + ")");
        }
        switch (typeName = stringBuilder.toString()) {
            case "": {
                throw new IllegalArgumentException("Invalid! Typedescriptor is empty.");
            }
            case "null": {
                ret = NullType.getInstance();
                break;
            }
            case "void": {
                ret = VoidType.getInstance();
                break;
            }
            default: {
                ret = this.getPrimitiveType(typeName).map(obj -> obj).orElseGet(() -> this.getClassType(typeName));
            }
        }
        if (nrDims > 0) {
            ret = new ArrayType(ret, nrDims);
        }
        return ret;
    }

    @Override
    @Nonnull
    public Optional<PrimitiveType> getPrimitiveType(@Nonnull String typeName) {
        return Optional.ofNullable(this.primitiveTypeMap.get(typeName));
    }

    @Nonnull
    public Collection<PrimitiveType> getAllPrimitiveTypes() {
        return Collections.unmodifiableCollection(this.primitiveTypeMap.values());
    }

    @Override
    @Nonnull
    public JavaClassType getBoxedType(@Nonnull PrimitiveType primitiveType) {
        String name = primitiveType.getName();
        StringBuilder boxedname = new StringBuilder(name);
        boxedname.setCharAt(0, Character.toUpperCase(boxedname.charAt(0)));
        return this.getClassType(boxedname.toString(), "java.lang");
    }

    @Override
    public ArrayType getArrayType(Type baseType, int dim) {
        return new ArrayType(baseType, dim);
    }

    public AnnotationType getAnnotationType(String fullyQualifiedClassName) {
        String className = ClassUtils.getShortClassName(fullyQualifiedClassName);
        String packageName = ClassUtils.getPackageName(fullyQualifiedClassName);
        return this.annotationTypes.computeIfAbsent(className + packageName, k -> new AnnotationType(className, this.getPackageName(packageName)));
    }

    @Override
    @Nonnull
    public JavaClassType fromPath(@Nonnull Path rootDirectory, @Nonnull Path file) {
        String path = file.toString();
        String separator = file.getFileSystem().getSeparator();
        if (path.startsWith("/META-INF/")) {
            int index = StringUtils.ordinalIndexOf(path, separator, 4);
            path = path.substring(index);
        }
        int nameCountBaseDir = rootDirectory.toString().isEmpty() ? 0 : rootDirectory.getNameCount();
        String fullyQualifiedName = FilenameUtils.removeExtension(file.subpath(nameCountBaseDir, file.getNameCount()).toString().replace(separator, "."));
        return this.getClassType(fullyQualifiedName);
    }

    @Override
    public PackageName getPackageName(@Nonnull String packageName) {
        return this.packages.computeIfAbsent(packageName, name -> new PackageName((String)name));
    }

    @Override
    public MethodSignature getMethodSignature(String methodName, String fullyQualifiedNameDeclClass, String fqReturnType, List<String> parameters) {
        JavaClassType declaringClass = this.getClassType(fullyQualifiedNameDeclClass);
        Type returnType = this.getType(fqReturnType);
        ArrayList<Type> parameterSignatures = new ArrayList<Type>();
        for (String fqParameterName : parameters) {
            Type parameterSignature = this.getType(fqParameterName);
            parameterSignatures.add(parameterSignature);
        }
        return new MethodSignature(declaringClass, methodName, parameterSignatures, returnType);
    }

    @Override
    public MethodSignature getMethodSignature(ClassType declaringClassSignature, String methodName, String fqReturnType, List<String> parameters) {
        Type returnType = this.getType(fqReturnType);
        ArrayList<Type> parameterSignatures = new ArrayList<Type>();
        for (String fqParameterName : parameters) {
            Type parameterSignature = this.getType(fqParameterName);
            parameterSignatures.add(parameterSignature);
        }
        return new MethodSignature(declaringClassSignature, methodName, parameterSignatures, returnType);
    }

    @Override
    public MethodSignature getMethodSignature(ClassType declaringClassSignature, String methodName, Type fqReturnType, List<Type> parameters) {
        return new MethodSignature(declaringClassSignature, methodName, parameters, fqReturnType);
    }

    @Override
    @Nonnull
    public MethodSignature getMethodSignature(@Nonnull SootClass declaringClass, @Nonnull MethodSubSignature subSignature) {
        return this.getMethodSignature(declaringClass.getType(), subSignature);
    }

    @Override
    @Nonnull
    public MethodSignature getMethodSignature(@Nonnull ClassType declaringClassSignature, @Nonnull MethodSubSignature subSignature) {
        return new MethodSignature(declaringClassSignature, subSignature);
    }

    @Override
    @Nonnull
    public MethodSignature parseMethodSignature(@Nonnull String methodSignature) {
        Matcher matcher = MethodSignatureParserPatternHolder.SOOT_METHOD_SIGNATURE_PATTERN.matcher(methodSignature);
        if (!matcher.find() && !(matcher = MethodSignatureParserPatternHolder.JAVADOCLIKE_METHOD_SIGNATURE_PATTERN.matcher(methodSignature)).find()) {
            throw MethodSignatureParserPatternHolder.createInvalidMethodSignatureException();
        }
        String className = matcher.group("class").trim();
        String methodName = matcher.group("method").trim();
        String returnName = matcher.group("return").trim();
        if (className.isEmpty() || methodName.isEmpty() || returnName.isEmpty()) {
            throw MethodSignatureParserPatternHolder.createInvalidMethodSignatureException();
        }
        String argsGroup = matcher.group("args");
        List<String> argsList = argsGroup == null ? Collections.emptyList() : Arrays.stream(MethodSignatureParserPatternHolder.ARGS_SPLITTER_PATTERN.split(argsGroup, -1)).map(String::trim).filter(it -> {
            if (it.isEmpty()) {
                throw MethodSignatureParserPatternHolder.createInvalidMethodSignatureException();
            }
            return true;
        }).collect(Collectors.toList());
        return this.getMethodSignature(methodName, className, returnName, argsList);
    }

    @Override
    @Nonnull
    public MethodSubSignature getMethodSubSignature(@Nonnull String name, @Nonnull Type returnType, @Nonnull Iterable<? extends Type> parameterSignatures) {
        return new MethodSubSignature(name, parameterSignatures, returnType);
    }

    @Nonnull
    private static IllegalArgumentException createInvalidMethodSubSignatureException() {
        return new IllegalArgumentException("Invalid method sub-signature.\n\nThe method sub-signature must be conform either to the Soot syntax (\"<RETURNTYPE METHOD(PARAM1, PARAM2, PARAM3)>\") or to the JavaDoc-like syntax (\"#METHOD(PARAM1, PARAM2, PARAM3): RETURNTYPE\").");
    }

    @Override
    @Nonnull
    public MethodSubSignature parseMethodSubSignature(@Nonnull String subSignature) {
        Matcher matcher = JAVADOCLIKE_METHOD_SUB_SIGNATURE_PATTERN.matcher(subSignature);
        if (!matcher.find() && !(matcher = SOOT_METHOD_SUB_SIGNATURE_PATTERN.matcher(subSignature)).find()) {
            throw JavaIdentifierFactory.createInvalidMethodSubSignatureException();
        }
        String methodName = matcher.group("method").trim();
        String returnName = matcher.group("return").trim();
        if (methodName.isEmpty() || returnName.isEmpty()) {
            throw JavaIdentifierFactory.createInvalidMethodSubSignatureException();
        }
        String argsGroup = matcher.group("args");
        List argsList = argsGroup == null ? Collections.emptyList() : Arrays.stream(ARGS_SPLITTER_PATTERN.split(argsGroup, -1)).map(String::trim).filter(it -> {
            if (it.isEmpty()) {
                throw JavaIdentifierFactory.createInvalidMethodSubSignatureException();
            }
            return true;
        }).map(typeName -> this.getType((String)typeName)).collect(Collectors.toList());
        return this.getMethodSubSignature(methodName, this.getType(returnName), argsList);
    }

    @Nonnull
    private static IllegalArgumentException createInvalidFieldSignatureException() {
        return new IllegalArgumentException("Invalid field signature.\n\nThe field signature must be conform either to the Soot syntax (\"<CLASS: TYPE FIELD>\") or to the JavaDoc-like syntax (\"CLASS#FIELD: TYPE\").");
    }

    @Override
    @Nonnull
    public FieldSignature parseFieldSignature(@Nonnull String fieldSignature) {
        Matcher matcher = SOOT_FIELD_SIGNATURE_PATTERN.matcher(fieldSignature);
        if (!matcher.find() && !(matcher = JAVADOCLIKE_FIELD_SIGNATURE_PATTERN.matcher(fieldSignature)).find()) {
            throw JavaIdentifierFactory.createInvalidFieldSignatureException();
        }
        String className = matcher.group("class").trim();
        String fieldName = matcher.group("field").trim();
        String typeName = matcher.group("type").trim();
        if (className.isEmpty() || fieldName.isEmpty() || typeName.isEmpty()) {
            throw JavaIdentifierFactory.createInvalidFieldSignatureException();
        }
        return this.getFieldSignature(fieldName, (ClassType)this.getClassType(className), typeName);
    }

    @Override
    public FieldSignature getFieldSignature(String fieldName, ClassType declaringClassSignature, String fieldType) {
        Type type = this.getType(fieldType);
        return new FieldSignature(declaringClassSignature, fieldName, type);
    }

    @Override
    public FieldSignature getFieldSignature(String fieldName, ClassType declaringClassSignature, Type fieldType) {
        return new FieldSignature(declaringClassSignature, fieldName, fieldType);
    }

    @Override
    @Nonnull
    public FieldSignature getFieldSignature(@Nonnull ClassType declaringClassSignature, @Nonnull FieldSubSignature subSignature) {
        return new FieldSignature(declaringClassSignature, subSignature);
    }

    @Override
    @Nonnull
    public FieldSubSignature getFieldSubSignature(@Nonnull String name, @Nonnull Type type) {
        return new FieldSubSignature(name, type);
    }

    @Nonnull
    private static IllegalArgumentException createInvalidFieldSubSignatureException() {
        return new IllegalArgumentException("Invalid field sub-signature.\n\nThe field sub-signature must be conform either to the Soot syntax (\"<TYPE FIELD>\") or to the JavaDoc-like syntax (\"#FIELD: TYPE\").");
    }

    @Override
    @Nonnull
    public FieldSubSignature parseFieldSubSignature(@Nonnull String subSignature) {
        Matcher matcher = JAVADOCLIKE_FIELD_SUB_SIGNATURE_PATTERN.matcher(subSignature);
        if (!matcher.find() && !(matcher = SOOT_FIELD_SUB_SIGNATURE_PATTERN.matcher(subSignature)).find()) {
            throw JavaIdentifierFactory.createInvalidFieldSubSignatureException();
        }
        String fieldName = matcher.group("field").trim();
        String typeName = matcher.group("type").trim();
        if (fieldName.isEmpty() || typeName.isEmpty()) {
            throw JavaIdentifierFactory.createInvalidFieldSubSignatureException();
        }
        return this.getFieldSubSignature(fieldName, this.getType(typeName));
    }

    private static final class MethodSignatureParserPatternHolder {
        @Nonnull
        private static final Pattern SOOT_METHOD_SIGNATURE_PATTERN = Pattern.compile("^<(?<class>[^:]+):\\s+(?<return>[^\\s]+)\\s+(?<method>[^(]+)\\((?<args>[^)]+)?\\)>$");
        @Nonnull
        private static final Pattern JAVADOCLIKE_METHOD_SIGNATURE_PATTERN = Pattern.compile("^(?<class>[^#]+)#(?<method>[^(]+)\\((?<args>[^)]+)?\\)\\s*:(?<return>.+)$");
        @Nonnull
        private static final Pattern ARGS_SPLITTER_PATTERN = Pattern.compile(",", 16);

        private MethodSignatureParserPatternHolder() {
        }

        @Nonnull
        private static IllegalArgumentException createInvalidMethodSignatureException() {
            return new IllegalArgumentException("Invalid method signature.\n\nThe method signature must be conform either to the Soot syntax (\"<CLASS: RETURNTYPE METHOD(PARAM1, PARAM2, PARAM3)>\") or to the JavaDoc-like syntax (\"CLASS#METHOD(PARAM1, PARAM2, PARAM3): RETURNTYPE\").");
        }
    }
}

