/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import sootup.core.SourceTypeSpecifier;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.ClassLoadingOptions;
import sootup.java.core.JavaModuleIdentifierFactory;
import sootup.java.core.JavaProject;
import sootup.java.core.JavaSootClass;
import sootup.java.core.ModuleInfoAnalysisInputLocation;
import sootup.java.core.language.JavaLanguage;
import sootup.java.core.views.JavaModuleView;

public class JavaModuleProject
extends JavaProject {
    @Nonnull
    private final List<ModuleInfoAnalysisInputLocation> moduleInfoAnalysisInputLocation;

    public JavaModuleProject(JavaLanguage language, @Nonnull List<AnalysisInputLocation<? extends JavaSootClass>> inputLocations, @Nonnull List<ModuleInfoAnalysisInputLocation> moduleInputLocations, @Nonnull SourceTypeSpecifier sourceTypeSpecifier) {
        super(language, inputLocations, sourceTypeSpecifier);
        this.moduleInfoAnalysisInputLocation = moduleInputLocations;
    }

    @Override
    @Nonnull
    public JavaModuleIdentifierFactory getIdentifierFactory() {
        return JavaModuleIdentifierFactory.getInstance();
    }

    @Override
    public void validate() {
        if (this.getInputLocations().isEmpty() && this.getModuleInfoAnalysisInputLocation().isEmpty()) {
            throw new IllegalArgumentException("The inputLocations collection for classPath and modulePath must not be empty.");
        }
    }

    @Nonnull
    public List<ModuleInfoAnalysisInputLocation> getModuleInfoAnalysisInputLocation() {
        return this.moduleInfoAnalysisInputLocation;
    }

    @Override
    @Nonnull
    public JavaModuleView createOnDemandView() {
        return new JavaModuleView(this);
    }

    @Override
    @Nonnull
    public JavaModuleView createOnDemandView(@Nonnull Function<AnalysisInputLocation<? extends JavaSootClass>, ClassLoadingOptions> classLoadingOptionsSpecifier) {
        return new JavaModuleView(this, classLoadingOptionsSpecifier);
    }
}

