/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import sootup.core.frontend.BodySource;
import sootup.core.frontend.OverridingBodySource;
import sootup.core.model.Body;
import sootup.core.model.Modifier;
import sootup.core.model.Position;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.types.ClassType;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.views.JavaView;

public class JavaSootMethod
extends SootMethod {
    @Nonnull
    protected static final String CONSTRUCTOR_NAME = "<init>";
    @Nonnull
    protected static final String STATIC_INITIALIZER_NAME = "<clinit>";
    @Nonnull
    private final Iterable<AnnotationUsage> annotations;

    public JavaSootMethod(@Nonnull BodySource source, @Nonnull MethodSignature methodSignature, @Nonnull Iterable<Modifier> modifiers, @Nonnull Iterable<ClassType> thrownExceptions, @Nonnull Iterable<AnnotationUsage> annotations, @Nonnull Position position) {
        super(source, methodSignature, modifiers, thrownExceptions, position);
        this.annotations = annotations;
    }

    public boolean isConstructor() {
        return ((MethodSignature)this.getSignature()).getName().equals(CONSTRUCTOR_NAME);
    }

    public boolean isStaticInitializer() {
        return ((MethodSignature)this.getSignature()).getName().equals(STATIC_INITIALIZER_NAME);
    }

    @Nonnull
    public Iterable<AnnotationUsage> getAnnotations(@Nonnull Optional<JavaView> view) {
        this.annotations.forEach(e -> e.getAnnotation().getDefaultValues(view));
        this.resolveDefaultsForAnnotationTypes(view, this.annotations);
        return this.annotations;
    }

    private void resolveDefaultsForAnnotationTypes(@Nonnull Optional<JavaView> view, Iterable<AnnotationUsage> annotationUsages) {
        for (AnnotationUsage annotationUsage : annotationUsages) {
            annotationUsage.getAnnotation().getDefaultValues(view);
            for (Object value : annotationUsage.getValuesWithDefaults().values()) {
                if (!(value instanceof ArrayList) || ((ArrayList)value).isEmpty() || !(((ArrayList)value).get(0) instanceof AnnotationUsage)) continue;
                this.resolveDefaultsForAnnotationTypes(view, (ArrayList)value);
            }
        }
    }

    @Override
    @Nonnull
    public JavaSootMethod withOverridingMethodSource(@Nonnull Function<OverridingBodySource, OverridingBodySource> overrider) {
        return new JavaSootMethod(overrider.apply(new OverridingBodySource(this.bodySource)), (MethodSignature)this.getSignature(), this.getModifiers(), this.exceptions, this.getAnnotations(Optional.empty()), this.getPosition());
    }

    @Override
    @Nonnull
    public JavaSootMethod withSource(@Nonnull BodySource source) {
        return new JavaSootMethod(source, (MethodSignature)this.getSignature(), this.getModifiers(), this.exceptions, this.getAnnotations(Optional.empty()), this.getPosition());
    }

    @Override
    @Nonnull
    public JavaSootMethod withModifiers(@Nonnull Iterable<Modifier> modifiers) {
        return new JavaSootMethod(this.bodySource, (MethodSignature)this.getSignature(), modifiers, this.getExceptionSignatures(), this.getAnnotations(Optional.empty()), this.getPosition());
    }

    @Override
    @Nonnull
    public JavaSootMethod withThrownExceptions(@Nonnull Iterable<ClassType> thrownExceptions) {
        return new JavaSootMethod(this.bodySource, (MethodSignature)this.getSignature(), this.getModifiers(), thrownExceptions, this.getAnnotations(Optional.empty()), this.getPosition());
    }

    @Nonnull
    public JavaSootMethod withAnnotations(@Nonnull Iterable<AnnotationUsage> annotations) {
        return new JavaSootMethod(this.bodySource, (MethodSignature)this.getSignature(), this.getModifiers(), this.getExceptionSignatures(), annotations, this.getPosition());
    }

    @Override
    @Nonnull
    public JavaSootMethod withBody(@Nonnull Body body) {
        return new JavaSootMethod(new OverridingBodySource(this.bodySource).withBody(body), (MethodSignature)this.getSignature(), this.getModifiers(), this.exceptions, this.getAnnotations(Optional.empty()), this.getPosition());
    }

    @Nonnull
    public static AnnotationOrSignatureStep builder() {
        return new JavaSootMethodBuilder();
    }

    public static class JavaSootMethodBuilder
    extends SootMethod.SootMethodBuilder
    implements AnnotationOrSignatureStep {
        private Iterable<AnnotationUsage> annotations = null;

        @Nonnull
        public Iterable<AnnotationUsage> getAnnotations() {
            return this.annotations != null ? this.annotations : Collections.emptyList();
        }

        @Override
        @Nonnull
        public SootMethod.BuildStep withAnnotation(@Nonnull Iterable<AnnotationUsage> annotations) {
            this.annotations = annotations;
            return this;
        }

        @Override
        @Nonnull
        public JavaSootMethod build() {
            return new JavaSootMethod(this.getSource(), this.getSignature(), this.getModifiers(), this.getThrownExceptions(), this.getAnnotations(), this.getPosition());
        }
    }

    public static interface AnnotationOrSignatureStep
    extends SootMethod.MethodSourceStep {
        public SootMethod.BuildStep withAnnotation(@Nonnull Iterable<AnnotationUsage> var1);
    }
}

