/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core.jimple.basic;

import java.util.Objects;
import javax.annotation.Nonnull;
import sootup.core.jimple.basic.Local;
import sootup.core.types.Type;
import sootup.java.core.AnnotationUsage;

public class JavaLocal
extends Local {
    @Nonnull
    private final Iterable<AnnotationUsage> annotations;

    public JavaLocal(@Nonnull String name, @Nonnull Type type, @Nonnull Iterable<AnnotationUsage> annotations) {
        super(name, type);
        this.annotations = annotations;
    }

    @Nonnull
    public Iterable<AnnotationUsage> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean equals(Object o) {
        return this.equivTo(o) && ((JavaLocal)o).getAnnotations().equals(this.getAnnotations());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.getType(), this.getAnnotations());
    }

    @Override
    @Nonnull
    public Local withName(@Nonnull String name) {
        return new JavaLocal(name, this.getType(), this.getAnnotations());
    }

    @Override
    @Nonnull
    public Local withType(@Nonnull Type type) {
        return new JavaLocal(this.getName(), type, this.getAnnotations());
    }

    @Nonnull
    public Local withAnnotations(@Nonnull Iterable<AnnotationUsage> annotations) {
        return new JavaLocal(this.getName(), this.getType(), annotations);
    }
}

