/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core.types;

import com.google.common.base.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import sootup.core.signatures.PackageName;
import sootup.core.types.ClassType;
import sootup.java.core.signatures.ModulePackageName;

public class JavaClassType
extends ClassType {
    private static final Pattern LIBRARY_CLASS_PATTERN = Pattern.compile("^(?:java\\.|sun\\.|javax\\.|com\\.sun\\.|org\\.omg\\.|org\\.xml\\.|org\\.w3c\\.dom|jdk|com\\.oracle\\.|org\\.ietf\\.|org\\.jcp\\.)");
    @Nonnull
    private final String className;
    @Nonnull
    private final PackageName packageName;

    public JavaClassType(@Nonnull String className, @Nonnull PackageName packageName) {
        String realClassName = className;
        if (realClassName.contains(".")) {
            realClassName = realClassName.replace('.', '$');
        }
        this.className = realClassName;
        this.packageName = packageName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaClassType that = (JavaClassType)o;
        return Objects.equal(this.className, that.className) && Objects.equal(this.packageName, that.packageName);
    }

    public int hashCode() {
        return Objects.hashCode(this.className, this.packageName);
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder sb = new StringBuilder();
        if (!this.packageName.getPackageName().isEmpty()) {
            sb.append(this.packageName.getPackageName());
            sb.append('.');
        }
        sb.append(this.className);
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String packageNameStr = this.packageName.toString();
        if (!packageNameStr.isEmpty()) {
            sb.append(this.packageName);
            if (!this.packageName.getPackageName().isEmpty()) {
                sb.append('.');
            }
        }
        sb.append(this.className);
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getClassName() {
        return this.className;
    }

    @Override
    @Nonnull
    public PackageName getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean isBuiltInClass() {
        PackageName packageName = this.getPackageName();
        if (packageName instanceof ModulePackageName) {
            String moduleName = ((ModulePackageName)packageName).getModuleSignature().toString();
            return moduleName.startsWith("java.") || moduleName.startsWith("jdk.");
        }
        return LIBRARY_CLASS_PATTERN.matcher(packageName.getPackageName()).find();
    }
}

