/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core.views;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import sootup.core.Project;
import sootup.core.frontend.AbstractClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.ClassLoadingOptions;
import sootup.core.inputlocation.EmptyClassLoadingOptions;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.AbstractView;
import sootup.java.core.AnnotationUsage;
import sootup.java.core.JavaAnnotationSootClass;
import sootup.java.core.JavaSootClass;
import sootup.java.core.types.AnnotationType;

public class JavaView
extends AbstractView<JavaSootClass> {
    @Nonnull
    protected final Map<ClassType, JavaSootClass> cache = new HashMap<ClassType, JavaSootClass>();
    protected volatile boolean isFullyResolved = false;
    @Nonnull
    protected Function<AnalysisInputLocation<? extends JavaSootClass>, ClassLoadingOptions> classLoadingOptionsSpecifier;

    public JavaView(@Nonnull Project<JavaSootClass, ? extends JavaView> project) {
        this(project, analysisInputLocation -> EmptyClassLoadingOptions.Default);
    }

    public JavaView(@Nonnull Project<JavaSootClass, ? extends JavaView> project, @Nonnull Function<AnalysisInputLocation<? extends JavaSootClass>, ClassLoadingOptions> classLoadingOptionsSpecifier) {
        super(project);
        this.classLoadingOptionsSpecifier = classLoadingOptionsSpecifier;
    }

    @Override
    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors(AnalysisInputLocation<JavaSootClass> clazz) {
        return this.classLoadingOptionsSpecifier.apply(clazz) != null ? this.classLoadingOptionsSpecifier.apply(clazz).getBodyInterceptors() : this.getBodyInterceptors();
    }

    @Override
    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public synchronized Collection<JavaSootClass> getClasses() {
        this.resolveAll();
        return this.cache.values();
    }

    @Override
    @Nonnull
    public synchronized Optional<JavaSootClass> getClass(@Nonnull ClassType type) {
        JavaSootClass cachedClass = this.cache.get(type);
        if (cachedClass != null) {
            return Optional.of(cachedClass);
        }
        Optional<? extends AbstractClassSource<? extends JavaSootClass>> abstractClass = this.getAbstractClass(type);
        if (!abstractClass.isPresent()) {
            return Optional.empty();
        }
        return this.buildClassFrom(abstractClass.get());
    }

    @Nonnull
    protected Optional<? extends AbstractClassSource<? extends JavaSootClass>> getAbstractClass(@Nonnull ClassType type) {
        return this.getProject().getInputLocations().stream().map(location -> location.getClassSource(type, this)).filter(Optional::isPresent).limit(1L).map(Optional::get).findAny();
    }

    @Nonnull
    protected synchronized Optional<JavaSootClass> buildClassFrom(AbstractClassSource<? extends JavaSootClass> classSource) {
        JavaSootClass theClass = this.cache.computeIfAbsent(classSource.getClassType(), type -> (JavaSootClass)classSource.buildClass(this.getProject().getSourceTypeSpecifier().sourceTypeFor(classSource)));
        if (theClass.getType() instanceof AnnotationType) {
            JavaAnnotationSootClass jasc = (JavaAnnotationSootClass)theClass;
            jasc.getAnnotations(Optional.of(this)).forEach(AnnotationUsage::getValuesWithDefaults);
        }
        return Optional.of(theClass);
    }

    protected synchronized void resolveAll() {
        if (this.isFullyResolved) {
            return;
        }
        this.getProject().getInputLocations().stream().flatMap(location -> location.getClassSources(this).stream()).forEach(this::buildClassFrom);
        this.isFullyResolved = true;
    }
}

