/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.core.views;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.core.Project;
import sootup.core.ViewChangeListener;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ClassType;
import sootup.core.views.MutableView;
import sootup.java.core.JavaSootClass;
import sootup.java.core.JavaSootMethod;
import sootup.java.core.views.JavaView;

public class MutableJavaView
extends JavaView
implements MutableView {
    private final List<ViewChangeListener> changeListeners = new LinkedList<ViewChangeListener>();
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(MutableJavaView.class);

    public MutableJavaView(@Nonnull Project<JavaSootClass, ? extends JavaView> project) {
        super(project);
    }

    public void addClass(JavaSootClass clazz) {
        ClassType classType = clazz.getClassSource().getClassType();
        if (this.cache.containsKey(classType)) {
            logger.warn("Class " + classType + " already exists in view.");
            return;
        }
        this.cache.putIfAbsent(classType, clazz);
        this.fireAddition(clazz);
    }

    public void removeClass(ClassType classType) {
        JavaSootClass removedClass = (JavaSootClass)this.cache.remove(classType);
        this.fireRemoval(removedClass);
    }

    public void removeClass(JavaSootClass clazz) {
        ClassType classType = clazz.getClassSource().getClassType();
        this.removeClass(classType);
    }

    public void replaceClass(JavaSootClass oldClass, JavaSootClass newClass) {
        this.removeClass(oldClass);
        this.addClass(newClass);
    }

    public void removeMethod(JavaSootMethod method) {
        ClassType classType = method.getDeclaringClassType();
        MethodSubSignature mss = (MethodSubSignature)((MethodSignature)method.getSignature()).getSubSignature();
        JavaSootClass clazz = (JavaSootClass)this.cache.get(classType);
        if (clazz == null) {
            return;
        }
        Set<? extends JavaSootMethod> methods = clazz.getMethods();
        Set<SootMethod> filteredMethods = methods.stream().filter(met -> !((MethodSubSignature)((MethodSignature)met.getSignature()).getSubSignature()).equals(mss)).collect(Collectors.toSet());
        JavaSootClass newClazz = clazz.withMethods(filteredMethods);
        this.replaceClass(clazz, newClazz);
        this.fireRemoval(method);
    }

    public void addMethod(JavaSootMethod method) {
        ClassType classType = method.getDeclaringClassType();
        JavaSootClass clazz = (JavaSootClass)this.cache.get(classType);
        if (clazz == null) {
            return;
        }
        Set<? extends JavaSootMethod> methods = clazz.getMethods();
        HashSet<SootMethod> newMethods = new HashSet<SootMethod>(methods);
        newMethods.add(method);
        JavaSootClass newClazz = clazz.withMethods(newMethods);
        this.replaceClass(clazz, newClazz);
        this.fireAddition(method);
    }

    public void replaceMethod(JavaSootMethod oldMethod, JavaSootMethod newMethod) {
        this.removeMethod(oldMethod);
        this.addMethod(newMethod);
    }

    @Override
    public void addChangeListener(ViewChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ViewChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    private void fireAddition(JavaSootClass clazz) {
        for (ViewChangeListener viewChangeListener : this.changeListeners) {
            viewChangeListener.classAdded(clazz);
        }
    }

    private void fireAddition(JavaSootMethod method) {
        for (ViewChangeListener viewChangeListener : this.changeListeners) {
            viewChangeListener.methodAdded(method);
        }
    }

    private void fireRemoval(JavaSootClass clazz) {
        for (ViewChangeListener viewChangeListener : this.changeListeners) {
            viewChangeListener.classRemoved(clazz);
        }
    }

    private void fireRemoval(JavaSootMethod method) {
        for (ViewChangeListener viewChangeListener : this.changeListeners) {
            viewChangeListener.methodRemoved(method);
        }
    }
}

