/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sootup.callgraph.CallGraph;
import sootup.callgraph.CallGraphAlgorithm;
import sootup.callgraph.GraphBasedCallGraph;
import sootup.callgraph.InstantiateClassValueVisitor;
import sootup.callgraph.MutableCallGraph;
import sootup.core.IdentifierFactory;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.ref.JStaticFieldRef;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.ValueVisitor;
import sootup.core.model.Method;
import sootup.core.model.SootClass;
import sootup.core.model.SootClassMember;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.signatures.SootClassMemberSignature;
import sootup.core.typehierarchy.HierarchyComparator;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.java.core.JavaIdentifierFactory;
import sootup.java.core.types.JavaClassType;

public abstract class AbstractCallGraphAlgorithm
implements CallGraphAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCallGraphAlgorithm.class);
    @Nonnull
    protected final View view;

    protected AbstractCallGraphAlgorithm(@Nonnull View view) {
        this.view = view;
    }

    @Nonnull
    final CallGraph constructCompleteCallGraph(View view, List<MethodSignature> entryPoints) {
        MutableCallGraph cg = this.initializeCallGraph();
        ArrayDeque<MethodSignature> workList = new ArrayDeque<MethodSignature>(entryPoints);
        HashSet<MethodSignature> processed = new HashSet<MethodSignature>();
        this.addImplicitEdgesOfEntryPoints(entryPoints, cg, workList);
        this.processWorkList(view, workList, processed, cg);
        return cg;
    }

    protected MutableCallGraph initializeCallGraph() {
        return new GraphBasedCallGraph();
    }

    protected void addImplicitEdgesOfEntryPoints(List<MethodSignature> entryPoints, MutableCallGraph cg, Deque<MethodSignature> workList) {
        entryPoints.forEach(methodSignature -> {
            SootMethod clintMethod = this.view.getMethod(methodSignature.getDeclClassType().getStaticInitializer()).orElse(null);
            if (clintMethod == null) {
                return;
            }
            MethodSignature staticInitSig = (MethodSignature)clintMethod.getSignature();
            if (!cg.containsMethod((MethodSignature)methodSignature)) {
                cg.addMethod((MethodSignature)methodSignature);
            }
            if (!cg.containsMethod(staticInitSig)) {
                cg.addMethod(staticInitSig);
            }
            if (!cg.containsCall((MethodSignature)methodSignature, staticInitSig)) {
                cg.addCall((MethodSignature)methodSignature, staticInitSig);
                workList.push(staticInitSig);
            }
        });
    }

    final void processWorkList(View view, Deque<MethodSignature> workList, Set<MethodSignature> processed, MutableCallGraph cg) {
        while (!workList.isEmpty()) {
            SootClass currentClass;
            MethodSignature currentMethodSignature = workList.pop();
            if (processed.contains(currentMethodSignature) || (currentClass = (SootClass)view.getClass(currentMethodSignature.getDeclClassType()).orElse(null)) == null || currentClass.isLibraryClass()) continue;
            this.preProcessingMethod(view, currentMethodSignature, workList, cg);
            if (!cg.containsMethod(currentMethodSignature)) {
                cg.addMethod(currentMethodSignature);
            }
            SootMethod currentMethod = currentClass.getMethod((MethodSubSignature)currentMethodSignature.getSubSignature()).orElse(null);
            Stream<MethodSignature> invocationTargets = this.resolveAllCallsFromSourceMethod(currentMethod);
            Stream<MethodSignature> implicitTargets = this.resolveAllImplicitCallsFromSourceMethod(view, currentMethod);
            Stream.concat(invocationTargets, implicitTargets).forEach(t -> {
                if (!cg.containsMethod((MethodSignature)t)) {
                    cg.addMethod((MethodSignature)t);
                }
                if (!cg.containsCall(currentMethodSignature, (MethodSignature)t)) {
                    cg.addCall(currentMethodSignature, (MethodSignature)t);
                    workList.push((MethodSignature)t);
                }
            });
            processed.add(currentMethodSignature);
            this.postProcessingMethod(view, currentMethodSignature, workList, cg);
        }
    }

    @Nonnull
    Stream<MethodSignature> resolveAllCallsFromSourceMethod(SootMethod sourceMethod) {
        if (sourceMethod == null || !sourceMethod.hasBody()) {
            return Stream.empty();
        }
        return sourceMethod.getBody().getStmts().stream().filter(Stmt::containsInvokeExpr).flatMap(s -> this.resolveCall(sourceMethod, s.getInvokeExpr()));
    }

    @Nonnull
    protected Stream<MethodSignature> resolveAllImplicitCallsFromSourceMethod(View view, SootMethod sourceMethod) {
        if (sourceMethod == null || !sourceMethod.hasBody()) {
            return Stream.empty();
        }
        return this.resolveAllStaticInitializerCallsFromSourceMethod(view, sourceMethod);
    }

    @Nonnull
    protected Stream<MethodSignature> resolveAllStaticInitializerCallsFromSourceMethod(View view, SootMethod sourceMethod) {
        if (sourceMethod == null || !sourceMethod.hasBody()) {
            return Stream.empty();
        }
        Stream.Builder targetsToStaticInitializer = Stream.builder();
        InstantiateClassValueVisitor instantiateVisitor = new InstantiateClassValueVisitor();
        sourceMethod.getBody().getStmts().forEach(stmt -> {
            if (stmt.containsFieldRef() && stmt.getFieldRef() instanceof JStaticFieldRef) {
                targetsToStaticInitializer.add(stmt.getFieldRef().getFieldSignature().getDeclClassType());
            }
            if (stmt instanceof JAssignStmt) {
                Value rightOp = ((JAssignStmt)stmt).getRightOp();
                instantiateVisitor.init();
                rightOp.accept((ValueVisitor)instantiateVisitor);
                ClassType classType = (ClassType)instantiateVisitor.getResult();
                if (classType != null) {
                    targetsToStaticInitializer.add(classType);
                }
            }
            if (stmt.containsInvokeExpr() && stmt.getInvokeExpr() instanceof JStaticInvokeExpr) {
                targetsToStaticInitializer.add(stmt.getInvokeExpr().getMethodSignature().getDeclClassType());
            }
        });
        return targetsToStaticInitializer.build().flatMap(classType -> Stream.concat(Stream.of(classType), view.getTypeHierarchy().superClassesOf(classType).stream())).filter(Objects::nonNull).map(classType -> view.getMethod(classType.getStaticInitializer())).filter(Optional::isPresent).map(Optional::get).map(SootClassMember::getSignature);
    }

    protected abstract void preProcessingMethod(View var1, MethodSignature var2, @Nonnull Deque<MethodSignature> var3, @Nonnull MutableCallGraph var4);

    protected abstract void postProcessingMethod(View var1, MethodSignature var2, @Nonnull Deque<MethodSignature> var3, @Nonnull MutableCallGraph var4);

    @Override
    @Nonnull
    public CallGraph addClass(@Nonnull CallGraph oldCallGraph, @Nonnull JavaClassType classType) {
        SootClass clazz = this.view.getClassOrThrow((ClassType)classType);
        Set newMethodSignatures = clazz.getMethods().stream().map(Method::getSignature).filter(methodSig -> !oldCallGraph.containsMethod((MethodSignature)methodSig)).collect(Collectors.toSet());
        if (newMethodSignatures.isEmpty()) {
            return oldCallGraph;
        }
        MutableCallGraph updated = oldCallGraph.copy();
        ArrayDeque<MethodSignature> workList = new ArrayDeque<MethodSignature>(newMethodSignatures);
        HashSet<MethodSignature> processed = new HashSet<MethodSignature>(oldCallGraph.getMethodSignatures());
        this.processWorkList(this.view, workList, processed, updated);
        List superClasses = this.view.getTypeHierarchy().superClassesOf((ClassType)classType);
        Set implementedInterfaces = this.view.getTypeHierarchy().implementedInterfacesOf((ClassType)classType);
        Stream superTypes = Stream.concat(superClasses.stream(), implementedInterfaces.stream());
        Set newMethodSubSigs = newMethodSignatures.stream().map(SootClassMemberSignature::getSubSignature).collect(Collectors.toSet());
        superTypes.map(arg_0 -> ((View)this.view).getClass(arg_0)).filter(Optional::isPresent).map(Optional::get).flatMap(superType -> superType.getMethods().stream()).map(Method::getSignature).filter(superTypeMethodSig -> newMethodSubSigs.contains(superTypeMethodSig.getSubSignature())).forEach(overriddenMethodSig -> {
            MethodSignature overridingMethodSig = (MethodSignature)((SootMethod)clazz.getMethod((MethodSubSignature)overriddenMethodSig.getSubSignature()).get()).getSignature();
            if (updated.containsMethod((MethodSignature)overriddenMethodSig)) {
                for (MethodSignature callingMethodSig : updated.callsTo((MethodSignature)overriddenMethodSig)) {
                    updated.addCall(callingMethodSig, overridingMethodSig);
                }
            }
        });
        return updated;
    }

    public MethodSignature findMainMethod() {
        HashSet<SootClass> classes = new HashSet<SootClass>();
        for (SootClass aClass : this.view.getClasses()) {
            if (aClass.isLibraryClass()) continue;
            classes.add(aClass);
        }
        HashSet<SootMethod> mainMethods = new HashSet<SootMethod>();
        for (SootClass aClass : classes) {
            for (SootMethod method : aClass.getMethods()) {
                if (!method.isStatic() || !((MethodSignature)method.getSignature()).equals((Object)JavaIdentifierFactory.getInstance().getMethodSignature(aClass.getType(), "main", "void", Collections.singletonList("java.lang.String[]")))) continue;
                mainMethods.add(method);
            }
        }
        if (mainMethods.size() > 1) {
            throw new RuntimeException("There are more than 1 main method present.\n Below main methods are found: \n" + mainMethods + "\n initialize() method can be used if only one main method exists. \n You can specify these main methods as entry points by passing them as parameter to initialize method.");
        }
        if (mainMethods.isEmpty()) {
            throw new RuntimeException("No main method is present in the input programs. initialize() method can be used if only one main method exists in the input program and that should be used as entry point for call graph. \n Please specify entry point as a parameter to initialize method.");
        }
        return (MethodSignature)((SootMethod)mainMethods.stream().findFirst().get()).getSignature();
    }

    @Nonnull
    protected abstract Stream<MethodSignature> resolveCall(SootMethod var1, AbstractInvokeExpr var2);

    @Nonnull
    public static Optional<MethodSignature> resolveConcreteDispatch(View view, MethodSignature m) {
        Optional<SootMethod> methodOp = AbstractCallGraphAlgorithm.findConcreteMethod(view, m);
        if (methodOp.isPresent()) {
            SootMethod method = methodOp.get();
            if (method.isAbstract()) {
                return Optional.empty();
            }
            return Optional.of(method.getSignature());
        }
        return Optional.empty();
    }

    public static Optional<SootMethod> findConcreteMethod(@Nonnull View view, @Nonnull MethodSignature sig) {
        IdentifierFactory identifierFactory = view.getIdentifierFactory();
        SootClass startclass = view.getClass(sig.getDeclClassType()).orElse(null);
        if (startclass == null) {
            logger.warn("Could not find \"" + sig.getDeclClassType() + "\" of method" + sig + " to resolve the concrete method");
            return Optional.empty();
        }
        Optional<SootMethod> startMethod = startclass.getMethod((MethodSubSignature)sig.getSubSignature()).map(method -> method);
        if (startMethod.isPresent()) {
            return startMethod;
        }
        TypeHierarchy typeHierarchy = view.getTypeHierarchy();
        List superClasses = typeHierarchy.superClassesOf(sig.getDeclClassType());
        for (ClassType superClassType : superClasses) {
            Optional<SootMethod> method2 = view.getMethod(identifierFactory.getMethodSignature(superClassType, (MethodSubSignature)sig.getSubSignature())).map(sm -> sm);
            if (!method2.isPresent()) continue;
            return method2;
        }
        Set interfaces = typeHierarchy.implementedInterfacesOf(sig.getDeclClassType());
        HierarchyComparator hierarchyComparator = new HierarchyComparator(view);
        Optional<SootMethod> defaultMethod = interfaces.stream().map(classType -> view.getMethod(identifierFactory.getMethodSignature(classType, (MethodSubSignature)sig.getSubSignature()))).filter(Optional::isPresent).map(Optional::get).min((m1, m2) -> hierarchyComparator.compare(m1.getDeclaringClassType(), m2.getDeclaringClassType())).map(method -> method);
        if (defaultMethod.isPresent()) {
            return defaultMethod;
        }
        logger.warn("Could not find \"" + sig.getSubSignature() + "\" in " + sig.getDeclClassType().getClassName() + " and in its superclasses and interfaces");
        return Optional.empty();
    }
}

