/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jgrapht.graph.DefaultDirectedGraph;
import sootup.callgraph.MutableCallGraph;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.SootClassMemberSignature;

public class GraphBasedCallGraph
implements MutableCallGraph {
    @Nonnull
    private final DefaultDirectedGraph<Vertex, Edge> graph;
    @Nonnull
    private final Map<MethodSignature, Vertex> signatureToVertex;

    public GraphBasedCallGraph() {
        this.graph = new DefaultDirectedGraph(null, null, false);
        this.signatureToVertex = new HashMap<MethodSignature, Vertex>();
    }

    public GraphBasedCallGraph(@Nonnull DefaultDirectedGraph<Vertex, Edge> graph, @Nonnull Map<MethodSignature, Vertex> signatureToVertex) {
        this.graph = graph;
        this.signatureToVertex = signatureToVertex;
    }

    @Override
    public void addMethod(@Nonnull MethodSignature calledMethod) {
        Vertex v = new Vertex(calledMethod);
        this.addMethod(calledMethod, v);
    }

    protected void addMethod(@Nonnull MethodSignature calledMethod, Vertex vertex) {
        this.graph.addVertex((Object)vertex);
        this.signatureToVertex.put(calledMethod, vertex);
    }

    @Override
    public void addCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod) {
        this.addCall(sourceMethod, targetMethod, new Edge());
    }

    protected void addCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod, Edge edge) {
        this.graph.addEdge((Object)this.vertexOf(sourceMethod), (Object)this.vertexOf(targetMethod), (Object)edge);
    }

    @Override
    @Nonnull
    public Set<MethodSignature> getMethodSignatures() {
        return this.signatureToVertex.keySet();
    }

    @Override
    @Nonnull
    public Set<MethodSignature> callsFrom(@Nonnull MethodSignature sourceMethod) {
        return this.graph.outgoingEdgesOf((Object)this.vertexOf(sourceMethod)).stream().map(arg_0 -> this.graph.getEdgeTarget(arg_0)).map(targetVertex -> targetVertex.methodSignature).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Set<MethodSignature> callsTo(@Nonnull MethodSignature targetMethod) {
        return this.graph.incomingEdgesOf((Object)this.vertexOf(targetMethod)).stream().map(arg_0 -> this.graph.getEdgeSource(arg_0)).map(targetVertex -> targetVertex.methodSignature).collect(Collectors.toSet());
    }

    @Override
    public boolean containsMethod(@Nonnull MethodSignature method) {
        return this.signatureToVertex.containsKey(method);
    }

    @Override
    public boolean containsCall(@Nonnull MethodSignature sourceMethod, @Nonnull MethodSignature targetMethod) {
        if (!this.containsMethod(sourceMethod) || !this.containsMethod(targetMethod)) {
            return false;
        }
        return this.graph.containsEdge((Object)this.vertexOf(sourceMethod), (Object)this.vertexOf(targetMethod));
    }

    @Override
    public int callCount() {
        return this.graph.edgeSet().size();
    }

    @Override
    public String exportAsDot() {
        StringBuilder dotFormatBuilder = new StringBuilder();
        this.graph.edgeSet().stream().sorted(Comparator.comparing(edge -> {
            Vertex edgeSource = (Vertex)this.graph.getEdgeSource(edge);
            return edgeSource.methodSignature.getDeclClassType().getFullyQualifiedName();
        }).thenComparing(edge -> {
            Vertex edgeSource = (Vertex)this.graph.getEdgeSource(edge);
            return edgeSource.methodSignature.getName();
        }).thenComparing(edge -> {
            Vertex edgeSource = (Vertex)this.graph.getEdgeSource(edge);
            return edgeSource.methodSignature.getParameterTypes().toString();
        }).thenComparing(edge -> {
            Vertex edgeTarget = (Vertex)this.graph.getEdgeTarget(edge);
            return edgeTarget.methodSignature.getDeclClassType().getClassName();
        }).thenComparing(edge -> {
            Vertex edgeTarget = (Vertex)this.graph.getEdgeTarget(edge);
            return edgeTarget.methodSignature.getName();
        }).thenComparing(edge -> {
            Vertex edgeTarget = (Vertex)this.graph.getEdgeTarget(edge);
            return edgeTarget.methodSignature.getParameterTypes().toString();
        })).forEach(edge -> {
            Vertex sourceVertex = (Vertex)this.graph.getEdgeSource(edge);
            Vertex targetVertex = (Vertex)this.graph.getEdgeTarget(edge);
            dotFormatBuilder.append("\t").append("\"" + sourceVertex.methodSignature + "\"").append(" -> ").append("\"" + targetVertex.methodSignature + "\"").append(";\n");
        });
        return "strict digraph ObjectGraph {\n" + dotFormatBuilder + "}";
    }

    @Override
    @Nonnull
    public MutableCallGraph copy() {
        return new GraphBasedCallGraph((DefaultDirectedGraph<Vertex, Edge>)((DefaultDirectedGraph)this.graph.clone()), new HashMap<MethodSignature, Vertex>(this.signatureToVertex));
    }

    @Nonnull
    protected Vertex vertexOf(@Nonnull MethodSignature method) {
        Vertex methodVertex = this.signatureToVertex.get(method);
        Preconditions.checkNotNull((Object)methodVertex, (Object)("Node for " + method + " has not been added yet"));
        return methodVertex;
    }

    @Nonnull
    protected DefaultDirectedGraph<Vertex, Edge> getGraph() {
        return this.graph;
    }

    @Nonnull
    protected Map<MethodSignature, Vertex> getSignatureToVertex() {
        return this.signatureToVertex;
    }

    @Nonnull
    protected MethodSignature vertex2MethodSignature(@Nonnull Vertex vertex) {
        return vertex.getMethodSignature();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GraphBasedCallGraph(" + this.callCount() + ")");
        Set<MethodSignature> signatures = this.signatureToVertex.keySet();
        if (signatures.isEmpty()) {
            stringBuilder.append(" is empty");
        } else {
            stringBuilder.append(":\n");
            signatures.stream().sorted(Comparator.comparing(o -> o.getDeclClassType().toString()).thenComparing(SootClassMemberSignature::getName).thenComparing(o -> o.getParameterTypes().toString())).forEach(method -> {
                stringBuilder.append(method).append(":\n");
                this.callsFrom((MethodSignature)method).stream().sorted(Comparator.comparing(o -> o.getDeclClassType().toString()).thenComparing(SootClassMemberSignature::getName).thenComparing(o -> o.getParameterTypes().toString())).forEach(m -> stringBuilder.append("\tto ").append(m).append("\n"));
                this.callsTo((MethodSignature)method).stream().sorted(Comparator.comparing(o -> o.getDeclClassType().toString()).thenComparing(SootClassMemberSignature::getName).thenComparing(o -> o.getParameterTypes().toString())).forEach(m -> stringBuilder.append("\tfrom ").append(m).append("\n"));
                stringBuilder.append("\n");
            });
        }
        return stringBuilder.toString();
    }

    protected static class Edge {
        protected Edge() {
        }
    }

    protected static class Vertex {
        @Nonnull
        final MethodSignature methodSignature;

        protected Vertex(@Nonnull MethodSignature methodSignature) {
            this.methodSignature = methodSignature;
        }

        @Nonnull
        protected MethodSignature getMethodSignature() {
            return this.methodSignature;
        }
    }
}

