/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.callgraph.AbstractCallGraphAlgorithm;
import sootup.callgraph.CallGraph;
import sootup.callgraph.MutableCallGraph;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.model.MethodModifier;
import sootup.core.model.SootMethod;
import sootup.core.signatures.MethodSignature;
import sootup.core.signatures.MethodSubSignature;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public class RapidTypeAnalysisAlgorithm
extends AbstractCallGraphAlgorithm {
    @Nonnull
    private Set<ClassType> instantiatedClasses = Collections.emptySet();
    @Nonnull
    private Map<ClassType, List<Call>> ignoredCalls = Collections.emptyMap();

    public RapidTypeAnalysisAlgorithm(@Nonnull View view) {
        super(view);
    }

    @Override
    @Nonnull
    public CallGraph initialize() {
        List<MethodSignature> entryPoints = Collections.singletonList(this.findMainMethod());
        return this.initialize(entryPoints);
    }

    @Override
    @Nonnull
    public CallGraph initialize(@Nonnull List<MethodSignature> entryPoints) {
        this.instantiatedClasses = new HashSet<ClassType>();
        this.ignoredCalls = new HashMap<ClassType, List<Call>>();
        CallGraph cg = this.constructCompleteCallGraph(this.view, entryPoints);
        this.instantiatedClasses = Collections.emptySet();
        this.ignoredCalls = Collections.emptyMap();
        return cg;
    }

    protected List<ClassType> collectInstantiatedClassesInMethod(SootMethod method) {
        if (method == null || method.isAbstract() || method.isNative()) {
            return Collections.emptyList();
        }
        Set instantiated = method.getBody().getStmts().stream().filter(stmt -> stmt instanceof JAssignStmt).map(stmt -> ((JAssignStmt)stmt).getRightOp()).filter(value -> value instanceof JNewExpr).map(value -> ((JNewExpr)value).getType()).collect(Collectors.toSet());
        List<ClassType> newInstantiatedClassTypes = instantiated.stream().filter(classType -> !this.instantiatedClasses.contains(classType)).collect(Collectors.toList());
        this.instantiatedClasses.addAll(instantiated);
        return newInstantiatedClassTypes;
    }

    @Override
    @Nonnull
    protected Stream<MethodSignature> resolveCall(SootMethod sourceMethod, AbstractInvokeExpr invokeExpr) {
        MethodSignature resolveBaseMethodSignature = invokeExpr.getMethodSignature();
        Stream<MethodSignature> result = Stream.of(resolveBaseMethodSignature);
        SootMethod concreteBaseMethod = RapidTypeAnalysisAlgorithm.findConcreteMethod(this.view, resolveBaseMethodSignature).orElse(null);
        if (concreteBaseMethod == null || MethodModifier.isStatic((Set)concreteBaseMethod.getModifiers()) || invokeExpr instanceof JSpecialInvokeExpr) {
            return result;
        }
        if (this.instantiatedClasses.contains(resolveBaseMethodSignature.getDeclClassType())) {
            return Stream.concat(Stream.of(concreteBaseMethod.getSignature()), this.resolveAllCallTargets((MethodSignature)sourceMethod.getSignature(), resolveBaseMethodSignature));
        }
        this.saveIgnoredCall((MethodSignature)sourceMethod.getSignature(), resolveBaseMethodSignature);
        return this.resolveAllCallTargets((MethodSignature)sourceMethod.getSignature(), resolveBaseMethodSignature);
    }

    private Stream<MethodSignature> resolveAllCallTargets(MethodSignature source, MethodSignature resolveBaseMethodSignature) {
        return this.view.getTypeHierarchy().subtypesOf(resolveBaseMethodSignature.getDeclClassType()).stream().map(classType -> {
            MethodSignature method = this.view.getIdentifierFactory().getMethodSignature(classType, (MethodSubSignature)resolveBaseMethodSignature.getSubSignature());
            if (this.instantiatedClasses.contains(classType)) {
                return RapidTypeAnalysisAlgorithm.resolveConcreteDispatch(this.view, method);
            }
            this.saveIgnoredCall(source, method);
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get);
    }

    private void saveIgnoredCall(MethodSignature source, MethodSignature target) {
        ClassType notInstantiatedClass = target.getDeclClassType();
        List<Call> calls = this.ignoredCalls.get(notInstantiatedClass);
        Call ignoredCall = new Call(source, target);
        if (calls == null) {
            calls = new ArrayList<Call>();
            this.ignoredCalls.put(notInstantiatedClass, calls);
        }
        calls.add(ignoredCall);
    }

    @Override
    protected void preProcessingMethod(View view, MethodSignature sourceMethod, @Nonnull Deque<MethodSignature> workList, @Nonnull MutableCallGraph cg) {
        SootMethod method = view.getClass(sourceMethod.getDeclClassType()).flatMap(c -> c.getMethod((MethodSubSignature)sourceMethod.getSubSignature())).orElse(null);
        if (method == null) {
            return;
        }
        List<ClassType> newInstantiatedClasses = this.collectInstantiatedClassesInMethod(method);
        newInstantiatedClasses.forEach(instantiatedClassType -> {
            List<Call> newEdges = this.ignoredCalls.get(instantiatedClassType);
            if (newEdges != null) {
                newEdges.forEach(call -> {
                    MethodSignature concreteTarget = RapidTypeAnalysisAlgorithm.resolveConcreteDispatch(view, call.target).orElse(null);
                    if (concreteTarget == null) {
                        return;
                    }
                    if (cg.containsMethod(concreteTarget)) {
                        cg.addCall(call.source, concreteTarget);
                    } else {
                        cg.addMethod(concreteTarget);
                        cg.addCall(call.source, concreteTarget);
                        workList.push(concreteTarget);
                    }
                });
                this.ignoredCalls.remove(instantiatedClassType);
            }
        });
    }

    @Override
    protected void postProcessingMethod(View view, MethodSignature sourceMethod, @Nonnull Deque<MethodSignature> workList, @Nonnull MutableCallGraph cg) {
    }

    private static class Call {
        @Nonnull
        final MethodSignature source;
        @Nonnull
        final MethodSignature target;

        private Call(@Nonnull MethodSignature source, @Nonnull MethodSignature target) {
            this.source = source;
            this.target = target;
        }
    }
}

