/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.callgraph.CallGraphDifference;
import sootup.callgraph.MutableCallGraph;
import sootup.core.jimple.common.stmt.InvokableStmt;
import sootup.core.signatures.MethodSignature;

public interface CallGraph {
    @Nonnull
    public Set<MethodSignature> getMethodSignatures();

    @Nonnull
    public Set<MethodSignature> callTargetsFrom(@Nonnull MethodSignature var1);

    @Nonnull
    public Set<MethodSignature> callSourcesTo(@Nonnull MethodSignature var1);

    @Nonnull
    public Set<Call> callsFrom(@Nonnull MethodSignature var1);

    @Nonnull
    public Set<Call> callsTo(@Nonnull MethodSignature var1);

    public boolean containsMethod(@Nonnull MethodSignature var1);

    public boolean containsCall(@Nonnull MethodSignature var1, @Nonnull MethodSignature var2, InvokableStmt var3);

    public boolean containsCall(@Nonnull Call var1);

    public int callCount();

    public String exportAsDot();

    @Nonnull
    public MutableCallGraph copy();

    public List<MethodSignature> getEntryMethods();

    @Nonnull
    public CallGraphDifference diff(@Nonnull CallGraph var1);

    public static class Call {
        @Nonnull
        private final MethodSignature sourceMethodSignature;
        @Nonnull
        private final MethodSignature targetMethodSignature;
        @Nonnull
        private final InvokableStmt invokableStmt;

        public Call(@Nonnull MethodSignature sourceMethodSignature, @Nonnull MethodSignature targetMethodSignature, @Nonnull InvokableStmt invokableStmt) {
            this.sourceMethodSignature = sourceMethodSignature;
            this.invokableStmt = invokableStmt;
            this.targetMethodSignature = targetMethodSignature;
        }

        @Nonnull
        public MethodSignature getSourceMethodSignature() {
            return this.sourceMethodSignature;
        }

        @Nonnull
        public MethodSignature getTargetMethodSignature() {
            return this.targetMethodSignature;
        }

        @Nonnull
        public InvokableStmt getInvokableStmt() {
            return this.invokableStmt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Call call = (Call)o;
            return this.sourceMethodSignature.equals((Object)call.sourceMethodSignature) && this.targetMethodSignature.equals((Object)call.targetMethodSignature) && this.invokableStmt.equals((Object)call.invokableStmt);
        }

        public int hashCode() {
            int result = this.sourceMethodSignature.hashCode();
            result = 31 * result + this.targetMethodSignature.hashCode();
            result = 31 * result + this.invokableStmt.hashCode();
            return result;
        }

        public String toString() {
            return "Call:" + this.sourceMethodSignature + " -> " + this.targetMethodSignature + " via " + this.invokableStmt + ";";
        }
    }
}

