/*
 * Decompiled with CFR 0.152.
 */
package sootup.callgraph;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import sootup.callgraph.CallGraph;
import sootup.core.signatures.MethodSignature;

public class CallGraphDifference {
    private final CallGraph baseCallGraph;
    private final CallGraph otherCallGraph;
    private final List<Pair<MethodSignature, MethodSignature>> baseCallGraphEdges;
    private final List<Pair<MethodSignature, MethodSignature>> otherCallGraphEdges;

    public CallGraphDifference(CallGraph baseCallGraph, CallGraph otherCallGraph) {
        this.baseCallGraph = baseCallGraph;
        this.otherCallGraph = otherCallGraph;
        this.baseCallGraphEdges = this.constructEdges(baseCallGraph);
        this.otherCallGraphEdges = this.constructEdges(otherCallGraph);
    }

    private List<Pair<MethodSignature, MethodSignature>> constructEdges(CallGraph cg) {
        ArrayList<Pair<MethodSignature, MethodSignature>> cgEdges = new ArrayList<Pair<MethodSignature, MethodSignature>>();
        for (MethodSignature srcNode : cg.getMethodSignatures()) {
            Set<MethodSignature> outNodes = cg.callTargetsFrom(srcNode);
            for (MethodSignature targetNode : outNodes) {
                cgEdges.add((Pair<MethodSignature, MethodSignature>)new MutablePair((Object)srcNode, (Object)targetNode));
            }
        }
        return cgEdges;
    }

    public CallGraph getBaseCallGraph() {
        return this.baseCallGraph;
    }

    public CallGraph getOtherCallGraph() {
        return this.otherCallGraph;
    }

    public List<Pair<MethodSignature, MethodSignature>> getBaseCallGraphEdges() {
        return this.baseCallGraphEdges;
    }

    public List<Pair<MethodSignature, MethodSignature>> getOtherCallGraphEdges() {
        return this.otherCallGraphEdges;
    }

    public List<Pair<MethodSignature, MethodSignature>> intersectedCalls() {
        return this.baseCallGraphEdges.stream().filter(this.otherCallGraphEdges::contains).collect(Collectors.toList());
    }

    public List<MethodSignature> intersectedMethods() {
        return this.baseCallGraph.getMethodSignatures().stream().filter(this.otherCallGraph.getMethodSignatures()::contains).collect(Collectors.toList());
    }

    public List<Pair<MethodSignature, MethodSignature>> uniqueBaseGraphCalls() {
        return this.baseCallGraphEdges.stream().filter(edge -> !this.otherCallGraphEdges.contains(edge)).collect(Collectors.toList());
    }

    public List<MethodSignature> uniqueBaseGraphMethods() {
        return this.baseCallGraph.getMethodSignatures().stream().filter(node -> !this.otherCallGraph.getMethodSignatures().contains(node)).collect(Collectors.toList());
    }

    public List<Pair<MethodSignature, MethodSignature>> uniqueOtherGraphCalls() {
        return this.otherCallGraphEdges.stream().filter(edge -> !this.baseCallGraphEdges.contains(edge)).collect(Collectors.toList());
    }

    public List<MethodSignature> uniqueOtherGraphMethods() {
        return this.otherCallGraph.getMethodSignatures().stream().filter(node -> !this.baseCallGraph.getMethodSignatures().contains(node)).collect(Collectors.toList());
    }
}

