/*
 * Decompiled with CFR 0.152.
 */
package sootup.codepropertygraph.ast;

import javax.annotation.Nonnull;
import sootup.codepropertygraph.propertygraph.PropertyGraph;
import sootup.codepropertygraph.propertygraph.edges.ArgAstEdge;
import sootup.codepropertygraph.propertygraph.edges.ArraySizeAstEdge;
import sootup.codepropertygraph.propertygraph.edges.BaseAstEdge;
import sootup.codepropertygraph.propertygraph.edges.ExprAstEdge;
import sootup.codepropertygraph.propertygraph.edges.Op1AstEdge;
import sootup.codepropertygraph.propertygraph.edges.Op2AstEdge;
import sootup.codepropertygraph.propertygraph.edges.SingleOpAstEdge;
import sootup.codepropertygraph.propertygraph.nodes.ExprGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.ImmediateGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.PropertyGraphNode;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.AbstractUnopExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.expr.JAddExpr;
import sootup.core.jimple.common.expr.JAndExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JCmpExpr;
import sootup.core.jimple.common.expr.JCmpgExpr;
import sootup.core.jimple.common.expr.JCmplExpr;
import sootup.core.jimple.common.expr.JDivExpr;
import sootup.core.jimple.common.expr.JDynamicInvokeExpr;
import sootup.core.jimple.common.expr.JEqExpr;
import sootup.core.jimple.common.expr.JGeExpr;
import sootup.core.jimple.common.expr.JGtExpr;
import sootup.core.jimple.common.expr.JInstanceOfExpr;
import sootup.core.jimple.common.expr.JInterfaceInvokeExpr;
import sootup.core.jimple.common.expr.JLeExpr;
import sootup.core.jimple.common.expr.JLengthExpr;
import sootup.core.jimple.common.expr.JLtExpr;
import sootup.core.jimple.common.expr.JMulExpr;
import sootup.core.jimple.common.expr.JNeExpr;
import sootup.core.jimple.common.expr.JNegExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JOrExpr;
import sootup.core.jimple.common.expr.JPhiExpr;
import sootup.core.jimple.common.expr.JRemExpr;
import sootup.core.jimple.common.expr.JShlExpr;
import sootup.core.jimple.common.expr.JShrExpr;
import sootup.core.jimple.common.expr.JSpecialInvokeExpr;
import sootup.core.jimple.common.expr.JStaticInvokeExpr;
import sootup.core.jimple.common.expr.JSubExpr;
import sootup.core.jimple.common.expr.JUshrExpr;
import sootup.core.jimple.common.expr.JVirtualInvokeExpr;
import sootup.core.jimple.common.expr.JXorExpr;
import sootup.core.jimple.visitor.AbstractExprVisitor;

class AstExprVisitor
extends AbstractExprVisitor {
    private final PropertyGraph.Builder graphBuilder;
    private final PropertyGraphNode parentNode;

    AstExprVisitor(PropertyGraph.Builder graphBuilder, PropertyGraphNode parentNode) {
        this.graphBuilder = graphBuilder;
        this.parentNode = parentNode;
    }

    public void defaultCaseExpr(@Nonnull Expr expr) {
        ExprGraphNode exprNode = new ExprGraphNode(expr);
        this.graphBuilder.addEdge(new ExprAstEdge(this.parentNode, exprNode));
    }

    public void caseAddExpr(@Nonnull JAddExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseAndExpr(@Nonnull JAndExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseCmpExpr(@Nonnull JCmpExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseCmpgExpr(@Nonnull JCmpgExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseCmplExpr(@Nonnull JCmplExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseDivExpr(@Nonnull JDivExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseEqExpr(@Nonnull JEqExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseNeExpr(@Nonnull JNeExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseGeExpr(@Nonnull JGeExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseGtExpr(@Nonnull JGtExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseLeExpr(@Nonnull JLeExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseLtExpr(@Nonnull JLtExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseMulExpr(@Nonnull JMulExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseOrExpr(@Nonnull JOrExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseRemExpr(@Nonnull JRemExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseShlExpr(@Nonnull JShlExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseShrExpr(@Nonnull JShrExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseUshrExpr(@Nonnull JUshrExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseSubExpr(@Nonnull JSubExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseXorExpr(@Nonnull JXorExpr expr) {
        this.handleBinopExpr((AbstractBinopExpr)expr);
    }

    public void caseStaticInvokeExpr(@Nonnull JStaticInvokeExpr expr) {
        this.handleInvokeExpr((AbstractInvokeExpr)expr);
    }

    public void caseSpecialInvokeExpr(@Nonnull JSpecialInvokeExpr expr) {
        this.handleInvokeExpr((AbstractInvokeExpr)expr);
    }

    public void caseVirtualInvokeExpr(@Nonnull JVirtualInvokeExpr expr) {
        this.handleInvokeExpr((AbstractInvokeExpr)expr);
    }

    public void caseInterfaceInvokeExpr(@Nonnull JInterfaceInvokeExpr expr) {
        this.handleInvokeExpr((AbstractInvokeExpr)expr);
    }

    public void caseDynamicInvokeExpr(@Nonnull JDynamicInvokeExpr expr) {
        this.handleInvokeExpr((AbstractInvokeExpr)expr);
    }

    public void caseCastExpr(@Nonnull JCastExpr expr) {
        ExprGraphNode exprNode = new ExprGraphNode((Expr)expr);
        this.graphBuilder.addEdge(new ExprAstEdge(this.parentNode, exprNode));
        ImmediateGraphNode opNode = new ImmediateGraphNode(expr.getOp());
        this.graphBuilder.addEdge(new SingleOpAstEdge(exprNode, opNode));
    }

    public void caseInstanceOfExpr(@Nonnull JInstanceOfExpr expr) {
        ExprGraphNode exprNode = new ExprGraphNode((Expr)expr);
        this.graphBuilder.addEdge(new ExprAstEdge(this.parentNode, exprNode));
        ImmediateGraphNode opNode = new ImmediateGraphNode(expr.getOp());
        this.graphBuilder.addEdge(new SingleOpAstEdge(exprNode, opNode));
    }

    public void caseNewArrayExpr(@Nonnull JNewArrayExpr expr) {
        ExprGraphNode exprNode = new ExprGraphNode((Expr)expr);
        this.graphBuilder.addEdge(new ExprAstEdge(this.parentNode, exprNode));
        ImmediateGraphNode arraySizeNode = new ImmediateGraphNode(expr.getSize());
        this.graphBuilder.addEdge(new ArraySizeAstEdge(exprNode, arraySizeNode));
    }

    public void caseNewMultiArrayExpr(@Nonnull JNewMultiArrayExpr expr) {
        ExprGraphNode exprNode = new ExprGraphNode((Expr)expr);
        this.graphBuilder.addEdge(new ExprAstEdge(this.parentNode, exprNode));
        for (Immediate size : expr.getSizes()) {
            ImmediateGraphNode arraySizeNode = new ImmediateGraphNode(size);
            this.graphBuilder.addEdge(new ArraySizeAstEdge(exprNode, arraySizeNode));
        }
    }

    public void caseNewExpr(@Nonnull JNewExpr expr) {
        ExprGraphNode exprNode = new ExprGraphNode((Expr)expr);
        this.graphBuilder.addEdge(new ExprAstEdge(this.parentNode, exprNode));
    }

    public void caseLengthExpr(@Nonnull JLengthExpr expr) {
        this.handleUnopExpr((AbstractUnopExpr)expr);
    }

    public void caseNegExpr(@Nonnull JNegExpr expr) {
        this.handleUnopExpr((AbstractUnopExpr)expr);
    }

    public void casePhiExpr(@Nonnull JPhiExpr expr) {
        ExprGraphNode exprNode = new ExprGraphNode((Expr)expr);
        this.graphBuilder.addEdge(new ExprAstEdge(this.parentNode, exprNode));
        for (Immediate arg : expr.getArgs()) {
            ImmediateGraphNode argAstEdge = new ImmediateGraphNode(arg);
            this.graphBuilder.addEdge(new ArgAstEdge(exprNode, argAstEdge));
        }
    }

    private void handleBinopExpr(AbstractBinopExpr expr) {
        ImmediateGraphNode op1Node = new ImmediateGraphNode(expr.getOp1());
        this.graphBuilder.addEdge(new Op1AstEdge(this.parentNode, op1Node));
        ImmediateGraphNode op2Node = new ImmediateGraphNode(expr.getOp2());
        this.graphBuilder.addEdge(new Op2AstEdge(this.parentNode, op2Node));
    }

    private void handleUnopExpr(AbstractUnopExpr expr) {
        ExprGraphNode exprNode = new ExprGraphNode((Expr)expr);
        this.graphBuilder.addEdge(new ExprAstEdge(this.parentNode, exprNode));
        ImmediateGraphNode opNode = new ImmediateGraphNode(expr.getOp());
        this.graphBuilder.addEdge(new SingleOpAstEdge(exprNode, opNode));
    }

    private void handleInvokeExpr(AbstractInvokeExpr expr) {
        ImmediateGraphNode baseNode;
        if (expr instanceof JInterfaceInvokeExpr) {
            JInterfaceInvokeExpr interfaceInvokeExpr = (JInterfaceInvokeExpr)expr;
            baseNode = new ImmediateGraphNode((Immediate)interfaceInvokeExpr.getBase());
            this.graphBuilder.addEdge(new BaseAstEdge(this.parentNode, baseNode));
        } else if (expr instanceof JSpecialInvokeExpr) {
            JSpecialInvokeExpr specialInvokeExpr = (JSpecialInvokeExpr)expr;
            baseNode = new ImmediateGraphNode((Immediate)specialInvokeExpr.getBase());
            this.graphBuilder.addEdge(new BaseAstEdge(this.parentNode, baseNode));
        } else if (expr instanceof JVirtualInvokeExpr) {
            JVirtualInvokeExpr virtualInvokeExpr = (JVirtualInvokeExpr)expr;
            baseNode = new ImmediateGraphNode((Immediate)virtualInvokeExpr.getBase());
            this.graphBuilder.addEdge(new BaseAstEdge(this.parentNode, baseNode));
        }
        for (Immediate arg : expr.getArgs()) {
            ImmediateGraphNode argAstEdge = new ImmediateGraphNode(arg);
            this.graphBuilder.addEdge(new ArgAstEdge(this.parentNode, argAstEdge));
        }
    }
}

