/*
 * Decompiled with CFR 0.152.
 */
package sootup.codepropertygraph.ast;

import java.util.Optional;
import javax.annotation.Nonnull;
import sootup.codepropertygraph.ast.AstExprVisitor;
import sootup.codepropertygraph.propertygraph.PropertyGraph;
import sootup.codepropertygraph.propertygraph.edges.ConditionAstEdge;
import sootup.codepropertygraph.propertygraph.edges.InvokeAstEdge;
import sootup.codepropertygraph.propertygraph.edges.LeftOpAstEdge;
import sootup.codepropertygraph.propertygraph.edges.RightOpAstEdge;
import sootup.codepropertygraph.propertygraph.edges.SingleOpAstEdge;
import sootup.codepropertygraph.propertygraph.edges.StmtAstEdge;
import sootup.codepropertygraph.propertygraph.edges.SwitchKeyAstEdge;
import sootup.codepropertygraph.propertygraph.nodes.ExprGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.ImmediateGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.PropertyGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.RefGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.StmtGraphNode;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractConditionExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.Expr;
import sootup.core.jimple.common.ref.Ref;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.JNopStmt;
import sootup.core.jimple.common.stmt.JReturnStmt;
import sootup.core.jimple.common.stmt.JThrowStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JEnterMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JExitMonitorStmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.jimple.visitor.AbstractStmtVisitor;
import sootup.core.jimple.visitor.Visitor;

class AstStmtVisitor
extends AbstractStmtVisitor {
    private final PropertyGraph.Builder graphBuilder;
    private final PropertyGraphNode parentNode;

    AstStmtVisitor(PropertyGraph.Builder graphBuilder, PropertyGraphNode parentNode) {
        this.graphBuilder = graphBuilder;
        this.parentNode = parentNode;
    }

    public void caseAssignStmt(@Nonnull JAssignStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        PropertyGraphNode leftOpNode = this.createOperandNode((Value)stmt.getLeftOp());
        this.graphBuilder.addEdge(new LeftOpAstEdge(stmtNode, leftOpNode));
        PropertyGraphNode rightOpNode = this.createOperandNode(stmt.getRightOp());
        this.graphBuilder.addEdge(new RightOpAstEdge(stmtNode, rightOpNode));
    }

    private PropertyGraphNode createOperandNode(Value operand) {
        if (operand instanceof Immediate) {
            return new ImmediateGraphNode((Immediate)operand);
        }
        if (operand instanceof Ref) {
            return new RefGraphNode((Ref)operand);
        }
        if (operand instanceof Expr) {
            ExprGraphNode exprNode = new ExprGraphNode((Expr)operand);
            ((Expr)operand).accept((Visitor)new AstExprVisitor(this.graphBuilder, exprNode));
            return exprNode;
        }
        throw new IllegalArgumentException("Unknown operand type: " + operand.getClass());
    }

    public void caseInvokeStmt(@Nonnull JInvokeStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        Optional invokeStmtOpt = stmt.getInvokeExpr();
        if (invokeStmtOpt.isPresent()) {
            AbstractInvokeExpr invokeExpr = (AbstractInvokeExpr)invokeStmtOpt.get();
            ExprGraphNode invokeExprNode = new ExprGraphNode((Expr)invokeExpr);
            this.graphBuilder.addEdge(new InvokeAstEdge(stmtNode, invokeExprNode));
            invokeExpr.accept((Visitor)new AstExprVisitor(this.graphBuilder, invokeExprNode));
        }
    }

    public void caseReturnStmt(@Nonnull JReturnStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        ImmediateGraphNode opNode = new ImmediateGraphNode(stmt.getOp());
        this.graphBuilder.addEdge(new SingleOpAstEdge(stmtNode, opNode));
    }

    public void caseIfStmt(@Nonnull JIfStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        AbstractConditionExpr condition = stmt.getCondition();
        ExprGraphNode exprNode = new ExprGraphNode((Expr)condition);
        this.graphBuilder.addEdge(new ConditionAstEdge(stmtNode, exprNode));
        condition.accept((Visitor)new AstExprVisitor(this.graphBuilder, exprNode));
    }

    public void caseNopStmt(@Nonnull JNopStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
    }

    public void caseThrowStmt(@Nonnull JThrowStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        ImmediateGraphNode opNode = new ImmediateGraphNode(stmt.getOp());
        this.graphBuilder.addEdge(new SingleOpAstEdge(stmtNode, opNode));
    }

    public void caseIdentityStmt(@Nonnull JIdentityStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        ImmediateGraphNode leftOpNode = new ImmediateGraphNode((Immediate)stmt.getLeftOp());
        this.graphBuilder.addEdge(new LeftOpAstEdge(stmtNode, (PropertyGraphNode)leftOpNode));
        RefGraphNode rightOpNode = new RefGraphNode((Ref)stmt.getRightOp());
        this.graphBuilder.addEdge(new RightOpAstEdge(stmtNode, (PropertyGraphNode)rightOpNode));
    }

    public void caseGotoStmt(@Nonnull JGotoStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
    }

    public void caseEnterMonitorStmt(@Nonnull JEnterMonitorStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        ImmediateGraphNode opNode = new ImmediateGraphNode(stmt.getOp());
        this.graphBuilder.addEdge(new SingleOpAstEdge(stmtNode, opNode));
    }

    public void caseExitMonitorStmt(@Nonnull JExitMonitorStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        ImmediateGraphNode opNode = new ImmediateGraphNode(stmt.getOp());
        this.graphBuilder.addEdge(new SingleOpAstEdge(stmtNode, opNode));
    }

    public void caseSwitchStmt(@Nonnull JSwitchStmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode((Stmt)stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
        ImmediateGraphNode switchKeyNode = new ImmediateGraphNode(stmt.getKey());
        this.graphBuilder.addEdge(new SwitchKeyAstEdge(stmtNode, switchKeyNode));
    }

    public void defaultCaseStmt(@Nonnull Stmt stmt) {
        StmtGraphNode stmtNode = new StmtGraphNode(stmt);
        this.graphBuilder.addEdge(new StmtAstEdge(this.parentNode, stmtNode));
    }
}

