/*
 * Decompiled with CFR 0.152.
 */
package sootup.codepropertygraph.cfg;

import sootup.codepropertygraph.propertygraph.PropertyGraph;
import sootup.codepropertygraph.propertygraph.StmtMethodPropertyGraph;
import sootup.codepropertygraph.propertygraph.edges.AbstCfgEdge;
import sootup.codepropertygraph.propertygraph.edges.ExceptionalCfgEdge;
import sootup.codepropertygraph.propertygraph.edges.GotoCfgEdge;
import sootup.codepropertygraph.propertygraph.edges.IfFalseCfgEdge;
import sootup.codepropertygraph.propertygraph.edges.IfTrueCfgEdge;
import sootup.codepropertygraph.propertygraph.edges.NormalCfgEdge;
import sootup.codepropertygraph.propertygraph.edges.SwitchCfgEdge;
import sootup.codepropertygraph.propertygraph.nodes.StmtGraphNode;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.common.stmt.JGotoStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.javabytecode.stmt.JSwitchStmt;
import sootup.core.model.SootMethod;

public class CfgCreator {
    public PropertyGraph createGraph(SootMethod method) {
        StmtMethodPropertyGraph.Builder graphBuilder = new StmtMethodPropertyGraph.Builder();
        graphBuilder.setName("cfg_" + method.getName());
        if (method.isAbstract() || method.isNative()) {
            return graphBuilder.build();
        }
        StmtGraph stmtGraph = method.getBody().getStmtGraph();
        stmtGraph.forEach(currStmt -> {
            int expectedCount = currStmt.getExpectedSuccessorCount();
            int successorIndex = 0;
            for (Stmt successor : stmtGraph.getAllSuccessors(currStmt)) {
                StmtGraphNode sourceNode = new StmtGraphNode((Stmt)currStmt);
                StmtGraphNode destinationNode = new StmtGraphNode(successor);
                AbstCfgEdge edge = this.createEdge((Stmt)currStmt, successorIndex, sourceNode, destinationNode);
                if (successorIndex >= expectedCount) {
                    edge = new ExceptionalCfgEdge(sourceNode, destinationNode);
                }
                graphBuilder.addEdge(edge);
                ++successorIndex;
            }
        });
        return graphBuilder.build();
    }

    private AbstCfgEdge createEdge(Stmt currStmt, int successorIndex, StmtGraphNode sourceNode, StmtGraphNode destinationNode) {
        if (currStmt instanceof JIfStmt) {
            return successorIndex == 1 ? new IfTrueCfgEdge(sourceNode, destinationNode) : new IfFalseCfgEdge(sourceNode, destinationNode);
        }
        if (currStmt instanceof JSwitchStmt) {
            return new SwitchCfgEdge(sourceNode, destinationNode);
        }
        if (currStmt instanceof JGotoStmt) {
            return new GotoCfgEdge(sourceNode, destinationNode);
        }
        return new NormalCfgEdge(sourceNode, destinationNode);
    }
}

