/*
 * Decompiled with CFR 0.152.
 */
package sootup.codepropertygraph.cpg;

import sootup.codepropertygraph.ast.AstCreator;
import sootup.codepropertygraph.cdg.CdgCreator;
import sootup.codepropertygraph.cfg.CfgCreator;
import sootup.codepropertygraph.ddg.DdgCreator;
import sootup.codepropertygraph.propertygraph.PropertyGraph;
import sootup.codepropertygraph.propertygraph.util.PropertyGraphsMerger;
import sootup.core.model.SootMethod;

public class CpgCreator {
    private final AstCreator astCreator;
    private final CfgCreator cfgCreator;
    private final CdgCreator cdgCreator;
    private final DdgCreator ddgCreator;

    public CpgCreator(AstCreator astCreator, CfgCreator cfgCreator, CdgCreator cdgCreator, DdgCreator ddgCreator) {
        this.astCreator = astCreator;
        this.cfgCreator = cfgCreator;
        this.cdgCreator = cdgCreator;
        this.ddgCreator = ddgCreator;
    }

    public PropertyGraph createCpg(SootMethod method) {
        PropertyGraph cpgGraph = this.astCreator.createGraph(method);
        cpgGraph = PropertyGraphsMerger.mergeGraphs(cpgGraph, this.cfgCreator.createGraph(method));
        cpgGraph = PropertyGraphsMerger.mergeGraphs(cpgGraph, this.cdgCreator.createGraph(method));
        cpgGraph = PropertyGraphsMerger.mergeGraphs(cpgGraph, this.ddgCreator.createGraph(method));
        return cpgGraph;
    }
}

