/*
 * Decompiled with CFR 0.152.
 */
package sootup.codepropertygraph.propertygraph.util;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import sootup.codepropertygraph.propertygraph.PropertyGraph;
import sootup.codepropertygraph.propertygraph.edges.AbstAstEdge;
import sootup.codepropertygraph.propertygraph.edges.AbstCdgEdge;
import sootup.codepropertygraph.propertygraph.edges.AbstDdgEdge;
import sootup.codepropertygraph.propertygraph.edges.PropertyGraphEdge;
import sootup.codepropertygraph.propertygraph.nodes.AggregateGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.ModifierGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.PropertyGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.StmtGraphNode;
import sootup.codepropertygraph.propertygraph.nodes.TypeGraphNode;

public class PropertyGraphToDotConverter {
    public static String convert(PropertyGraph graph) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("digraph %s {\n", graph.getName()));
        builder.append("\trankdir=TB;\n");
        builder.append("\tnode [style=filled, shape=record];\n");
        builder.append("\tedge [style=filled]\n");
        LinkedHashMap<PropertyGraphNode, String> nodeIds = new LinkedHashMap<PropertyGraphNode, String>();
        AtomicInteger nodeIdCounter = new AtomicInteger(1);
        List sortedNodes = graph.getNodes().stream().sorted(Comparator.comparing(PropertyGraphNode::toString)).collect(Collectors.toList());
        for (PropertyGraphNode node : sortedNodes) {
            String nodeId = nodeIds.computeIfAbsent(node, k -> String.valueOf(nodeIdCounter.getAndIncrement()));
            String label = PropertyGraphToDotConverter.getNodeLabel(node);
            String color = PropertyGraphToDotConverter.getNodeColor(node);
            builder.append(String.format("\t\"%s\" [label=\"%s\", fillcolor=\"%s\"];\n", nodeId, label, color));
        }
        List sortedEdges = graph.getEdges().stream().sorted(Comparator.comparing(edge -> (String)nodeIds.get(edge.getSource())).thenComparing(edge -> (String)nodeIds.get(edge.getDestination())).thenComparing(PropertyGraphEdge::getLabel)).collect(Collectors.toList());
        for (PropertyGraphEdge edge2 : sortedEdges) {
            String sourceId = (String)nodeIds.get(edge2.getSource());
            String destinationId = (String)nodeIds.get(edge2.getDestination());
            String label = PropertyGraphToDotConverter.escapeDot(edge2.getLabel());
            String color = PropertyGraphToDotConverter.getEdgeColor(edge2);
            builder.append(String.format("\t\"%s\" -> \"%s\"[label=\"%s\", color=\"%s\", fontcolor=\"%s\"];\n", sourceId, destinationId, label, color, color));
        }
        builder.append("}\n");
        return builder.toString();
    }

    private static String escapeDot(String label) {
        return label.replace("\"", "\\\"").replace("<", "&lt;").replace(">", "&gt;").replace("{", "\\{").replace("}", "\\}");
    }

    private static String getNodeLabel(PropertyGraphNode node) {
        return PropertyGraphToDotConverter.escapeDot(node.toString());
    }

    private static String getNodeColor(PropertyGraphNode node) {
        if (node instanceof StmtGraphNode) {
            return "lightblue";
        }
        if (node instanceof TypeGraphNode || node instanceof ModifierGraphNode) {
            return "lightgray";
        }
        if (node instanceof AggregateGraphNode) {
            return "darkseagreen2";
        }
        return "white";
    }

    private static String getEdgeColor(PropertyGraphEdge edge) {
        if (edge instanceof AbstAstEdge) {
            return "darkseagreen4";
        }
        if (edge instanceof AbstCdgEdge) {
            return "dodgerblue4";
        }
        if (edge instanceof AbstDdgEdge) {
            return "firebrick";
        }
        return "black";
    }
}

