/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInstanceInvokeExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.ReplaceUseStmtVisitor;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;

public class Aggregator
implements BodyInterceptor {
    protected boolean dontAggregateFieldLocals;

    public Aggregator() {
        this(false);
    }

    public Aggregator(boolean dontAggregateFieldLocals) {
        this.dontAggregateFieldLocals = dontAggregateFieldLocals;
    }

    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph graph = builder.getStmtGraph();
        List stmts = builder.getStmts();
        Map usesMap = Body.collectUses((Collection)stmts);
        for (Stmt stmt : stmts) {
            JAssignStmt assignStmt;
            LValue lhs;
            if (!(stmt instanceof JAssignStmt) || !((lhs = (assignStmt = (JAssignStmt)stmt).getLeftOp()) instanceof Local)) continue;
            Local lhsLocal = (Local)lhs;
            if (this.dontAggregateFieldLocals && !lhsLocal.getName().startsWith("$")) continue;
            Iterator iterator = assignStmt.getUses().iterator();
            while (iterator.hasNext()) {
                BasicBlock blockOfAssignment;
                Stmt newStmt;
                Iterator iter;
                List path;
                Stmt relevantDef;
                List defs;
                Collection usesOfVal;
                Value val = (Value)iterator.next();
                if (!(val instanceof Local) || (usesOfVal = (Collection)usesMap.get(val)).size() > 1 || (defs = ((Local)val).getDefs((Collection)stmts)).size() != 1 || !graph.containsNode(relevantDef = (Stmt)defs.get(0)) || !graph.containsNode(stmt) || (path = graph.getExtendedBasicBlockPathBetween(relevantDef, stmt)) == null) continue;
                boolean cantAggr = false;
                boolean propagatingInvokeExpr = false;
                boolean propagatingFieldRef = false;
                boolean propagatingArrayRef = false;
                ArrayList<JFieldRef> fieldRefList = new ArrayList<JFieldRef>();
                HashSet<Value> localsUsed = new HashSet<Value>();
                for (Stmt pathStmt : path) {
                    iter = pathStmt.getUses().iterator();
                    while (iter.hasNext()) {
                        Value use = (Value)iter.next();
                        if (use instanceof Local) {
                            localsUsed.add(use);
                            continue;
                        }
                        if (use instanceof AbstractInstanceInvokeExpr) {
                            propagatingInvokeExpr = true;
                            continue;
                        }
                        if (use instanceof JArrayRef) {
                            propagatingArrayRef = true;
                            continue;
                        }
                        if (!(use instanceof JFieldRef)) continue;
                        propagatingFieldRef = true;
                        fieldRefList.add((JFieldRef)use);
                    }
                }
                block6: for (Stmt pathStmt : path) {
                    Optional stmtDefOpt;
                    if (pathStmt != stmt && pathStmt != relevantDef && (stmtDefOpt = pathStmt.getDef()).isPresent()) {
                        LValue stmtDef = (LValue)stmtDefOpt.get();
                        if (localsUsed.contains(stmtDef)) {
                            cantAggr = true;
                            break;
                        }
                        if (propagatingInvokeExpr || propagatingFieldRef || propagatingArrayRef) {
                            if (stmtDef instanceof JFieldRef) {
                                if (propagatingInvokeExpr) {
                                    cantAggr = true;
                                    break;
                                }
                                if (propagatingFieldRef) {
                                    for (JFieldRef fieldRef : fieldRefList) {
                                        if (!fieldRef.equals((JFieldRef)stmtDef)) continue;
                                        cantAggr = true;
                                        break;
                                    }
                                }
                            } else if (stmtDef instanceof JArrayRef && (propagatingInvokeExpr || propagatingArrayRef)) {
                                cantAggr = true;
                                break;
                            }
                        }
                    }
                    if (!propagatingInvokeExpr && !propagatingFieldRef && !propagatingArrayRef) continue;
                    iter = stmt.getUses().iterator();
                    while (iter.hasNext()) {
                        Value value = (Value)iter.next();
                        if (pathStmt == stmt && value == lhs) continue block6;
                        if (!(value instanceof AbstractInstanceInvokeExpr) && (!propagatingInvokeExpr || !(value instanceof JFieldRef) && !(value instanceof JArrayRef))) continue;
                        cantAggr = true;
                        continue block6;
                    }
                }
                if (cantAggr || !(relevantDef instanceof JAssignStmt)) continue;
                Value aggregatee = ((AbstractDefinitionStmt)relevantDef).getRightOp();
                ReplaceUseStmtVisitor replaceVisitor = new ReplaceUseStmtVisitor(val, aggregatee);
                try {
                    replaceVisitor.caseAssignStmt(assignStmt);
                    newStmt = replaceVisitor.getResult();
                }
                catch (ClassCastException iae) {
                    continue;
                }
                if (stmt == newStmt) continue;
                BasicBlock blockOfDefinition = graph.getBlockOf(relevantDef);
                if (blockOfDefinition != (blockOfAssignment = graph.getBlockOf(stmt))) {
                    boolean missingEnxception = false;
                    Map assignmentsExceptionalSuccessors = blockOfAssignment.getExceptionalSuccessors();
                    for (Map.Entry entry : blockOfDefinition.getExceptionalSuccessors().entrySet()) {
                        ClassType type = (ClassType)entry.getKey();
                        BasicBlock handler = (BasicBlock)entry.getValue();
                        if (assignmentsExceptionalSuccessors.get(type) == handler) continue;
                        missingEnxception = true;
                        break;
                    }
                    if (missingEnxception) continue;
                }
                graph.replaceNode(stmt, newStmt);
                if (graph.getStartingStmt() == relevantDef) {
                    Stmt newStartingStmt = (Stmt)builder.getStmtGraph().successors(relevantDef).get(0);
                    graph.setStartingStmt(newStartingStmt);
                }
                graph.removeNode(relevantDef);
                builder.removeDefLocalsOf(relevantDef);
            }
        }
    }
}

