/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.BooleanConstant;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.DoubleConstant;
import sootup.core.jimple.common.constant.FloatConstant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.stmt.BranchingStmt;
import sootup.core.jimple.common.stmt.FallsThroughStmt;
import sootup.core.jimple.common.stmt.JIfStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.views.View;
import sootup.interceptors.Evaluator;

public class ConditionalBranchFolder
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        for (Stmt stmt : Lists.newArrayList((Iterable)stmtGraph.getNodes())) {
            Stmt neverReachedSucessor;
            Stmt tautologicSuccessor;
            boolean removeTrueBranch;
            if (!(stmt instanceof JIfStmt)) continue;
            JIfStmt ifStmt = (JIfStmt)stmt;
            Constant evaluatedCondition = Evaluator.getConstantValueOf((Value)ifStmt.getCondition());
            if (evaluatedCondition instanceof BooleanConstant) {
                removeTrueBranch = evaluatedCondition == BooleanConstant.getTrue();
            } else if (evaluatedCondition instanceof IntConstant) {
                removeTrueBranch = IntConstant.getInstance((int)0).equalEqual((IntConstant)evaluatedCondition) == BooleanConstant.getFalse();
            } else if (evaluatedCondition instanceof DoubleConstant) {
                removeTrueBranch = DoubleConstant.getInstance((double)0.0).equalEqual((DoubleConstant)evaluatedCondition) == BooleanConstant.getFalse();
            } else if (evaluatedCondition instanceof FloatConstant) {
                removeTrueBranch = FloatConstant.getInstance((float)0.0f).equalEqual((FloatConstant)evaluatedCondition) == BooleanConstant.getFalse();
            } else {
                if (!(evaluatedCondition instanceof LongConstant)) continue;
                removeTrueBranch = LongConstant.getInstance((long)0L).equalEqual((LongConstant)evaluatedCondition) == BooleanConstant.getFalse();
            }
            List ifSuccessors = stmtGraph.successors((Stmt)ifStmt);
            if (removeTrueBranch) {
                tautologicSuccessor = (Stmt)ifSuccessors.get(0);
                neverReachedSucessor = (Stmt)ifSuccessors.get(1);
            } else {
                tautologicSuccessor = (Stmt)ifSuccessors.get(1);
                neverReachedSucessor = (Stmt)ifSuccessors.get(0);
            }
            for (Stmt predecessor : stmtGraph.predecessors((Stmt)ifStmt)) {
                List successorIdxList = stmtGraph.removeEdge(predecessor, (Stmt)ifStmt);
                if (predecessor instanceof FallsThroughStmt) {
                    FallsThroughStmt fallsThroughPred = (FallsThroughStmt)predecessor;
                    for (Integer successorIdx : successorIdxList) {
                        stmtGraph.putEdge(fallsThroughPred, tautologicSuccessor);
                    }
                    continue;
                }
                BranchingStmt branchingPred = (BranchingStmt)predecessor;
                for (Integer successorIdx : successorIdxList) {
                    stmtGraph.putEdge(branchingPred, successorIdx.intValue(), tautologicSuccessor);
                }
            }
            stmtGraph.removeNode((Stmt)ifStmt, false);
            this.pruneExclusivelyReachableStmts(builder, neverReachedSucessor);
        }
    }

    private void pruneExclusivelyReachableStmts(@Nonnull Body.BodyBuilder builder, @Nonnull Stmt fallsThroughStmt) {
        Stmt itStmt;
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        HashSet<Stmt> reachedBranchingStmts = new HashSet<Stmt>();
        ArrayDeque<Stmt> q = new ArrayDeque<Stmt>();
        q.addFirst(fallsThroughStmt);
        while (!q.isEmpty()) {
            List predecessors;
            itStmt = (Stmt)q.pollFirst();
            if (itStmt.branches()) {
                reachedBranchingStmts.add(itStmt);
            }
            if (!stmtGraph.containsNode(itStmt) || (predecessors = stmtGraph.predecessors(itStmt)).size() > 1) continue;
            q.addAll(stmtGraph.successors(itStmt));
        }
        q.addFirst(fallsThroughStmt);
        while (!q.isEmpty()) {
            itStmt = (Stmt)q.pollFirst();
            if (!stmtGraph.containsNode(itStmt) || !this.isExclusivelyReachable((StmtGraph<?>)stmtGraph, itStmt, (Set<Stmt>)reachedBranchingStmts)) continue;
            q.addAll(stmtGraph.successors(itStmt));
            stmtGraph.removeNode(itStmt, false);
            builder.removeDefLocalsOf(itStmt);
        }
    }

    private boolean isExclusivelyReachable(@Nonnull StmtGraph<?> graph, @Nonnull Stmt stmt, @Nonnull Set<Stmt> reachedStmts) {
        int predecessorSize;
        List predecessors = graph.predecessors(stmt);
        int amount = predecessorSize = predecessors.size();
        if (predecessorSize <= 1) {
            return true;
        }
        for (Stmt predecessor : predecessors) {
            if (predecessor.fallsThrough()) {
                if (predecessor instanceof JIfStmt) {
                    List predsSuccessors = graph.successors(predecessor);
                    if (predsSuccessors.size() > 0 && predsSuccessors.get(0) == stmt) {
                        --amount;
                        continue;
                    }
                } else {
                    --amount;
                    continue;
                }
            }
            if (!reachedStmts.contains(predecessor)) continue;
            --amount;
        }
        return amount == 0;
    }
}

