/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.Constant;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.LongConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ReferenceType;
import sootup.core.views.View;

public class CopyPropagator
implements BodyInterceptor {
    static final IntConstant zeroIntConstInstance = IntConstant.getInstance((int)0);
    static final LongConstant zeroLongConstInstance = LongConstant.getInstance((long)0L);

    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        Iterator iterator = Lists.newArrayList((Iterable)stmtGraph).iterator();
        while (iterator.hasNext()) {
            Stmt stmt;
            Stmt newStmt = stmt = (Stmt)iterator.next();
            Set valueList = newStmt.getUses().collect(Collectors.toSet());
            for (Value use : valueList) {
                Stmt s;
                Local m;
                List defsOfUse;
                if (!(use instanceof Local) || !this.isPropatabable(defsOfUse = ((Local)use).getDefsForLocalUse((StmtGraph)stmtGraph, newStmt))) continue;
                AbstractDefinitionStmt defStmt = (AbstractDefinitionStmt)defsOfUse.get(0);
                Value rhs = defStmt.getRightOp();
                if (rhs instanceof Constant) {
                    newStmt = this.replaceUse(stmtGraph, newStmt, use, rhs);
                    continue;
                }
                if (rhs instanceof JCastExpr && rhs.getType() instanceof ReferenceType) {
                    Immediate op = ((JCastExpr)rhs).getOp();
                    if (!zeroIntConstInstance.equals((Object)op) && !zeroLongConstInstance.equals((Object)op)) continue;
                    newStmt = this.replaceUse(stmtGraph, newStmt, use, (Value)NullConstant.getInstance());
                    continue;
                }
                if (!(rhs instanceof Local) || rhs.equivTo((Object)use) || use == (m = (Local)rhs)) continue;
                Integer defCount = m.getDefs((Collection)stmtGraph.getStmts()).size();
                if (defCount == 0) {
                    throw new IllegalStateException("Local `" + m + "' is used without a definition!");
                }
                if (defCount == 1) {
                    newStmt = this.replaceUse(stmtGraph, newStmt, use, rhs);
                    continue;
                }
                List path = stmtGraph.getExtendedBasicBlockPathBetween((Stmt)defStmt, newStmt);
                if (path == null) continue;
                boolean isRedefined = false;
                Iterator pathIt = path.iterator();
                pathIt.next();
                while (pathIt.hasNext() && newStmt != (s = (Stmt)pathIt.next())) {
                    if (!(s instanceof AbstractDefinitionStmt) || ((AbstractDefinitionStmt)s).getLeftOp() != m) continue;
                    isRedefined = true;
                    break;
                }
                if (isRedefined) continue;
                newStmt = this.replaceUse(stmtGraph, newStmt, use, rhs);
            }
        }
    }

    private Stmt replaceUse(@Nonnull MutableStmtGraph graph, @Nonnull Stmt stmt, @Nonnull Value use, @Nonnull Value rhs) {
        if (rhs != use) {
            Stmt newStmt = stmt.withNewUse(use, rhs);
            if (newStmt != stmt) {
                graph.replaceNode(stmt, newStmt);
            }
            return newStmt;
        }
        return stmt;
    }

    private boolean isPropatabable(@Nonnull List<Stmt> defsOfUse) {
        boolean isPropagateable = false;
        if (defsOfUse.size() == 1) {
            isPropagateable = true;
        } else if (defsOfUse.size() > 1) {
            Constant con = null;
            for (Stmt defStmt : defsOfUse) {
                if (defStmt instanceof JAssignStmt && ((JAssignStmt)defStmt).getRightOp() instanceof Constant) {
                    Constant rhs = (Constant)((JAssignStmt)defStmt).getRightOp();
                    if (con == null) {
                        con = rhs;
                        continue;
                    }
                    if (rhs.equals((Object)con)) {
                        isPropagateable = true;
                        continue;
                    }
                    isPropagateable = false;
                    break;
                }
                isPropagateable = false;
                break;
            }
        }
        return isPropagateable;
    }
}

