/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import sootup.analysis.intraprocedural.reachingdefs.ReachingDefs;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.constant.IntConstant;
import sootup.core.jimple.common.constant.NullConstant;
import sootup.core.jimple.common.expr.AbstractBinopExpr;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.expr.JCastExpr;
import sootup.core.jimple.common.expr.JDivExpr;
import sootup.core.jimple.common.expr.JNewArrayExpr;
import sootup.core.jimple.common.expr.JNewExpr;
import sootup.core.jimple.common.expr.JNewMultiArrayExpr;
import sootup.core.jimple.common.expr.JRemExpr;
import sootup.core.jimple.common.ref.JArrayRef;
import sootup.core.jimple.common.ref.JFieldRef;
import sootup.core.jimple.common.ref.JInstanceFieldRef;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JInvokeStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.model.MethodModifier;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.ReferenceType;
import sootup.core.types.Type;
import sootup.core.types.UnknownType;
import sootup.core.views.View;

public class DeadAssignmentEliminator
implements BodyInterceptor {
    boolean eliminateOnlyStackLocals;

    public DeadAssignmentEliminator() {
        this(false);
    }

    public DeadAssignmentEliminator(boolean eliminateOnlyStackLocals) {
        this.eliminateOnlyStackLocals = eliminateOnlyStackLocals;
    }

    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        Map reachingDefs = new ReachingDefs((StmtGraph)stmtGraph).getReachingDefs();
        List stmts = builder.getStmts();
        ArrayDeque<Stmt> deque = new ArrayDeque<Stmt>(stmts.size());
        boolean isStatic = MethodModifier.isStatic((Set)builder.getModifiers());
        boolean allEssential = true;
        boolean containsInvoke = false;
        Local thisLocal = null;
        for (Stmt stmt : stmtGraph.getNodes()) {
            boolean isEssential = true;
            if (stmt instanceof JAssignStmt) {
                Value rhs;
                JAssignStmt assignStmt = (JAssignStmt)stmt;
                LValue lhs = assignStmt.getLeftOp();
                if (lhs == (rhs = assignStmt.getRightOp()) && lhs instanceof Local) continue;
                if (lhs instanceof Local && (!this.eliminateOnlyStackLocals || ((Local)lhs).getName().startsWith("$") || lhs.getType() instanceof NullType)) {
                    isEssential = false;
                    if (!containsInvoke) {
                        containsInvoke = assignStmt.containsInvokeExpr();
                    }
                    if (rhs instanceof JCastExpr) {
                        JCastExpr castExpr = (JCastExpr)rhs;
                        Type type = castExpr.getType();
                        Immediate value = castExpr.getOp();
                        isEssential = !(value instanceof NullConstant) && type instanceof ReferenceType;
                    } else if (rhs instanceof AbstractInvokeExpr || rhs instanceof JArrayRef || rhs instanceof JNewExpr || rhs instanceof JNewArrayExpr || rhs instanceof JNewMultiArrayExpr) {
                        isEssential = true;
                    } else if (rhs instanceof JFieldRef) {
                        isEssential = true;
                        if (rhs instanceof JInstanceFieldRef) {
                            JInstanceFieldRef instanceFieldRef = (JInstanceFieldRef)rhs;
                            if (!isStatic && thisLocal == null) {
                                thisLocal = Body.getThisLocal((StmtGraph)stmtGraph);
                            }
                            isEssential = isStatic || thisLocal != instanceFieldRef.getBase();
                        }
                    } else if (rhs instanceof JDivExpr || rhs instanceof JRemExpr) {
                        AbstractBinopExpr expr = (AbstractBinopExpr)rhs;
                        Type type1 = expr.getOp1().getType();
                        Type type2 = expr.getOp2().getType();
                        boolean type2Int = type2 instanceof PrimitiveType && type2.equals(PrimitiveType.getInt());
                        boolean bl = isEssential = type2Int || type1 instanceof PrimitiveType && (type1.equals(PrimitiveType.getInt()) || type1.equals(PrimitiveType.getLong())) || type2 instanceof PrimitiveType && type2.equals(PrimitiveType.getLong()) || type1 instanceof UnknownType || type2 instanceof UnknownType;
                        if (isEssential && type2Int) {
                            IntConstant intConstant;
                            Immediate value = expr.getOp2();
                            isEssential = value instanceof IntConstant ? (intConstant = (IntConstant)value).getValue() == 0 : true;
                        }
                    }
                }
            }
            if (isEssential) {
                deque.addFirst(stmt);
            }
            allEssential &= isEssential;
        }
        if (!containsInvoke && allEssential) {
            return;
        }
        Map allDefs = Body.collectDefs((Collection)stmtGraph.getNodes());
        HashSet<Stmt> essentialStmts = new HashSet<Stmt>(stmts.size());
        while (!deque.isEmpty()) {
            Stmt stmt = (Stmt)deque.removeFirst();
            if (!essentialStmts.add(stmt)) continue;
            Iterator iterator = stmt.getUses().iterator();
            while (iterator.hasNext()) {
                Value value = (Value)iterator.next();
                if (!(value instanceof Local)) continue;
                Local local = (Local)value;
                Collection defs = (Collection)allDefs.get(local);
                List reachableDefs = (List)reachingDefs.get(stmt);
                if ((defs = (Collection)defs.stream().filter(reachableDefs::contains).collect(Collectors.toList())) == null) continue;
                deque.addAll(defs);
            }
        }
        for (Stmt stmt : stmts) {
            if (essentialStmts.contains(stmt) || !stmtGraph.containsNode(stmt)) continue;
            stmtGraph.removeNode(stmt);
            builder.removeDefLocalsOf(stmt);
        }
        if (!containsInvoke) {
            return;
        }
        Map essentialUses = Body.collectUses(essentialStmts);
        ArrayList<JAssignStmt> postProcess = new ArrayList<JAssignStmt>();
        for (Stmt stmt : stmts) {
            JAssignStmt assignStmt;
            if (!(stmt instanceof JAssignStmt) || !(assignStmt = (JAssignStmt)stmt).containsInvokeExpr()) continue;
            boolean deadAssignment = true;
            Iterator iterator = assignStmt.getUsesAndDefs().iterator();
            while (iterator.hasNext()) {
                Collection stmtsWithValuesUse;
                Value value = (Value)iterator.next();
                if (!(value instanceof LValue) || (stmtsWithValuesUse = (Collection)essentialUses.get(value)) == null) continue;
                deadAssignment = false;
                break;
            }
            if (!deadAssignment) continue;
            postProcess.add(assignStmt);
        }
        for (JAssignStmt assignStmt : postProcess) {
            JInvokeStmt newInvoke = Jimple.newInvokeStmt((AbstractInvokeExpr)((AbstractInvokeExpr)assignStmt.getInvokeExpr().get()), (StmtPositionInfo)assignStmt.getPositionInfo());
            stmtGraph.replaceNode((Stmt)assignStmt, (Stmt)newInvoke);
            builder.removeDefLocalsOf((Stmt)assignStmt);
        }
    }
}

