/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.Stmt;

public class LocalLivenessAnalyser {
    private final Map<Stmt, Set<Local>> liveIn = new HashMap<Stmt, Set<Local>>();
    private final Map<Stmt, Set<Local>> liveOut = new HashMap<Stmt, Set<Local>>();

    public LocalLivenessAnalyser(@Nonnull StmtGraph<?> graph) {
        ArrayList<Stmt> startingStmts = new ArrayList<Stmt>();
        for (Stmt stmt : graph.getNodes()) {
            this.liveIn.put(stmt, Collections.emptySet());
            this.liveOut.put(stmt, Collections.emptySet());
            if (!graph.successors(stmt).isEmpty() || !graph.exceptionalSuccessors(stmt).isEmpty()) continue;
            startingStmts.add(stmt);
        }
        boolean fixed = false;
        while (!fixed) {
            fixed = true;
            ArrayDeque<Stmt> queue = new ArrayDeque<Stmt>(startingStmts);
            HashSet<Stmt> visitedStmts = new HashSet<Stmt>();
            while (!queue.isEmpty()) {
                Value value;
                Stmt stmt = (Stmt)queue.removeFirst();
                visitedStmts.add(stmt);
                Set<Local> out = new HashSet<Local>((Collection)this.liveOut.get(stmt));
                for (Stmt succ : graph.successors(stmt)) {
                    out = this.merge(out, this.liveIn.get(succ));
                }
                for (Stmt esucc : graph.exceptionalSuccessors(stmt).values()) {
                    out = this.merge(out, this.liveIn.get(esucc));
                }
                if (this.isNotEqual(out, this.liveOut.get(stmt))) {
                    fixed = false;
                    this.liveOut.put(stmt, new HashSet<Local>(out));
                }
                Set<Local> in = new HashSet<Local>();
                Iterator iterator = stmt.getUses().iterator();
                while (iterator.hasNext()) {
                    Value use = (Value)iterator.next();
                    if (!(use instanceof Local)) continue;
                    in.add((Local)use);
                }
                Optional def = stmt.getDef();
                if (def.isPresent() && (value = (Value)def.get()) instanceof Local) {
                    out.remove(value);
                }
                if (this.isNotEqual(in = this.merge(in, out), this.liveIn.get(stmt))) {
                    fixed = false;
                    this.liveIn.put(stmt, in);
                }
                for (Stmt pred : graph.predecessors(stmt)) {
                    if (visitedStmts.contains(pred)) continue;
                    queue.addLast(pred);
                }
                for (Stmt epred : graph.exceptionalPredecessors(stmt)) {
                    if (visitedStmts.contains(epred)) continue;
                    queue.addLast(epred);
                }
            }
        }
    }

    @Nonnull
    public Set<Local> getLiveLocalsBeforeStmt(@Nonnull Stmt stmt) {
        if (!this.liveIn.containsKey(stmt)) {
            throw new RuntimeException("Stmt: " + stmt + " is not in StmtGraph!");
        }
        return this.liveIn.get(stmt);
    }

    @Nonnull
    public Set<Local> getLiveLocalsAfterStmt(@Nonnull Stmt stmt) {
        if (!this.liveOut.containsKey(stmt)) {
            throw new RuntimeException("Stmt: " + stmt + " is not in StmtGraph!");
        }
        return this.liveOut.get(stmt);
    }

    @Nonnull
    private Set<Local> merge(@Nonnull Set<Local> set1, @Nonnull Set<Local> set2) {
        if (set1.isEmpty()) {
            return set2;
        }
        set1.addAll(set2);
        return set1;
    }

    private boolean isNotEqual(@Nonnull Set<Local> set1, @Nonnull Set<Local> set2) {
        if (set1.size() != set2.size()) {
            return true;
        }
        for (Local local : set1) {
            if (set2.contains(local)) continue;
            return true;
        }
        return false;
    }
}

