/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.LocalGenerator;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.Type;
import sootup.core.views.View;

public class LocalNameStandardizer
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph graph = builder.getStmtGraph();
        HashMap<Local, Integer> localToFirstOccurrence = new HashMap<Local, Integer>();
        int defsCount = 0;
        for (Stmt stmt : graph) {
            LValue def;
            Optional defOpt = stmt.getDef();
            if (!defOpt.isPresent() || !((def = (LValue)defOpt.get()) instanceof Local)) continue;
            Local localDef = (Local)def;
            localToFirstOccurrence.putIfAbsent(localDef, defsCount);
            ++defsCount;
        }
        Iterator iterator = localToFirstOccurrence.keySet().stream().sorted(new LocalComparator(localToFirstOccurrence)).iterator();
        LocalGenerator lgen = new LocalGenerator(new HashSet());
        while (iterator.hasNext()) {
            Local local = (Local)iterator.next();
            Type type = local.getType();
            Local newLocal = lgen.generateLocal(type);
            builder.replaceLocal(local, newLocal);
        }
    }

    public static class LocalComparator
    implements Comparator<Local> {
        Map<Local, Integer> localToFirstOccurence;

        public LocalComparator(Map<Local, Integer> localToInteger) {
            this.localToFirstOccurence = localToInteger;
        }

        @Override
        public int compare(Local localA, Local localB) {
            int result = localA.getType().toString().compareTo(localB.getType().toString());
            if (result == 0) {
                result = Integer.compare(this.localToFirstOccurence.get(localA), this.localToFirstOccurence.get(localB));
            }
            return result;
        }
    }
}

