/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.AbstractDefinitionStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.interceptors.LocalLivenessAnalyser;

public class LocalPacker
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph stmtGraph = builder.getStmtGraph();
        Map<Local, Integer> localToColor = this.assignLocalsColor(builder);
        HashMap<Local, Local> localToNewLocal = new HashMap<Local, Local>();
        HashMap newLocalToLocals = new HashMap();
        ArrayList originalLocals = new ArrayList(builder.getLocals());
        HashMap<TypeColorPair, Local> typeColorToLocal = new HashMap<TypeColorPair, Local>();
        int localIndex = 0;
        for (Local original : originalLocals) {
            Local newLocal;
            int color;
            Type type = original.getType();
            TypeColorPair pair = new TypeColorPair(type, color = localToColor.get(original).intValue());
            if (typeColorToLocal.containsKey(pair)) {
                newLocal = (Local)typeColorToLocal.get(pair);
            } else {
                int i;
                String name = original.getName();
                for (i = 0; i < name.length() && !Character.isDigit(name.charAt(i)); ++i) {
                }
                String newName = name.substring(0, i) + '*' + localIndex;
                ++localIndex;
                newLocal = original.withName(newName);
                typeColorToLocal.put(pair, newLocal);
            }
            localToNewLocal.put(original, newLocal);
            if (!newLocalToLocals.containsKey(newLocal)) {
                newLocalToLocals.put(newLocal, new ArrayList());
            }
            ((List)newLocalToLocals.get(newLocal)).add(original);
        }
        LinkedHashSet<Local> newLocals = new LinkedHashSet<Local>();
        Iterator iterator = Lists.newArrayList((Iterable)stmtGraph).iterator();
        while (iterator.hasNext()) {
            Local def;
            List oriLocals;
            String reasonableName;
            int starPos;
            Local newLocal;
            Stmt stmt;
            Stmt newStmt = stmt = (Stmt)iterator.next();
            Iterator iterator2 = stmt.getUses().iterator();
            while (iterator2.hasNext()) {
                Value use = (Value)iterator2.next();
                if (!(use instanceof Local) || (newLocal = (Local)localToNewLocal.get(use)) == null) continue;
                if (!newLocals.contains(newLocal)) {
                    starPos = newLocal.getName().indexOf(42);
                    reasonableName = newLocal.getName().substring(0, starPos) + newLocals.size();
                    oriLocals = (List)newLocalToLocals.get(newLocal);
                    newLocal = newLocal.withName(reasonableName);
                    newLocals.add(newLocal);
                    for (Local ori : oriLocals) {
                        localToNewLocal.put(ori, newLocal);
                    }
                }
                newStmt = newStmt.withNewUse(use, (Value)newLocal);
            }
            Optional defOpt = stmt.getDef();
            if (defOpt.isPresent() && defOpt.get() instanceof Local && (newLocal = (Local)localToNewLocal.get(def = (Local)defOpt.get())) != null) {
                if (!newLocals.contains(newLocal)) {
                    starPos = newLocal.getName().indexOf(42);
                    reasonableName = newLocal.getName().substring(0, starPos) + newLocals.size();
                    oriLocals = (List)newLocalToLocals.get(newLocal);
                    newLocal = newLocal.withName(reasonableName);
                    newLocals.add(newLocal);
                    for (Local ori : oriLocals) {
                        localToNewLocal.put(ori, newLocal);
                    }
                }
                newStmt = ((AbstractDefinitionStmt)newStmt).withNewDef(newLocal);
            }
            if (stmt.equals((Object)newStmt)) continue;
            stmtGraph.replaceNode(stmt, newStmt);
        }
        builder.setLocals(newLocals);
    }

    private Map<Local, Integer> assignLocalsColor(Body.BodyBuilder builder) {
        HashMap<Local, Integer> localToColor = new HashMap<Local, Integer>();
        HashMap<Type, Integer> typeToColorCount = new HashMap<Type, Integer>();
        for (Local local : builder.getLocals()) {
            Type type = local.getType();
            if (typeToColorCount.containsKey(type)) continue;
            typeToColorCount.put(type, 0);
        }
        for (Stmt stmt : builder.getStmts()) {
            if (!(stmt instanceof JIdentityStmt) || !(((JIdentityStmt)stmt).getLeftOp() instanceof Local)) continue;
            Local l = ((JIdentityStmt)stmt).getLeftOp();
            Type type = l.getType();
            int count = (Integer)typeToColorCount.get(type);
            localToColor.put(l, count);
            typeToColorCount.put(type, ++count);
        }
        Map<Local, Set<Local>> localInterferenceMap = this.buildLocalInterferenceMap(builder);
        ArrayList sortedLocals = new ArrayList(builder.getLocals());
        sortedLocals.sort((o1, o2) -> {
            int num1 = localInterferenceMap.containsKey(o1) ? ((Set)localInterferenceMap.get(o1)).size() : 0;
            int num2 = localInterferenceMap.containsKey(o2) ? ((Set)localInterferenceMap.get(o2)).size() : 0;
            return num2 - num1;
        });
        for (Local local : sortedLocals) {
            if (localToColor.containsKey(local)) continue;
            Type type = local.getType();
            int colorCount = (Integer)typeToColorCount.get(type);
            BitSet unavailableColors = new BitSet(colorCount);
            if (localInterferenceMap.containsKey(local)) {
                Set<Local> interferences = localInterferenceMap.get(local);
                for (Local interference : interferences) {
                    if (!localToColor.containsKey(interference)) continue;
                    unavailableColors.set((Integer)localToColor.get(interference));
                }
            }
            int assignedColor = -1;
            for (int i = 0; i < colorCount; ++i) {
                if (unavailableColors.get(i)) continue;
                assignedColor = i;
                break;
            }
            if (assignedColor < 0) {
                assignedColor = ++colorCount;
                typeToColorCount.put(type, colorCount);
            }
            localToColor.put(local, assignedColor);
        }
        return localToColor;
    }

    private Map<Local, Set<Local>> buildLocalInterferenceMap(Body.BodyBuilder builder) {
        HashMap<Local, Set<Local>> localToLocals = new HashMap<Local, Set<Local>>();
        MutableStmtGraph graph = builder.getStmtGraph();
        LocalLivenessAnalyser analyser = new LocalLivenessAnalyser((StmtGraph<?>)graph);
        for (Stmt stmt : builder.getStmts()) {
            if (!stmt.getDef().isPresent() || !(stmt.getDef().get() instanceof Local)) continue;
            Local def = (Local)stmt.getDef().get();
            HashSet<Local> aliveLocals = new HashSet<Local>();
            for (Stmt succ : graph.successors(stmt)) {
                aliveLocals.addAll(analyser.getLiveLocalsBeforeStmt(succ));
            }
            for (Stmt esucc : graph.exceptionalSuccessors(stmt).values()) {
                aliveLocals.addAll(analyser.getLiveLocalsBeforeStmt(esucc));
            }
            for (Local aliveLocal : aliveLocals) {
                HashSet<Local> locals;
                if (aliveLocal == def || !aliveLocal.getType().equals(def.getType())) continue;
                if (localToLocals.containsKey(def)) {
                    ((Set)localToLocals.get(def)).add(aliveLocal);
                } else {
                    locals = new HashSet<Local>();
                    locals.add(aliveLocal);
                    localToLocals.put(def, locals);
                }
                if (localToLocals.containsKey(aliveLocal)) {
                    ((Set)localToLocals.get(aliveLocal)).add(def);
                    continue;
                }
                locals = new HashSet();
                locals.add(def);
                localToLocals.put(aliveLocal, locals);
            }
        }
        return localToLocals;
    }

    private static class TypeColorPair {
        private Type type;
        private int color;

        public TypeColorPair(Type type, int color) {
            this.setType(type);
            this.setColor(color);
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public int getColor() {
            return this.color;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public int hashCode() {
            return this.getType().hashCode() + 1013 * this.getColor();
        }

        public boolean equals(Object other) {
            if (other instanceof TypeColorPair) {
                return ((TypeColorPair)other).getType().equals(this.getType()) && ((TypeColorPair)other).getColor() == this.getColor();
            }
            return false;
        }
    }
}

