/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import sootup.core.graph.BasicBlock;
import sootup.core.graph.MutableBasicBlock;
import sootup.core.graph.MutableStmtGraph;
import sootup.core.model.Body;
import sootup.core.transform.BodyInterceptor;
import sootup.core.views.View;

public class UnreachableCodeEliminator
implements BodyInterceptor {
    public void interceptBody(@Nonnull Body.BodyBuilder builder, @Nonnull View view) {
        MutableStmtGraph graph = builder.getStmtGraph();
        if (graph.getStmts().isEmpty() && graph.getNodes().isEmpty()) {
            return;
        }
        Collection allBlocks = graph.getBlocks();
        MutableBasicBlock startingStmtBlock = (MutableBasicBlock)graph.getStartingStmtBlock();
        HashSet<MutableBasicBlock> reachableNodes = new HashSet<MutableBasicBlock>();
        ArrayDeque<MutableBasicBlock> stack = new ArrayDeque<MutableBasicBlock>();
        stack.push(startingStmtBlock);
        while (!stack.isEmpty()) {
            MutableBasicBlock currentBlock = (MutableBasicBlock)stack.pop();
            if (!reachableNodes.add(currentBlock)) continue;
            ArrayList currentBlockExceptionalSuccessors = new ArrayList(currentBlock.getExceptionalSuccessors().values());
            List currentBlockSuccessors = currentBlock.getSuccessors();
            ArrayList currentBlockAllSuccessors = new ArrayList(currentBlockSuccessors);
            currentBlockAllSuccessors.addAll(currentBlockExceptionalSuccessors);
            for (MutableBasicBlock successor : currentBlockAllSuccessors) {
                if (reachableNodes.contains(successor)) continue;
                stack.push(successor);
            }
        }
        Iterator iterator = allBlocks.iterator();
        while (iterator.hasNext()) {
            BasicBlock basicBlock = (BasicBlock)iterator.next();
            if (reachableNodes.contains(basicBlock)) continue;
            iterator.remove();
            graph.removeBlock(basicBlock);
        }
    }
}

