/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors.typeresolving;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;
import sootup.core.IdentifierFactory;
import sootup.core.typehierarchy.TypeHierarchy;
import sootup.core.types.ArrayType;
import sootup.core.types.ClassType;
import sootup.core.types.NullType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.core.views.View;
import sootup.interceptors.typeresolving.PrimitiveHierarchy;
import sootup.interceptors.typeresolving.types.BottomType;
import sootup.interceptors.typeresolving.types.TopType;

public class BytecodeHierarchy {
    private final TypeHierarchy typeHierarchy;
    public final ClassType objectClassType;
    public final ClassType throwableClassType;
    private final ClassType serializableClassType;
    private final ClassType cloneableClassType;

    public BytecodeHierarchy(View view) {
        this.typeHierarchy = view.getTypeHierarchy();
        IdentifierFactory factory = view.getIdentifierFactory();
        this.objectClassType = factory.getClassType("java.lang.Object");
        this.throwableClassType = factory.getClassType("java.lang.Throwable");
        this.serializableClassType = factory.getClassType("java.io.Serializable");
        this.cloneableClassType = factory.getClassType("java.lang.Cloneable");
    }

    boolean contains(ClassType type) {
        return this.typeHierarchy.contains(type);
    }

    public boolean isAncestor(@Nonnull Type ancestor, @Nonnull Type child) {
        if (PrimitiveHierarchy.isAncestor(ancestor, child)) {
            return true;
        }
        if (!PrimitiveHierarchy.arePrimitives(ancestor, child)) {
            if (ancestor == child) {
                return true;
            }
            if (ancestor.getClass() == TopType.class) {
                return true;
            }
            if (child.getClass() == TopType.class) {
                return false;
            }
            if (child.getClass() == BottomType.class) {
                return true;
            }
            if (ancestor.getClass() == BottomType.class) {
                return false;
            }
            if (ancestor instanceof PrimitiveType || child instanceof PrimitiveType) {
                return false;
            }
            if (child == NullType.getInstance()) {
                return true;
            }
            if (ancestor == NullType.getInstance()) {
                return false;
            }
            if (child instanceof ClassType && ancestor instanceof ClassType) {
                return this.canStoreType((ClassType)ancestor, (ClassType)child);
            }
            if (child instanceof ArrayType && ancestor instanceof ClassType) {
                return ancestor == this.objectClassType || ancestor == this.serializableClassType || ancestor == this.cloneableClassType;
            }
            if (child instanceof ArrayType && ancestor instanceof ArrayType) {
                ArrayType ancestorArr = (ArrayType)ancestor;
                ArrayType childArr = (ArrayType)child;
                Type ancestorBase = ancestorArr.getBaseType();
                Type childBase = childArr.getBaseType();
                if (ancestorArr.getDimension() == childArr.getDimension()) {
                    if (ancestorBase == childBase || ancestorBase == TopType.getInstance()) {
                        return true;
                    }
                    if (ancestorBase instanceof ClassType && childBase instanceof ClassType) {
                        return this.canStoreType((ClassType)ancestorBase, (ClassType)childBase);
                    }
                } else if (ancestorArr.getDimension() < childArr.getDimension()) {
                    return ancestorBase == this.objectClassType || ancestorBase == this.serializableClassType || ancestorBase == this.cloneableClassType || ancestorBase == TopType.getInstance();
                }
            }
        }
        return false;
    }

    public Collection<Type> getLeastCommonAncestors(Type a, Type b) {
        HashSet<Type> ret = new HashSet<Type>();
        if (a instanceof TopType || b instanceof TopType) {
            return Collections.singleton(TopType.getInstance());
        }
        if (a instanceof BottomType) {
            return Collections.singleton(b);
        }
        if (b instanceof BottomType) {
            return Collections.singleton(a);
        }
        if (a == NullType.getInstance()) {
            return Collections.singleton(b);
        }
        if (b == NullType.getInstance()) {
            return Collections.singleton(a);
        }
        if (this.isAncestor(a, b)) {
            return Collections.singleton(a);
        }
        if (this.isAncestor(b, a)) {
            return Collections.singleton(b);
        }
        if (a instanceof PrimitiveType && b instanceof PrimitiveType) {
            return PrimitiveHierarchy.getLeastCommonAncestor(a, b);
        }
        if (a instanceof PrimitiveType || b instanceof PrimitiveType) {
            return Collections.singleton(TopType.getInstance());
        }
        if (a instanceof ArrayType && b instanceof ArrayType) {
            Type et_a = ((ArrayType)a).getElementType();
            Type et_b = ((ArrayType)b).getElementType();
            Collection<Object> temp = et_a instanceof PrimitiveType || et_b instanceof PrimitiveType ? Collections.emptySet() : this.getLeastCommonAncestors(et_a, et_b);
            if (temp.isEmpty()) {
                ret.add((Type)this.objectClassType);
                ret.add((Type)this.serializableClassType);
                ret.add((Type)this.cloneableClassType);
            } else {
                for (Type type : temp) {
                    ret.add((Type)Type.createArrayType((Type)type, (int)1));
                }
            }
        } else if (a instanceof ArrayType || b instanceof ArrayType) {
            ClassType nonArray = (ClassType)(a instanceof ArrayType ? b : a);
            if (!nonArray.getFullyQualifiedName().equals("java.lang.Object")) {
                if (this.isAncestor((Type)this.serializableClassType, (Type)nonArray)) {
                    ret.add((Type)this.serializableClassType);
                }
                if (this.isAncestor((Type)this.cloneableClassType, (Type)nonArray)) {
                    ret.add((Type)this.cloneableClassType);
                }
            }
            if (ret.isEmpty()) {
                ret.add((Type)this.objectClassType);
            }
        } else {
            ret.addAll(this.typeHierarchy.getLowestCommonAncestors((ClassType)a, (ClassType)b));
        }
        return ret;
    }

    private boolean canStoreType(ClassType ancestor, ClassType child) {
        return ancestor == this.objectClassType || this.typeHierarchy.contains(ancestor) && this.typeHierarchy.subtypesOf(ancestor).anyMatch(t -> t == child);
    }
}

