/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors.typeresolving;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import sootup.core.types.ArrayType;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.interceptors.typeresolving.types.AugmentIntegerTypes;
import sootup.interceptors.typeresolving.types.BottomType;
import sootup.interceptors.typeresolving.types.TopType;

public class PrimitiveHierarchy {
    @Nonnull
    public static Collection<Type> getLeastCommonAncestor(@Nonnull Type a, @Nonnull Type b) {
        if (a == b) {
            return Collections.singleton(a);
        }
        if (PrimitiveHierarchy.arePrimitives(a, b)) {
            if (PrimitiveHierarchy.isAncestor(a, b)) {
                return Collections.singleton(a);
            }
            if (PrimitiveHierarchy.isAncestor(b, a)) {
                return Collections.singleton(b);
            }
            if (a.getClass() == PrimitiveType.ByteType.class) {
                if (b.getClass() == AugmentIntegerTypes.Integer32767Type.class) {
                    return Collections.singleton(PrimitiveType.getShort());
                }
                if (b.getClass() == PrimitiveType.CharType.class) {
                    return Collections.singleton(PrimitiveType.getInt());
                }
            }
            if (a.getClass() == PrimitiveType.ShortType.class && b.getClass() == PrimitiveType.CharType.class) {
                return Collections.singleton(PrimitiveType.getInt());
            }
            if (a.getClass() == PrimitiveType.CharType.class && (b.getClass() == PrimitiveType.ByteType.class || b.getClass() == PrimitiveType.ShortType.class)) {
                return Collections.singleton(PrimitiveType.getInt());
            }
            if (a.getClass() == AugmentIntegerTypes.Integer32767Type.class && b.getClass() == PrimitiveType.ByteType.class) {
                return Collections.singleton(PrimitiveType.getShort());
            }
            return Collections.singleton(TopType.getInstance());
        }
        return Collections.emptySet();
    }

    public static boolean isAncestor(@Nonnull Type ancestor, @Nonnull Type child) {
        if (ancestor == child) {
            return true;
        }
        if (PrimitiveHierarchy.arePrimitives(ancestor, child)) {
            if (ancestor.getClass() == AugmentIntegerTypes.Integer1Type.class) {
                return child.getClass() == BottomType.class;
            }
            if (ancestor.getClass() == PrimitiveType.BooleanType.class || ancestor.getClass() == AugmentIntegerTypes.Integer127Type.class) {
                return child.getClass() == AugmentIntegerTypes.Integer1Type.class || child.getClass() == BottomType.class;
            }
            if (ancestor.getClass() == PrimitiveType.ByteType.class || ancestor.getClass() == AugmentIntegerTypes.Integer32767Type.class) {
                return child.getClass() == AugmentIntegerTypes.Integer127Type.class || child.getClass() == AugmentIntegerTypes.Integer1Type.class || child.getClass() == BottomType.class;
            }
            if (ancestor.getClass() == PrimitiveType.ShortType.class) {
                return child.getClass() == PrimitiveType.ByteType.class || child.getClass() == AugmentIntegerTypes.Integer32767Type.class || child.getClass() == AugmentIntegerTypes.Integer127Type.class || child.getClass() == AugmentIntegerTypes.Integer1Type.class || child.getClass() == BottomType.class;
            }
            if (ancestor.getClass() == PrimitiveType.CharType.class) {
                return child.getClass() == AugmentIntegerTypes.Integer32767Type.class || child.getClass() == AugmentIntegerTypes.Integer127Type.class || child.getClass() == AugmentIntegerTypes.Integer1Type.class || child.getClass() == BottomType.class;
            }
            if (ancestor instanceof PrimitiveType.IntType) {
                return child.getClass() != PrimitiveType.BooleanType.class && child instanceof PrimitiveType.IntType || child.getClass() == BottomType.class;
            }
            return child.getClass() == BottomType.class;
        }
        if (ancestor instanceof ArrayType && child instanceof ArrayType) {
            int childDim;
            Type ancestorBase = ((ArrayType)ancestor).getBaseType();
            Type childBase = ((ArrayType)child).getBaseType();
            int ancestorDim = ((ArrayType)ancestor).getDimension();
            if (ancestorDim == (childDim = ((ArrayType)child).getDimension()) && PrimitiveHierarchy.arePrimitives(ancestorBase, childBase)) {
                if (ancestorBase.getClass() == AugmentIntegerTypes.Integer1Type.class) {
                    return childBase.getClass() == BottomType.class;
                }
                if (ancestorBase.getClass() == PrimitiveType.BooleanType.class || ancestorBase.getClass() == AugmentIntegerTypes.Integer127Type.class) {
                    return childBase.getClass() == AugmentIntegerTypes.Integer1Type.class || childBase.getClass() == BottomType.class;
                }
                if (ancestorBase.getClass() == PrimitiveType.ByteType.class || ancestorBase.getClass() == AugmentIntegerTypes.Integer32767Type.class) {
                    return childBase.getClass() == AugmentIntegerTypes.Integer127Type.class || childBase.getClass() == AugmentIntegerTypes.Integer1Type.class || childBase.getClass() == BottomType.class;
                }
                if (ancestorBase.getClass() == PrimitiveType.CharType.class || ancestorBase.getClass() == PrimitiveType.ShortType.class || ancestorBase instanceof PrimitiveType.IntType) {
                    return childBase.getClass() == AugmentIntegerTypes.Integer32767Type.class || childBase.getClass() == AugmentIntegerTypes.Integer127Type.class || childBase.getClass() == AugmentIntegerTypes.Integer1Type.class || childBase.getClass() == BottomType.class;
                }
            }
            return childBase.getClass() == BottomType.class;
        }
        return child.getClass() == BottomType.class;
    }

    public static boolean arePrimitives(@Nonnull Type a, @Nonnull Type b) {
        return !(!(a instanceof PrimitiveType) && a.getClass() != BottomType.class || !(b instanceof PrimitiveType) && b.getClass() != BottomType.class);
    }
}

