/*
 * Decompiled with CFR 0.152.
 */
package sootup.interceptors.typeresolving;

import java.util.Collection;
import javax.annotation.Nonnull;
import sootup.core.graph.StmtGraph;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.Visitor;
import sootup.core.model.Body;
import sootup.core.types.PrimitiveType;
import sootup.core.types.Type;
import sootup.interceptors.typeresolving.AugEvalFunction;
import sootup.interceptors.typeresolving.BytecodeHierarchy;
import sootup.interceptors.typeresolving.TypeChecker;
import sootup.interceptors.typeresolving.Typing;
import sootup.interceptors.typeresolving.types.AugmentIntegerTypes;
import sootup.interceptors.typeresolving.types.TopType;

public class TypePromotionVisitor
extends TypeChecker {
    public TypePromotionVisitor(@Nonnull Body.BodyBuilder builder, @Nonnull AugEvalFunction evalFunction, @Nonnull BytecodeHierarchy hierarchy) {
        super(builder, evalFunction, hierarchy);
    }

    public Typing getPromotedTyping(Typing typing) {
        this.setTyping(typing);
        for (Stmt stmt : this.builder.getStmts()) {
            stmt.accept((Visitor)this);
        }
        return this.getTyping();
    }

    public static boolean isIntermediateType(Type type) {
        return type.equals((Object)AugmentIntegerTypes.getInteger1()) || type.equals((Object)AugmentIntegerTypes.getInteger127()) || type.equals((Object)AugmentIntegerTypes.getInteger32767());
    }

    @Override
    public void visit(@Nonnull Value value, @Nonnull Type stdType, @Nonnull Stmt stmt) {
        if (!(value instanceof Local)) {
            return;
        }
        AugEvalFunction evalFunction = this.getFuntion();
        BytecodeHierarchy hierarchy = this.getHierarchy();
        Typing typing = this.getTyping();
        Type evaType = evalFunction.evaluate(typing, value, stmt, (StmtGraph<?>)this.graph);
        if (evaType == null || evaType.equals(stdType)) {
            return;
        }
        if (!hierarchy.isAncestor(stdType, evaType)) {
            if (!hierarchy.isAncestor(evaType, stdType)) {
                assert (value instanceof Local);
                Collection<Type> lca = hierarchy.getLeastCommonAncestors(evaType, stdType);
                assert (!lca.isEmpty());
                typing.set((Local)value, lca.iterator().next());
            }
        } else if (value instanceof Local && TypePromotionVisitor.isIntermediateType(evaType)) {
            Local local = (Local)value;
            Type promotedType = this.promote(evaType, stdType);
            if (promotedType != null && !promotedType.equals(evaType)) {
                typing.set(local, promotedType);
            }
        }
    }

    private Type promote(Type low, Type high) {
        Class<?> lowClass = low.getClass();
        Class<?> highClass = high.getClass();
        if (highClass == TopType.class || lowClass == highClass) {
            return low;
        }
        if (lowClass == AugmentIntegerTypes.Integer1Type.class) {
            if (highClass == PrimitiveType.IntType.class) {
                return AugmentIntegerTypes.getInteger127();
            }
            if (highClass == PrimitiveType.ShortType.class) {
                return PrimitiveType.getByte();
            }
            if (highClass == PrimitiveType.BooleanType.class || highClass == PrimitiveType.ByteType.class || highClass == PrimitiveType.CharType.class || highClass == AugmentIntegerTypes.Integer127Type.class || highClass == AugmentIntegerTypes.Integer32767Type.class) {
                return high;
            }
            throw new IllegalArgumentException(low + " cannot be promoted with the supertype " + high + "!");
        }
        if (lowClass == AugmentIntegerTypes.Integer127Type.class) {
            if (highClass == PrimitiveType.ShortType.class) {
                return PrimitiveType.getByte();
            }
            if (highClass == PrimitiveType.IntType.class) {
                return AugmentIntegerTypes.getInteger127();
            }
            if (highClass == PrimitiveType.ByteType.class || highClass == PrimitiveType.CharType.class || highClass == AugmentIntegerTypes.Integer32767Type.class) {
                return high;
            }
            throw new IllegalArgumentException(low + " cannot be promoted with the supertype " + high + "!");
        }
        if (lowClass == AugmentIntegerTypes.Integer32767Type.class) {
            if (highClass == PrimitiveType.IntType.class) {
                return AugmentIntegerTypes.getInteger32767();
            }
            if (highClass == PrimitiveType.ShortType.class || highClass == PrimitiveType.CharType.class) {
                return high;
            }
            throw new IllegalArgumentException(low + " cannot be promoted with the supertype " + high + "!");
        }
        return low;
    }
}

