/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.conversion;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import sootup.core.jimple.Jimple;
import sootup.core.jimple.basic.Immediate;
import sootup.core.jimple.basic.LValue;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.StmtPositionInfo;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.expr.AbstractInvokeExpr;
import sootup.core.jimple.common.ref.IdentityRef;
import sootup.core.jimple.common.ref.JCaughtExceptionRef;
import sootup.core.jimple.common.stmt.JAssignStmt;
import sootup.core.jimple.common.stmt.JIdentityStmt;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.ReplaceUseStmtVisitor;
import sootup.core.jimple.visitor.Visitor;
import sootup.java.bytecode.frontend.conversion.AsmMethodSource;

class Operand {
    static final Operand DWORD_DUMMY = new Operand(null, null, null);
    @Nonnull
    protected AbstractInsnNode insn;
    @Nonnull
    protected final Value value;
    @Nullable
    protected Local stackLocal;
    @Nonnull
    private final AsmMethodSource methodSource;
    @Nonnull
    private final StmtPositionInfo positionInfo;
    private final Set<TryCatchBlockNode> activeTrapHandlers;

    Operand(@Nonnull AbstractInsnNode insn, @Nonnull Value value, @Nonnull AsmMethodSource methodSource) {
        this.insn = insn;
        this.value = value;
        this.methodSource = methodSource;
        this.positionInfo = methodSource == null ? null : methodSource.getStmtPositionInfo();
        this.activeTrapHandlers = methodSource == null ? new HashSet<TryCatchBlockNode>() : new HashSet<TryCatchBlockNode>(methodSource.activeTrapHandlers);
    }

    Local getOrAssignValueToStackLocal() {
        if (this.stackLocal == null) {
            this.changeStackLocal(this.methodSource.newStackLocal());
        }
        return this.stackLocal;
    }

    void emitStatement() {
        if (this == DWORD_DUMMY) {
            return;
        }
        if (this.methodSource.getStmt(this.insn) != null) {
            return;
        }
        if (this.value instanceof AbstractInvokeExpr) {
            this.methodSource.setStmt(this.insn, (Stmt)Jimple.newInvokeStmt((AbstractInvokeExpr)((AbstractInvokeExpr)this.value), (StmtPositionInfo)this.positionInfo));
        } else {
            this.getOrAssignValueToStackLocal();
        }
    }

    void changeStackLocal(Local newStackLocal) {
        Local oldStackLocal = this.stackLocal;
        if (oldStackLocal == newStackLocal) {
            return;
        }
        Object stmt = this.methodSource.getStmt(this.insn);
        if (!(stmt instanceof JAssignStmt)) {
            if (this.value instanceof JCaughtExceptionRef) {
                JIdentityStmt identityStmt = Jimple.newIdentityStmt((Local)newStackLocal, (IdentityRef)((JCaughtExceptionRef)this.value), (StmtPositionInfo)this.positionInfo);
                this.methodSource.setStmt(this.insn, (Stmt)identityStmt);
            } else {
                this.methodSource.setStmt(this.insn, (Stmt)Jimple.newAssignStmt((LValue)newStackLocal, (Value)this.value, (StmtPositionInfo)this.positionInfo));
            }
        } else {
            JAssignStmt assignStmt = (JAssignStmt)stmt;
            assert (assignStmt.getLeftOp() == oldStackLocal || assignStmt.getLeftOp() == newStackLocal);
            this.methodSource.replaceStmt((Stmt)assignStmt, (Stmt)assignStmt.withVariable((LValue)newStackLocal));
        }
        if (oldStackLocal != null) {
            ReplaceUseStmtVisitor replaceStmtVisitor = new ReplaceUseStmtVisitor((Value)oldStackLocal, (Value)newStackLocal);
            for (Stmt oldUsage : this.methodSource.getStmtsThatUse((Value)oldStackLocal).collect(Collectors.toList())) {
                oldUsage.accept((Visitor)replaceStmtVisitor);
                Stmt newUsage = replaceStmtVisitor.getResult();
                if (newUsage == null || oldUsage == newUsage) continue;
                this.methodSource.replaceStmt(oldUsage, newUsage);
            }
        }
        this.stackLocal = newStackLocal;
    }

    Local toLocal() {
        if (this.stackLocal == null && this.value instanceof Local) {
            return (Local)this.value;
        }
        return this.getOrAssignValueToStackLocal();
    }

    Immediate toImmediate() {
        boolean matchingTrapHandlers = this.activeTrapHandlers.equals(this.methodSource.activeTrapHandlers);
        if (this.stackLocal == null && this.value instanceof Immediate && matchingTrapHandlers) {
            return (Immediate)this.value;
        }
        return this.getOrAssignValueToStackLocal();
    }

    boolean equivTo(@Nonnull Operand other) {
        Value stackOrValueOther;
        Value stackOrValue = this.stackLocal == null ? this.value : this.stackLocal;
        Object object = stackOrValueOther = other.stackLocal == null ? other.value : other.stackLocal;
        return this == other || this == DWORD_DUMMY == (other == DWORD_DUMMY) && stackOrValue.equivTo((Object)stackOrValueOther);
    }

    public String toString() {
        return "Operand{insn=" + this.insn + ", value=" + this.value + ", stack=" + this.stackLocal + '}';
    }

    @Nonnull
    public AbstractInsnNode getInsn() {
        return this.insn;
    }

    public boolean equals(Object other) {
        return other instanceof Operand && this.equivTo((Operand)other);
    }
}

