/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.conversion;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import sootup.core.jimple.basic.Local;
import sootup.core.jimple.basic.Value;
import sootup.core.jimple.common.stmt.Stmt;
import sootup.core.jimple.visitor.ReplaceUseStmtVisitor;
import sootup.core.jimple.visitor.Visitor;
import sootup.java.bytecode.frontend.conversion.AsmMethodSource;
import sootup.java.bytecode.frontend.conversion.Operand;

final class OperandMerging {
    @Nonnull
    private final AbstractInsnNode insn;
    @Nullable
    private Operand output;
    @Nonnull
    final ArrayList<Operand[]> inputOperands = new ArrayList(1);
    @Nonnull
    private final AsmMethodSource src;

    OperandMerging(@Nonnull AbstractInsnNode insn, @Nonnull AsmMethodSource src) {
        this.insn = insn;
        this.src = src;
    }

    void mergeOutput(@Nonnull Operand outputOperand) {
        if (this.output == null) {
            this.output = outputOperand;
        } else if (this.output.stackLocal != null) {
            if (outputOperand.stackLocal == null) {
                outputOperand.changeStackLocal(this.output.stackLocal);
            } else if (this.output.stackLocal != outputOperand.stackLocal) {
                throw new IllegalStateException("Incompatible stacklocal mismatch. There exist multiple, different possible output Locals (" + outputOperand.stackLocal + ", " + this.output.stackLocal + ").");
            }
            outputOperand.changeStackLocal(this.output.stackLocal);
        }
    }

    void mergeInputs(Operand ... oprs) {
        if (this.inputOperands.isEmpty()) {
            this.inputOperands.add(oprs);
            return;
        }
        if (this.inputOperands.get(0).length != oprs.length) {
            throw new IllegalArgumentException("Invalid in operands length!");
        }
        if (oprs.length == 0) {
            return;
        }
        for (int i = 0; i < oprs.length; ++i) {
            int j;
            Operand newOp = oprs[i];
            Local stack = null;
            for (j = 0; j != this.inputOperands.size() && (stack = this.inputOperands.get((int)j)[i].stackLocal) == null; ++j) {
            }
            if (stack == null && newOp.stackLocal != null) {
                stack = newOp.stackLocal;
            }
            if (stack == null && this.inputOperands.get((int)0)[i].value.equivTo((Object)newOp.value)) continue;
            if (stack == null) {
                stack = this.src.newStackLocal();
            }
            for (j = 0; j != this.inputOperands.size(); ++j) {
                Operand prevOp = this.inputOperands.get(j)[i];
                prevOp.changeStackLocal(stack);
            }
            newOp.changeStackLocal(stack);
            ReplaceUseStmtVisitor replaceUseStmtVisitor = new ReplaceUseStmtVisitor(this.inputOperands.get((int)0)[i].value, (Value)stack);
            Object oldStatement = this.src.getStmt(this.insn);
            if (oldStatement == null) continue;
            oldStatement.accept((Visitor)replaceUseStmtVisitor);
            this.src.replaceStmt((Stmt)oldStatement, replaceUseStmtVisitor.getResult());
        }
        this.inputOperands.add(oprs);
    }
}

