/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.inputlocation;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.interceptors.BytecodeBodyInterceptors;
import sootup.java.bytecode.frontend.conversion.AsmJavaClassProvider;
import sootup.java.bytecode.frontend.inputlocation.PathBasedAnalysisInputLocation;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.types.JavaClassType;

public class ArchiveBasedAnalysisInputLocation
extends PathBasedAnalysisInputLocation {
    protected static final LoadingCache<Path, FileSystem> fileSystemCache = CacheBuilder.newBuilder().weakValues().removalListener(removalNotification -> {
        try {
            FileSystem value = (FileSystem)removalNotification.getValue();
            if (value != null) {
                value.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close file system of " + removalNotification.getKey(), e);
        }
    }).build(CacheLoader.from(path -> {
        try {
            return FileSystems.newFileSystem(Objects.requireNonNull(path), (ClassLoader)null);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open file system of " + path, e);
        }
    }));

    public ArchiveBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType) {
        this(path, srcType, BytecodeBodyInterceptors.Default.getBodyInterceptors());
    }

    public ArchiveBasedAnalysisInputLocation(@Nonnull Path path, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        this(path, srcType, bodyInterceptors, Collections.emptyList());
    }

    public ArchiveBasedAnalysisInputLocation(Path path, SourceType srcType, List<BodyInterceptor> bodyInterceptors, Collection<Path> ignoredPaths) {
        super(path, srcType, bodyInterceptors, ignoredPaths);
    }

    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        try {
            FileSystem fs = (FileSystem)fileSystemCache.get((Object)this.path);
            Path archiveRoot = fs.getPath("/", new String[0]);
            return this.getClassSourceInternal((JavaClassType)type, archiveRoot, new AsmJavaClassProvider(view));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to retrieve file system from cache for " + this.path, e);
        }
    }

    @Nonnull
    public Stream<JavaSootClassSource> getClassSources(@Nonnull View view) {
        try {
            FileSystem fs = (FileSystem)fileSystemCache.get((Object)this.path);
            Path archiveRoot = fs.getPath("/", new String[0]);
            return this.walkDirectory(archiveRoot, view.getIdentifierFactory(), new AsmJavaClassProvider(view));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to retrieve file system from cache for " + this.path, e);
        }
    }
}

