/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.inputlocation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import sootup.core.IdentifierFactory;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.interceptors.BytecodeBodyInterceptors;
import sootup.java.bytecode.frontend.conversion.AsmJavaClassProvider;
import sootup.java.bytecode.frontend.inputlocation.PathBasedAnalysisInputLocation;
import sootup.java.core.JavaSootClassSource;
import sootup.java.core.types.JavaClassType;

public class ClassFileBasedAnalysisInputLocation
extends PathBasedAnalysisInputLocation {
    @Nonnull
    private final String omittedPackageName;

    public ClassFileBasedAnalysisInputLocation(@Nonnull Path classFilePath, @Nonnull String omittedPackageName, @Nonnull SourceType srcType) {
        this(classFilePath, omittedPackageName, srcType, BytecodeBodyInterceptors.Default.getBodyInterceptors());
    }

    public ClassFileBasedAnalysisInputLocation(@Nonnull Path classFilePath, @Nonnull String omittedPackageName, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        super(classFilePath, srcType, bodyInterceptors);
        this.omittedPackageName = omittedPackageName;
        if (!Files.isRegularFile(classFilePath, new LinkOption[0])) {
            throw new IllegalArgumentException("Needs to point to a regular file!");
        }
        if (Files.isDirectory(classFilePath, new LinkOption[0])) {
            throw new IllegalArgumentException("Needs to point to a regular file - not to a directory.");
        }
    }

    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        if (!type.getPackageName().getName().startsWith(this.omittedPackageName)) {
            return Optional.empty();
        }
        return this.getSingleClass((JavaClassType)type, this.path, new AsmJavaClassProvider(view));
    }

    @Nonnull
    public Stream<JavaSootClassSource> getClassSources(@Nonnull View view) {
        AsmJavaClassProvider classProvider = new AsmJavaClassProvider(view);
        IdentifierFactory factory = view.getIdentifierFactory();
        Path dirPath = this.path.getParent();
        String fullyQualifiedName = this.fromPath(dirPath, this.path);
        Optional<JavaSootClassSource> javaSootClassSource = classProvider.createClassSource(this, this.path, factory.getClassType(fullyQualifiedName)).map(src -> (JavaSootClassSource)src);
        return Stream.of(javaSootClassSource.get());
    }

    @Override
    @Nonnull
    protected String fromPath(@Nonnull Path baseDirPath, Path packageNamePathAndClass) {
        String str = FilenameUtils.removeExtension((String)packageNamePathAndClass.subpath(baseDirPath.getNameCount(), packageNamePathAndClass.getNameCount()).toString().replace(packageNamePathAndClass.getFileSystem().getSeparator(), "."));
        return this.omittedPackageName.isEmpty() ? str : this.omittedPackageName + "." + str;
    }
}

