/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.inputlocation;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import sootup.core.frontend.SootClassSource;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.views.View;
import sootup.interceptors.BytecodeBodyInterceptors;
import sootup.java.bytecode.frontend.inputlocation.DefaultRTJarAnalysisInputLocation;
import sootup.java.bytecode.frontend.inputlocation.JrtFileSystemAnalysisInputLocation;

public class DefaultRuntimeAnalysisInputLocation
implements AnalysisInputLocation {
    @Nonnull
    private final AnalysisInputLocation backingInputLocation;

    public DefaultRuntimeAnalysisInputLocation() {
        this(SourceType.Library);
    }

    public DefaultRuntimeAnalysisInputLocation(@Nonnull SourceType srcType) {
        this(srcType, BytecodeBodyInterceptors.Default.getBodyInterceptors());
    }

    public DefaultRuntimeAnalysisInputLocation(@Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors) {
        String version = System.getProperty("java.version");
        this.backingInputLocation = version.startsWith("1.") ? new DefaultRTJarAnalysisInputLocation(srcType, bodyInterceptors) : new JrtFileSystemAnalysisInputLocation(srcType, bodyInterceptors);
    }

    @Nonnull
    public Optional<? extends SootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        return this.backingInputLocation.getClassSource(type, view);
    }

    @Nonnull
    public Stream<? extends SootClassSource> getClassSources(@Nonnull View view) {
        return this.backingInputLocation.getClassSources(view);
    }

    @Nonnull
    public SourceType getSourceType() {
        return this.backingInputLocation.getSourceType();
    }

    @Nonnull
    public List<BodyInterceptor> getBodyInterceptors() {
        return this.backingInputLocation.getBodyInterceptors();
    }
}

