/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.inputlocation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.java.bytecode.frontend.FileUtil;
import sootup.java.bytecode.frontend.inputlocation.ArchiveBasedAnalysisInputLocation;

public class DownloadJarAnalysisInputLocation
extends ArchiveBasedAnalysisInputLocation {
    public DownloadJarAnalysisInputLocation(String downloadURL, List<BodyInterceptor> bodyInterceptors, Collection<Path> ignoredPaths) {
        super(DownloadJarAnalysisInputLocation.downloadAndConstructPath(downloadURL), SourceType.Library, bodyInterceptors, ignoredPaths);
    }

    private static Path downloadAndConstructPath(String downloadURL) {
        HttpURLConnection connection = null;
        String filename = downloadURL.substring(downloadURL.lastIndexOf("/") + 1);
        File file = new File(FileUtil.getTempDirectory().toString(), filename);
        try {
            URL url = new URL(downloadURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("HTTP request failed with response code " + responseCode);
            }
            try (InputStream inputStream = connection.getInputStream();){
                Path outputPath = Paths.get(file.getAbsolutePath(), new String[0]);
                Files.copy(inputStream, outputPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return file.toPath();
    }
}

