/*
 * Decompiled with CFR 0.152.
 */
package sootup.java.bytecode.frontend.inputlocation;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sootup.core.inputlocation.AnalysisInputLocation;
import sootup.core.inputlocation.FileType;
import sootup.core.model.SourceType;
import sootup.core.transform.BodyInterceptor;
import sootup.core.types.ClassType;
import sootup.core.util.PathUtils;
import sootup.core.views.View;
import sootup.interceptors.BytecodeBodyInterceptors;
import sootup.java.bytecode.frontend.inputlocation.ArchiveBasedAnalysisInputLocation;
import sootup.java.bytecode.frontend.inputlocation.DirectoryBasedAnalysisInputLocation;
import sootup.java.core.JavaSootClassSource;

final class WarArchiveAnalysisInputLocation
extends DirectoryBasedAnalysisInputLocation {
    public List<AnalysisInputLocation> containedInputLocations = new ArrayList<AnalysisInputLocation>();
    public static int maxAllowedBytesToExtract = 524288000;

    private WarArchiveAnalysisInputLocation(@Nonnull Path warPath, @Nonnull SourceType srcType) throws IOException {
        this(warPath, srcType, BytecodeBodyInterceptors.Default.getBodyInterceptors(), Collections.emptyList());
    }

    WarArchiveAnalysisInputLocation(@Nonnull Path warPath, @Nonnull SourceType srcType, @Nonnull List<BodyInterceptor> bodyInterceptors, @Nonnull Collection<Path> ignoredPaths) throws IOException {
        super(Files.createTempDirectory("sootUp-war-" + warPath.hashCode(), new FileAttribute[0]).toAbsolutePath(), srcType, bodyInterceptors, ignoredPaths);
        Path libDir;
        this.extractWarFile(warPath, this.path);
        Path webInfPath = this.path.resolve("WEB-INF");
        Path classDir = webInfPath.resolve("classes");
        if (Files.exists(classDir, new LinkOption[0])) {
            this.containedInputLocations.add(new DirectoryBasedAnalysisInputLocation(classDir, srcType, bodyInterceptors));
        }
        if (Files.exists(libDir = webInfPath.resolve("lib"), new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(libDir, new FileVisitOption[0]);){
                paths.filter(f -> PathUtils.hasExtension((Path)f, (FileType[])new FileType[]{FileType.JAR})).forEach(f -> this.containedInputLocations.add(new ArchiveBasedAnalysisInputLocation((Path)f, srcType, bodyInterceptors)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public WarArchiveAnalysisInputLocation(Path path, SourceType srcType, List<BodyInterceptor> bodyInterceptors) throws IOException {
        this(path, srcType, bodyInterceptors, Collections.emptyList());
    }

    @Override
    @Nonnull
    public Stream<JavaSootClassSource> getClassSources(@Nonnull View view) {
        return this.containedInputLocations.stream().flatMap(location -> location.getClassSources(view)).map(src -> (JavaSootClassSource)src);
    }

    @Override
    @Nonnull
    public Optional<JavaSootClassSource> getClassSource(@Nonnull ClassType type, @Nonnull View view) {
        for (AnalysisInputLocation inputLocation : this.containedInputLocations) {
            Optional classSource = inputLocation.getClassSource(type, view);
            if (!classSource.isPresent()) continue;
            return classSource.map(src -> (JavaSootClassSource)src);
        }
        return Optional.empty();
    }

    void extractWarFile(Path warFilePath, Path destDirectory) {
        int extractedSize = 0;
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(warFilePath, new OpenOption[0]));){
            ZipEntry zipEntry;
            File dest = destDirectory.toFile();
            if (!dest.exists()) {
                if (!dest.mkdir()) {
                    throw new RuntimeException("Could not create the directory to extract Warfile: " + destDirectory);
                }
                dest.deleteOnExit();
            }
            while ((zipEntry = zis.getNextEntry()) != null) {
                block43: {
                    String canonicalDestDirStr;
                    Path filepath = destDirectory.resolve(zipEntry.getName());
                    File file = filepath.toFile();
                    String canonicalFilepathStr = file.getCanonicalPath();
                    if (!canonicalFilepathStr.startsWith((canonicalDestDirStr = dest.getCanonicalPath()) + File.separator)) {
                        throw new IllegalArgumentException("ZipSlip Attack Mitigated: ZipEntry points outside of the target dir: " + file.getName());
                    }
                    file.deleteOnExit();
                    if (zipEntry.isDirectory()) {
                        boolean mkdir = file.mkdir();
                        if (!mkdir) {
                            throw new IllegalStateException("Could not create Directory: " + file.getAbsolutePath());
                        }
                    } else {
                        int readBytesZip;
                        byte[] incomingValues = new byte[4096];
                        if (file.exists()) {
                            try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);
                                 BufferedInputStream bis = new BufferedInputStream(fis);){
                                byte[] bisBuf = new byte[4096];
                                while ((readBytesZip = zis.read(incomingValues)) != -1) {
                                    if (extractedSize > maxAllowedBytesToExtract) {
                                        throw new RuntimeException("The extracted warfile exceeds the size of " + maxAllowedBytesToExtract + " byte. Either the file is a big archive (-> increase PathBasedAnalysisInputLocation.WarArchiveInputLocation.maxAllowedBytesToExtract) or maybe it contains an archive bomb.");
                                    }
                                    int readBytesExistingFile = bis.read(bisBuf, 0, readBytesZip);
                                    if (readBytesExistingFile != readBytesZip) {
                                        throw new RuntimeException("Can't extract File \"" + file + "\" as it already exists and has a different size.");
                                    }
                                    if (!Arrays.equals(bisBuf, incomingValues)) {
                                        throw new RuntimeException("Can't extract File \"" + file + "\" as it already exists and has a different content which we can't override.");
                                    }
                                    extractedSize += readBytesZip;
                                }
                                break block43;
                            }
                        }
                        try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                             BufferedOutputStream bos = new BufferedOutputStream(fos);){
                            while ((readBytesZip = zis.read(incomingValues)) != -1) {
                                if (extractedSize > maxAllowedBytesToExtract) {
                                    throw new RuntimeException("The extracted warfile exceeds the size of " + maxAllowedBytesToExtract + " byte. Either the file is a big archive or maybe it contains an archive bomb.");
                                }
                                bos.write(incomingValues, 0, readBytesZip);
                                extractedSize += readBytesZip;
                            }
                        }
                    }
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public List<String> retrieveServletClasses(String extractedWARPath) {
        ArrayList<String> classesInXML = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(extractedWARPath + "/WEB-INF/web.xml"));
            document.getDocumentElement().normalize();
            NodeList nList = document.getElementsByTagName("servlet");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node node = nList.item(temp);
                if (node.getNodeType() != 1) continue;
                Element eElement = (Element)node;
                classesInXML.add(eElement.getElementsByTagName("servlet-class").item(0).getTextContent());
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        return classesInXML;
    }
}

