/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.converter;

import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.Proto;
import com.googlecode.d2j.asm.LdcOptimizeAdapter;
import com.googlecode.d2j.dex.Dex2Asm;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.expr.ArrayExpr;
import com.googlecode.dex2jar.ir.expr.CastExpr;
import com.googlecode.dex2jar.ir.expr.Constant;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.FieldExpr;
import com.googlecode.dex2jar.ir.expr.FilledArrayExpr;
import com.googlecode.dex2jar.ir.expr.InvokeCustomExpr;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.InvokePolymorphicExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.expr.NewMutiArrayExpr;
import com.googlecode.dex2jar.ir.expr.StaticFieldExpr;
import com.googlecode.dex2jar.ir.expr.TypeExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.GotoStmt;
import com.googlecode.dex2jar.ir.stmt.IfStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.TableSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.UnopStmt;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class IR2JConverter
implements Opcodes {
    public static final int MAX_FILL_ARRAY_BYTES = 500;
    private boolean optimizeSynchronized = false;
    Dex2Asm.ClzCtx clzCtx;
    IrMethod ir;
    MethodVisitor asm;

    public IR2JConverter optimizeSynchronized(boolean optimizeSynchronized) {
        this.optimizeSynchronized = optimizeSynchronized;
        return this;
    }

    public IR2JConverter clzCtx(Dex2Asm.ClzCtx clzCtx) {
        this.clzCtx = clzCtx;
        return this;
    }

    public IR2JConverter ir(IrMethod ir) {
        this.ir = ir;
        return this;
    }

    public IR2JConverter asm(MethodVisitor asm) {
        this.asm = asm;
        return this;
    }

    public void convert() {
        this.mapLabelStmt(this.ir);
        this.reBuildInstructions(this.ir, this.asm);
        this.reBuildTryCatchBlocks(this.ir, this.asm);
    }

    private void mapLabelStmt(IrMethod ir) {
        for (Stmt p : ir.stmts) {
            if (p.st != Stmt.ST.LABEL) continue;
            LabelStmt labelStmt = (LabelStmt)p;
            labelStmt.tag = new Label();
        }
    }

    private void reBuildTryCatchBlocks(IrMethod ir, MethodVisitor asm) {
        for (Trap trap : ir.traps) {
            boolean needAdd = false;
            for (Stmt p = trap.start.getNext(); p != null && p != trap.end; p = p.getNext()) {
                if (p.st == Stmt.ST.LABEL) continue;
                needAdd = true;
                break;
            }
            if (!needAdd) continue;
            for (int i = 0; i < trap.handlers.length; ++i) {
                String type = trap.types[i];
                asm.visitTryCatchBlock((Label)trap.start.tag, (Label)trap.end.tag, (Label)trap.handlers[i].tag, type == null ? null : IR2JConverter.toInternal(type));
            }
        }
    }

    static String toInternal(String n) {
        return Type.getType(n).getInternalName();
    }

    private void reBuildInstructions(IrMethod ir, MethodVisitor asm) {
        asm = new LdcOptimizeAdapter(asm);
        int maxLocalIndex = 0;
        for (Local local : ir.locals) {
            maxLocalIndex = Math.max(maxLocalIndex, local._ls_index);
        }
        HashMap<String, Integer> lockMap = new HashMap<String, Integer>();
        block40: for (Stmt st : ir.stmts) {
            block2 : switch (st.st) {
                case LABEL: {
                    LabelStmt labelStmt = (LabelStmt)st;
                    Label label = (Label)labelStmt.tag;
                    asm.visitLabel(label);
                    if (labelStmt.lineNumber < 0) continue block40;
                    asm.visitLineNumber(labelStmt.lineNumber, label);
                    break;
                }
                case ASSIGN: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                    Value v1 = e2.op1;
                    Value v2 = e2.op2;
                    switch (v1.vt) {
                        case LOCAL: {
                            Local local = (Local)v1;
                            int i = local._ls_index;
                            boolean skipOrg = false;
                            if (v2.vt == Value.VT.LOCAL && i == ((Local)v2)._ls_index) {
                                skipOrg = true;
                            } else if (v1.valueType.charAt(0) == 'I') {
                                int increment;
                                if (v2.vt == Value.VT.ADD) {
                                    int increment2;
                                    if (IR2JConverter.isLocalWithIndex(v2.getOp1(), i) && v2.getOp2().vt == Value.VT.CONSTANT) {
                                        int increment3 = (Integer)((Constant)v2.getOp2()).value;
                                        if (increment3 >= Short.MIN_VALUE && increment3 <= Short.MAX_VALUE) {
                                            asm.visitIincInsn(i, increment3);
                                            skipOrg = true;
                                        }
                                    } else if (IR2JConverter.isLocalWithIndex(v2.getOp2(), i) && v2.getOp1().vt == Value.VT.CONSTANT && (increment2 = ((Integer)((Constant)v2.getOp1()).value).intValue()) >= Short.MIN_VALUE && increment2 <= Short.MAX_VALUE) {
                                        asm.visitIincInsn(i, increment2);
                                        skipOrg = true;
                                    }
                                } else if (v2.vt == Value.VT.SUB && IR2JConverter.isLocalWithIndex(v2.getOp1(), i) && v2.getOp2().vt == Value.VT.CONSTANT && (increment = -((Integer)((Constant)v2.getOp2()).value).intValue()) >= Short.MIN_VALUE && increment <= Short.MAX_VALUE) {
                                    asm.visitIincInsn(i, increment);
                                    skipOrg = true;
                                }
                            }
                            if (skipOrg) break;
                            this.accept(v2, asm);
                            if (i >= 0) {
                                asm.visitVarInsn(IR2JConverter.getOpcode(v1, 54), i);
                                break block2;
                            }
                            if (v1.valueType.equals("V")) break;
                            switch (v1.valueType.charAt(0)) {
                                case 'D': 
                                case 'J': {
                                    asm.visitInsn(88);
                                    break block2;
                                }
                            }
                            asm.visitInsn(87);
                            break block2;
                        }
                        case STATIC_FIELD: {
                            StaticFieldExpr fe = (StaticFieldExpr)v1;
                            this.accept(v2, asm);
                            IR2JConverter.insertI2x(v2.valueType, fe.type, asm);
                            asm.visitFieldInsn(179, IR2JConverter.toInternal(fe.owner), fe.name, fe.type);
                            break block2;
                        }
                        case FIELD: {
                            FieldExpr fe = (FieldExpr)v1;
                            this.accept(fe.op, asm);
                            this.accept(v2, asm);
                            IR2JConverter.insertI2x(v2.valueType, fe.type, asm);
                            asm.visitFieldInsn(181, IR2JConverter.toInternal(fe.owner), fe.name, fe.type);
                            break block2;
                        }
                        case ARRAY: {
                            ArrayExpr ae = (ArrayExpr)v1;
                            this.accept(ae.op1, asm);
                            this.accept(ae.op2, asm);
                            this.accept(v2, asm);
                            String tp1 = ae.op1.valueType;
                            String tp2 = ae.valueType;
                            if (tp1.charAt(0) == '[') {
                                String arrayElementType = tp1.substring(1);
                                IR2JConverter.insertI2x(v2.valueType, arrayElementType, asm);
                                asm.visitInsn(IR2JConverter.getOpcode(arrayElementType, 79));
                                break block2;
                            }
                            asm.visitInsn(IR2JConverter.getOpcode(tp2, 79));
                        }
                    }
                    break;
                }
                case IDENTITY: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                    if (e2.op2.vt != Value.VT.EXCEPTION_REF) continue block40;
                    int index = ((Local)e2.op1)._ls_index;
                    if (index >= 0) {
                        asm.visitVarInsn(58, index);
                        break;
                    }
                    asm.visitInsn(87);
                    break;
                }
                case FILL_ARRAY_DATA: {
                    boolean genBig;
                    String elementType;
                    String arrayValueType;
                    int arraySize;
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)st;
                    if (e2.getOp2().vt == Value.VT.CONSTANT) {
                        Object arrayData = ((Constant)e2.getOp2()).value;
                        arraySize = Array.getLength(arrayData);
                        arrayValueType = e2.getOp1().valueType;
                        elementType = arrayValueType.charAt(0) == '[' ? arrayValueType.substring(1) : "I";
                        genBig = false;
                        try {
                            byte[] data;
                            if (this.clzCtx != null && "BSIJ".contains(elementType) && (data = IR2JConverter.toLittleEndianArray(arrayData)) != null && data.length > 500) {
                                this.accept(e2.getOp1(), asm);
                                asm.visitLdcInsn(0);
                                this.constLargeArray(asm, data, elementType);
                                asm.visitLdcInsn(0);
                                asm.visitLdcInsn(arraySize);
                                asm.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false);
                                genBig = true;
                            }
                        }
                        catch (Exception data) {
                            // empty catch block
                        }
                        if (genBig) continue block40;
                        int iastoreOP = IR2JConverter.getOpcode(elementType, 79);
                        this.accept(e2.getOp1(), asm);
                        for (int i = 0; i < arraySize; ++i) {
                            asm.visitInsn(89);
                            asm.visitLdcInsn(i);
                            asm.visitLdcInsn(Array.get(arrayData, i));
                            asm.visitInsn(iastoreOP);
                        }
                        asm.visitInsn(87);
                        break;
                    }
                    FilledArrayExpr filledArrayExpr = (FilledArrayExpr)e2.getOp2();
                    arraySize = filledArrayExpr.ops.length;
                    arrayValueType = e2.getOp1().valueType;
                    elementType = arrayValueType.charAt(0) == '[' ? arrayValueType.substring(1) : "I";
                    genBig = false;
                    try {
                        byte[] data;
                        if (this.clzCtx != null && "BSIJ".contains(elementType) && IR2JConverter.isConstant(filledArrayExpr.ops) && (data = IR2JConverter.collectDataAsByteArray(filledArrayExpr.ops, elementType)) != null && data.length > 500) {
                            this.accept(e2.getOp1(), asm);
                            asm.visitLdcInsn(0);
                            this.constLargeArray(asm, data, elementType);
                            asm.visitLdcInsn(0);
                            asm.visitLdcInsn(arraySize);
                            asm.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V", false);
                            genBig = true;
                        }
                    }
                    catch (Exception data) {
                        // empty catch block
                    }
                    if (genBig) continue block40;
                    int iastoreOP = IR2JConverter.getOpcode(elementType, 79);
                    this.accept(e2.getOp1(), asm);
                    for (int i = 0; i < arraySize; ++i) {
                        asm.visitInsn(89);
                        asm.visitLdcInsn(i);
                        this.accept(filledArrayExpr.ops[i], asm);
                        asm.visitInsn(iastoreOP);
                    }
                    asm.visitInsn(87);
                    break;
                }
                case GOTO: {
                    asm.visitJumpInsn(167, (Label)((GotoStmt)st).target.tag);
                    break;
                }
                case IF: {
                    this.reBuildJumpInstructions((IfStmt)st, asm);
                    break;
                }
                case LOCK: {
                    String key;
                    Value v = ((UnopStmt)st).op;
                    this.accept(v, asm);
                    if (this.optimizeSynchronized) {
                        switch (v.vt) {
                            case LOCAL: 
                            case CONSTANT: {
                                key = v.vt == Value.VT.LOCAL ? "L" + ((Local)v)._ls_index : "C" + ((Constant)v).value;
                                Integer integer = (Integer)lockMap.get(key);
                                int nIndex = integer != null ? integer : ++maxLocalIndex;
                                asm.visitInsn(89);
                                asm.visitVarInsn(IR2JConverter.getOpcode(v, 54), nIndex);
                                lockMap.put(key, nIndex);
                                break;
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                    }
                    asm.visitInsn(194);
                    break;
                }
                case UNLOCK: {
                    String key;
                    Value v = ((UnopStmt)st).op;
                    if (this.optimizeSynchronized) {
                        switch (v.vt) {
                            case LOCAL: 
                            case CONSTANT: {
                                key = v.vt == Value.VT.LOCAL ? "L" + ((Local)v)._ls_index : "C" + ((Constant)v).value;
                                Integer integer = (Integer)lockMap.get(key);
                                if (integer != null) {
                                    asm.visitVarInsn(IR2JConverter.getOpcode(v, 21), integer);
                                    break;
                                }
                                this.accept(v, asm);
                                break;
                            }
                            default: {
                                this.accept(v, asm);
                                break;
                            }
                        }
                    } else {
                        this.accept(v, asm);
                    }
                    asm.visitInsn(195);
                    break;
                }
                case NOP: {
                    break;
                }
                case RETURN: {
                    Value v = ((UnopStmt)st).op;
                    this.accept(v, asm);
                    IR2JConverter.insertI2x(v.valueType, ir.ret, asm);
                    asm.visitInsn(IR2JConverter.getOpcode(v, 172));
                    break;
                }
                case RETURN_VOID: {
                    asm.visitInsn(177);
                    break;
                }
                case LOOKUP_SWITCH: {
                    LookupSwitchStmt lss = (LookupSwitchStmt)st;
                    this.accept(lss.op, asm);
                    Label[] targets = new Label[lss.targets.length];
                    for (int i = 0; i < targets.length; ++i) {
                        targets[i] = (Label)lss.targets[i].tag;
                    }
                    asm.visitLookupSwitchInsn((Label)lss.defaultTarget.tag, lss.lookupValues, targets);
                    break;
                }
                case TABLE_SWITCH: {
                    TableSwitchStmt tss = (TableSwitchStmt)st;
                    this.accept(tss.op, asm);
                    Label[] targets = new Label[tss.targets.length];
                    for (int i = 0; i < targets.length; ++i) {
                        targets[i] = (Label)tss.targets[i].tag;
                    }
                    asm.visitTableSwitchInsn(tss.lowIndex, tss.lowIndex + targets.length - 1, (Label)tss.defaultTarget.tag, targets);
                    break;
                }
                case THROW: {
                    this.accept(((UnopStmt)st).op, asm);
                    asm.visitInsn(191);
                    break;
                }
                case VOID_INVOKE: {
                    Value op = st.getOp();
                    this.accept(op, asm);
                    String ret = op.valueType;
                    if (op.vt == Value.VT.INVOKE_NEW) {
                        asm.visitInsn(87);
                        break;
                    }
                    if ("V".equals(ret)) continue block40;
                    switch (ret.charAt(0)) {
                        case 'D': 
                        case 'J': {
                            asm.visitInsn(88);
                            break block2;
                        }
                    }
                    asm.visitInsn(87);
                    break;
                }
                default: {
                    throw new RuntimeException("not support st: " + (Object)((Object)st.st));
                }
            }
        }
    }

    private void constLargeArray(MethodVisitor asm, byte[] data, String elementType) {
        String cst = IR2JConverter.hexEncode(data);
        if (cst.length() > 65535) {
            asm.visitTypeInsn(187, "java/lang/StringBuilder");
            asm.visitInsn(89);
            asm.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
            for (int i = 0; i < cst.length(); i += 65500) {
                int a = Math.min(65500, cst.length() - i);
                asm.visitLdcInsn(cst.substring(i, i + a));
                asm.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            }
            asm.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        } else {
            asm.visitLdcInsn(cst);
        }
        asm.visitMethodInsn(184, IR2JConverter.toInternal(this.clzCtx.classDescriptor), this.clzCtx.buildHexDecodeMethodName(elementType), "(Ljava/lang/String;)[" + elementType, false);
    }

    private static boolean isLocalWithIndex(Value v, int i) {
        return v.vt == Value.VT.LOCAL && ((Local)v)._ls_index == i;
    }

    private static void insertI2x(String tos, String expect, MethodVisitor mv) {
        switch (expect.charAt(0)) {
            case 'B': {
                switch (tos.charAt(0)) {
                    case 'C': 
                    case 'I': 
                    case 'S': {
                        mv.visitInsn(145);
                    }
                }
                break;
            }
            case 'S': {
                switch (tos.charAt(0)) {
                    case 'C': 
                    case 'I': {
                        mv.visitInsn(147);
                    }
                }
                break;
            }
            case 'C': {
                switch (tos.charAt(0)) {
                    case 'I': {
                        mv.visitInsn(146);
                    }
                }
            }
        }
    }

    static boolean isZeroOrNull(Value v1) {
        if (v1.vt == Value.VT.CONSTANT) {
            Object v = ((Constant)v1).value;
            return Integer.valueOf(0).equals(v) || Constant.Null.equals(v);
        }
        return false;
    }

    private void reBuildJumpInstructions(IfStmt st, MethodVisitor asm) {
        Label target = (Label)st.target.tag;
        Value v = st.op;
        Value v1 = v.getOp1();
        Value v2 = v.getOp2();
        String type = v1.valueType;
        block0 : switch (type.charAt(0)) {
            case 'L': 
            case '[': {
                if (IR2JConverter.isZeroOrNull(v1) || IR2JConverter.isZeroOrNull(v2)) {
                    if (IR2JConverter.isZeroOrNull(v2)) {
                        this.accept(v1, asm);
                    } else {
                        this.accept(v2, asm);
                    }
                    asm.visitJumpInsn(v.vt == Value.VT.EQ ? 198 : 199, target);
                    break;
                }
                this.accept(v1, asm);
                this.accept(v2, asm);
                asm.visitJumpInsn(v.vt == Value.VT.EQ ? 165 : 166, target);
                break;
            }
            default: {
                if (IR2JConverter.isZeroOrNull(v1) || IR2JConverter.isZeroOrNull(v2)) {
                    if (IR2JConverter.isZeroOrNull(v2)) {
                        this.accept(v1, asm);
                    } else {
                        this.accept(v2, asm);
                    }
                    switch (v.vt) {
                        case NE: {
                            asm.visitJumpInsn(154, target);
                            break;
                        }
                        case EQ: {
                            asm.visitJumpInsn(153, target);
                            break;
                        }
                        case GE: {
                            asm.visitJumpInsn(156, target);
                            break;
                        }
                        case GT: {
                            asm.visitJumpInsn(157, target);
                            break;
                        }
                        case LE: {
                            asm.visitJumpInsn(158, target);
                            break;
                        }
                        case LT: {
                            asm.visitJumpInsn(155, target);
                        }
                    }
                    break;
                }
                this.accept(v1, asm);
                this.accept(v2, asm);
                switch (v.vt) {
                    case NE: {
                        asm.visitJumpInsn(160, target);
                        break block0;
                    }
                    case EQ: {
                        asm.visitJumpInsn(159, target);
                        break block0;
                    }
                    case GE: {
                        asm.visitJumpInsn(162, target);
                        break block0;
                    }
                    case GT: {
                        asm.visitJumpInsn(163, target);
                        break block0;
                    }
                    case LE: {
                        asm.visitJumpInsn(164, target);
                        break block0;
                    }
                    case LT: {
                        asm.visitJumpInsn(161, target);
                    }
                }
            }
        }
    }

    static int getOpcode(Value v, int op) {
        return IR2JConverter.getOpcode(v.valueType, op);
    }

    static int getOpcode(String v, int op) {
        switch (v.charAt(0)) {
            case 'L': 
            case '[': {
                return Type.getType("La;").getOpcode(op);
            }
            case 'Z': {
                return Type.BOOLEAN_TYPE.getOpcode(op);
            }
            case 'B': {
                return Type.BYTE_TYPE.getOpcode(op);
            }
            case 'S': {
                return Type.SHORT_TYPE.getOpcode(op);
            }
            case 'C': {
                return Type.CHAR_TYPE.getOpcode(op);
            }
            case 'I': {
                return Type.INT_TYPE.getOpcode(op);
            }
            case 'F': {
                return Type.FLOAT_TYPE.getOpcode(op);
            }
            case 'J': {
                return Type.LONG_TYPE.getOpcode(op);
            }
            case 'D': {
                return Type.DOUBLE_TYPE.getOpcode(op);
            }
        }
        return Type.INT_TYPE.getOpcode(op);
    }

    private void accept(Value value, MethodVisitor asm) {
        switch (value.et) {
            case E0: {
                switch (value.vt) {
                    case LOCAL: {
                        asm.visitVarInsn(IR2JConverter.getOpcode(value, 21), ((Local)value)._ls_index);
                        break;
                    }
                    case CONSTANT: {
                        Constant cst = (Constant)value;
                        if (cst.value.equals(Constant.Null)) {
                            asm.visitInsn(1);
                            break;
                        }
                        if (cst.value instanceof DexType) {
                            asm.visitLdcInsn(Type.getType(((DexType)cst.value).desc));
                            break;
                        }
                        asm.visitLdcInsn(cst.value);
                        break;
                    }
                    case NEW: {
                        asm.visitTypeInsn(187, IR2JConverter.toInternal(((NewExpr)value).type));
                        break;
                    }
                    case STATIC_FIELD: {
                        StaticFieldExpr sfe = (StaticFieldExpr)value;
                        asm.visitFieldInsn(178, IR2JConverter.toInternal(sfe.owner), sfe.name, sfe.type);
                    }
                }
                break;
            }
            case E1: {
                this.reBuildE1Expression((Value.E1Expr)value, asm);
                break;
            }
            case E2: {
                this.reBuildE2Expression((Value.E2Expr)value, asm);
                break;
            }
            case En: {
                this.reBuildEnExpression((Value.EnExpr)value, asm);
            }
        }
    }

    public static String hexEncode(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    private void reBuildEnExpression(Value.EnExpr value, MethodVisitor asm) {
        if (value.vt == Value.VT.FILLED_ARRAY) {
            FilledArrayExpr fae = (FilledArrayExpr)value;
            String tp1 = fae.valueType;
            int xastore = 79;
            String elementType = null;
            if (tp1.charAt(0) == '[') {
                elementType = tp1.substring(1);
                xastore = IR2JConverter.getOpcode(elementType, 79);
            }
            try {
                byte[] data;
                if (this.clzCtx != null && elementType != null && "BSIJ".contains(elementType) && IR2JConverter.isConstant(fae.ops) && (data = IR2JConverter.collectDataAsByteArray(fae.ops, elementType)) != null && data.length > 500) {
                    this.constLargeArray(asm, data, elementType);
                    return;
                }
            }
            catch (Exception data) {
                // empty catch block
            }
            this.reBuildE1Expression(Exprs.nNewArray(fae.type, Exprs.nInt(fae.ops.length)), asm);
            for (int i = 0; i < fae.ops.length; ++i) {
                if (fae.ops[i] == null) continue;
                asm.visitInsn(89);
                asm.visitLdcInsn(i);
                this.accept(fae.ops[i], asm);
                String tp2 = fae.ops[i].valueType;
                if (elementType != null) {
                    IR2JConverter.insertI2x(tp2, elementType, asm);
                }
                asm.visitInsn(xastore);
            }
            return;
        }
        switch (value.vt) {
            case NEW_MUTI_ARRAY: {
                for (Value vb : value.ops) {
                    this.accept(vb, asm);
                }
                NewMutiArrayExpr nmae = (NewMutiArrayExpr)value;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < nmae.dimension; ++i) {
                    sb.append('[');
                }
                sb.append(nmae.baseType);
                asm.visitMultiANewArrayInsn(sb.toString(), value.ops.length);
                break;
            }
            case INVOKE_NEW: {
                asm.visitTypeInsn(187, IR2JConverter.toInternal(((InvokeExpr)value).getOwner()));
                asm.visitInsn(89);
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_INTERFACE: 
            case INVOKE_SPECIAL: 
            case INVOKE_STATIC: {
                int opcode;
                InvokeExpr ie = (InvokeExpr)value;
                int i = 0;
                if (value.vt != Value.VT.INVOKE_STATIC && value.vt != Value.VT.INVOKE_NEW) {
                    i = 1;
                    this.accept(value.ops[0], asm);
                }
                int j = 0;
                while (i < value.ops.length) {
                    Value vb = value.ops[i];
                    this.accept(vb, asm);
                    IR2JConverter.insertI2x(vb.valueType, ie.getArgs()[j], asm);
                    ++i;
                    ++j;
                }
                switch (value.vt) {
                    case INVOKE_VIRTUAL: {
                        opcode = 182;
                        break;
                    }
                    case INVOKE_INTERFACE: {
                        opcode = 185;
                        break;
                    }
                    case INVOKE_NEW: 
                    case INVOKE_SPECIAL: {
                        opcode = 183;
                        break;
                    }
                    case INVOKE_STATIC: {
                        opcode = 184;
                        break;
                    }
                    default: {
                        opcode = -1;
                    }
                }
                Proto p = ie.getProto();
                if (ie.vt == Value.VT.INVOKE_NEW) {
                    p = new Proto(p.getParameterTypes(), "V");
                }
                asm.visitMethodInsn(opcode, IR2JConverter.toInternal(ie.getOwner()), ie.getName(), p.getDesc());
                break;
            }
            case INVOKE_CUSTOM: {
                InvokeCustomExpr ice = (InvokeCustomExpr)value;
                String[] argTypes = ice.getProto().getParameterTypes();
                Value[] vbs = ice.getOps();
                if (argTypes.length == vbs.length) {
                    for (int i = 0; i < vbs.length; ++i) {
                        Value vb = vbs[i];
                        this.accept(vb, asm);
                        IR2JConverter.insertI2x(vb.valueType, argTypes[i], asm);
                    }
                } else if (argTypes.length + 1 == vbs.length) {
                    this.accept(vbs[0], asm);
                    for (int i = 1; i < vbs.length; ++i) {
                        Value vb = vbs[i];
                        this.accept(vb, asm);
                        IR2JConverter.insertI2x(vb.valueType, argTypes[i - 1], asm);
                    }
                } else {
                    throw new RuntimeException();
                }
                asm.visitInvokeDynamicInsn(ice.name, ice.proto.getDesc(), (Handle)Dex2Asm.convertConstantValue(ice.handle), Dex2Asm.convertConstantValues(ice.bsmArgs));
                break;
            }
            case INVOKE_POLYMORPHIC: {
                InvokePolymorphicExpr ipe = (InvokePolymorphicExpr)value;
                Method m3 = ipe.method;
                String[] argTypes = ipe.getProto().getParameterTypes();
                Value[] vbs = ipe.getOps();
                this.accept(vbs[0], asm);
                for (int i = 1; i < vbs.length; ++i) {
                    Value vb = vbs[i];
                    this.accept(vb, asm);
                    IR2JConverter.insertI2x(vb.valueType, argTypes[i - 1], asm);
                }
                asm.visitMethodInsn(182, IR2JConverter.toInternal(m3.getOwner()), m3.getName(), ipe.getProto().getDesc(), false);
            }
        }
    }

    private static byte[] collectDataAsByteArray(Value[] ops, String t) {
        switch (t) {
            case "B": {
                byte[] d = new byte[ops.length];
                for (Value op : ops) {
                    Constant cst = (Constant)op;
                    d[i] = ((Number)cst.value).byteValue();
                }
                return d;
            }
            case "S": {
                short[] d = new short[ops.length];
                for (Value op : ops) {
                    Constant cst = (Constant)op;
                    d[i] = ((Number)cst.value).shortValue();
                }
                return IR2JConverter.toLittleEndianArray(d);
            }
            case "I": {
                int[] d = new int[ops.length];
                for (Value op : ops) {
                    Constant cst = (Constant)op;
                    d[i] = ((Number)cst.value).intValue();
                }
                return IR2JConverter.toLittleEndianArray(d);
            }
            case "J": {
                long[] d = new long[ops.length];
                for (Value op : ops) {
                    Constant cst = (Constant)op;
                    d[i] = ((Number)cst.value).longValue();
                }
                return IR2JConverter.toLittleEndianArray(d);
            }
        }
        return null;
    }

    private static byte[] toLittleEndianArray(Object d) {
        if (d instanceof byte[]) {
            return (byte[])d;
        }
        if (d instanceof short[]) {
            return IR2JConverter.toLittleEndianArray((short[])d);
        }
        if (d instanceof int[]) {
            return IR2JConverter.toLittleEndianArray((int[])d);
        }
        if (d instanceof long[]) {
            return IR2JConverter.toLittleEndianArray((long[])d);
        }
        return null;
    }

    private static byte[] toLittleEndianArray(long[] d) {
        ByteBuffer b = ByteBuffer.allocate(d.length * 8);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.asLongBuffer().put(d);
        return b.array();
    }

    private static byte[] toLittleEndianArray(int[] d) {
        ByteBuffer b = ByteBuffer.allocate(d.length * 4);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.asIntBuffer().put(d);
        return b.array();
    }

    private static byte[] toLittleEndianArray(short[] d) {
        ByteBuffer b = ByteBuffer.allocate(d.length * 2);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.asShortBuffer().put(d);
        return b.array();
    }

    private static boolean isConstant(Value[] ops) {
        for (Value op : ops) {
            if (op.vt == Value.VT.CONSTANT) continue;
            return false;
        }
        return true;
    }

    private static void box(String provideType, String expectedType, MethodVisitor asm) {
        if (provideType.equals(expectedType)) {
            return;
        }
        if (expectedType.equals("V")) {
            switch (provideType.charAt(0)) {
                case 'D': 
                case 'J': {
                    asm.visitInsn(88);
                    break;
                }
                default: {
                    asm.visitInsn(87);
                }
            }
            return;
        }
        char p = provideType.charAt(0);
        char e = expectedType.charAt(0);
        if (expectedType.equals("Ljava/lang/Object;") && (p == '[' || p == 'L')) {
            return;
        }
        if (provideType.equals("Ljava/lang/Object;") && (e == '[' || e == 'L')) {
            asm.visitTypeInsn(192, IR2JConverter.toInternal(expectedType));
            return;
        }
        switch (provideType + expectedType) {
            case "ZLjava/lang/Object;": 
            case "ZLjava/lang/Boolean;": {
                asm.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                break;
            }
            case "BLjava/lang/Object;": 
            case "BLjava/lang/Byte;": {
                asm.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                break;
            }
            case "SLjava/lang/Object;": 
            case "SLjava/lang/Short;": {
                asm.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                break;
            }
            case "CLjava/lang/Object;": 
            case "CLjava/lang/Character;": {
                asm.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                break;
            }
            case "ILjava/lang/Object;": 
            case "ILjava/lang/Integer;": {
                asm.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
            case "FLjava/lang/Object;": 
            case "FLjava/lang/Float;": {
                asm.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                break;
            }
            case "JLjava/lang/Object;": 
            case "JLjava/lang/Long;": {
                asm.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                break;
            }
            case "DLjava/lang/Object;": 
            case "DLjava/lang/Double;": {
                asm.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                break;
            }
            case "Ljava/lang/Object;Z": {
                asm.visitTypeInsn(192, "java/lang/Boolean");
            }
            case "Ljava/lang/Boolean;Z": {
                asm.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                break;
            }
            case "Ljava/lang/Object;B": {
                asm.visitTypeInsn(192, "java/lang/Byte");
            }
            case "Ljava/lang/Byte;B": {
                asm.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                break;
            }
            case "Ljava/lang/Object;S": {
                asm.visitTypeInsn(192, "java/lang/Short");
            }
            case "Ljava/lang/Short;S": {
                asm.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                break;
            }
            case "Ljava/lang/Object;C": {
                asm.visitTypeInsn(192, "java/lang/Character");
            }
            case "Ljava/lang/Character;C": {
                asm.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                break;
            }
            case "Ljava/lang/Object;I": {
                asm.visitTypeInsn(192, "java/lang/Integer");
            }
            case "Ljava/lang/Integer;I": {
                asm.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                break;
            }
            case "Ljava/lang/Object;F": {
                asm.visitTypeInsn(192, "java/lang/Float");
            }
            case "Ljava/lang/Float;F": {
                asm.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                break;
            }
            case "Ljava/lang/Object;J": {
                asm.visitTypeInsn(192, "java/lang/Long");
            }
            case "Ljava/lang/Long;J": {
                asm.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                break;
            }
            case "Ljava/lang/Object;D": {
                asm.visitTypeInsn(192, "java/lang/Double");
            }
            case "Ljava/lang/Double;D": {
                asm.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                break;
            }
            default: {
                throw new RuntimeException("i have trouble to auto convert from " + provideType + " to " + expectedType + " currently");
            }
        }
    }

    private void reBuildE1Expression(Value.E1Expr e1, MethodVisitor asm) {
        this.accept(e1.getOp(), asm);
        switch (e1.vt) {
            case STATIC_FIELD: {
                FieldExpr fe = (FieldExpr)e1;
                asm.visitFieldInsn(178, IR2JConverter.toInternal(fe.owner), fe.name, fe.type);
                break;
            }
            case FIELD: {
                FieldExpr fe = (FieldExpr)e1;
                asm.visitFieldInsn(180, IR2JConverter.toInternal(fe.owner), fe.name, fe.type);
                break;
            }
            case NEW_ARRAY: {
                TypeExpr te = (TypeExpr)e1;
                switch (te.type.charAt(0)) {
                    case 'L': 
                    case '[': {
                        asm.visitTypeInsn(189, IR2JConverter.toInternal(te.type));
                        break;
                    }
                    case 'Z': {
                        asm.visitIntInsn(188, 4);
                        break;
                    }
                    case 'B': {
                        asm.visitIntInsn(188, 8);
                        break;
                    }
                    case 'S': {
                        asm.visitIntInsn(188, 9);
                        break;
                    }
                    case 'C': {
                        asm.visitIntInsn(188, 5);
                        break;
                    }
                    case 'I': {
                        asm.visitIntInsn(188, 10);
                        break;
                    }
                    case 'F': {
                        asm.visitIntInsn(188, 6);
                        break;
                    }
                    case 'J': {
                        asm.visitIntInsn(188, 11);
                        break;
                    }
                    case 'D': {
                        asm.visitIntInsn(188, 7);
                    }
                }
                break;
            }
            case CHECK_CAST: 
            case INSTANCE_OF: {
                TypeExpr te = (TypeExpr)e1;
                asm.visitTypeInsn(e1.vt == Value.VT.CHECK_CAST ? 192 : 193, IR2JConverter.toInternal(te.type));
                break;
            }
            case CAST: {
                CastExpr te = (CastExpr)e1;
                IR2JConverter.cast2(e1.op.valueType, te.to, asm);
                break;
            }
            case LENGTH: {
                asm.visitInsn(190);
                break;
            }
            case NEG: {
                asm.visitInsn(IR2JConverter.getOpcode(e1, 116));
                break;
            }
            case NOT: {
                if (e1.getOp().valueType.equals("I")) {
                    asm.visitLdcInsn(-1);
                    asm.visitInsn(IR2JConverter.getOpcode(e1, 130));
                    break;
                }
                if (!e1.getOp().valueType.equals("J")) break;
                asm.visitLdcInsn(-1L);
                asm.visitInsn(IR2JConverter.getOpcode(e1, 130));
            }
        }
    }

    private void reBuildE2Expression(Value.E2Expr e2, MethodVisitor asm) {
        String type = e2.op2.valueType;
        this.accept(e2.op1, asm);
        if ((e2.vt == Value.VT.ADD || e2.vt == Value.VT.SUB) && e2.op2.vt == Value.VT.CONSTANT) {
            Constant constant = (Constant)e2.op2;
            String t = constant.valueType;
            switch (t.charAt(0)) {
                case 'B': 
                case 'I': 
                case 'S': {
                    int s2 = (Integer)constant.value;
                    if (s2 >= 0) break;
                    asm.visitLdcInsn(-s2);
                    asm.visitInsn(IR2JConverter.getOpcode(type, e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 'F': {
                    float s3 = ((Float)constant.value).floatValue();
                    if (!(s3 < 0.0f)) break;
                    asm.visitLdcInsn(Float.valueOf(-s3));
                    asm.visitInsn(IR2JConverter.getOpcode(type, e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 'J': {
                    long s4 = (Long)constant.value;
                    if (s4 >= 0L) break;
                    asm.visitLdcInsn(-s4);
                    asm.visitInsn(IR2JConverter.getOpcode(type, e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
                case 'D': {
                    double s5 = (Double)constant.value;
                    if (!(s5 < 0.0)) break;
                    asm.visitLdcInsn(-s5);
                    asm.visitInsn(IR2JConverter.getOpcode(type, e2.vt == Value.VT.ADD ? 100 : 96));
                    return;
                }
            }
        }
        this.accept(e2.op2, asm);
        String tp1 = e2.op1.valueType;
        switch (e2.vt) {
            case ARRAY: {
                String tp2 = e2.valueType;
                if (tp1.charAt(0) == '[') {
                    asm.visitInsn(IR2JConverter.getOpcode(tp1.substring(1), 46));
                    break;
                }
                asm.visitInsn(IR2JConverter.getOpcode(tp2, 46));
                break;
            }
            case ADD: {
                asm.visitInsn(IR2JConverter.getOpcode(type, 96));
                break;
            }
            case SUB: {
                asm.visitInsn(IR2JConverter.getOpcode(type, 100));
                break;
            }
            case IDIV: 
            case LDIV: 
            case FDIV: 
            case DDIV: {
                asm.visitInsn(IR2JConverter.getOpcode(type, 108));
                break;
            }
            case MUL: {
                asm.visitInsn(IR2JConverter.getOpcode(type, 104));
                break;
            }
            case REM: {
                asm.visitInsn(IR2JConverter.getOpcode(type, 112));
                break;
            }
            case AND: {
                asm.visitInsn(IR2JConverter.getOpcode(type, 126));
                break;
            }
            case OR: {
                asm.visitInsn(IR2JConverter.getOpcode(type, 128));
                break;
            }
            case XOR: {
                asm.visitInsn(IR2JConverter.getOpcode(type, 130));
                break;
            }
            case SHL: {
                asm.visitInsn(IR2JConverter.getOpcode(tp1, 120));
                break;
            }
            case SHR: {
                asm.visitInsn(IR2JConverter.getOpcode(tp1, 122));
                break;
            }
            case USHR: {
                asm.visitInsn(IR2JConverter.getOpcode(tp1, 124));
                break;
            }
            case LCMP: {
                asm.visitInsn(148);
                break;
            }
            case FCMPG: {
                asm.visitInsn(150);
                break;
            }
            case DCMPG: {
                asm.visitInsn(152);
                break;
            }
            case FCMPL: {
                asm.visitInsn(149);
                break;
            }
            case DCMPL: {
                asm.visitInsn(151);
            }
        }
    }

    private static void cast2(String t1, String t2, MethodVisitor asm) {
        if (t1.equals(t2)) {
            return;
        }
        block0 : switch (t1.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                switch (t2.charAt(0)) {
                    case 'F': {
                        asm.visitInsn(134);
                        break;
                    }
                    case 'J': {
                        asm.visitInsn(133);
                        break;
                    }
                    case 'D': {
                        asm.visitInsn(135);
                        break;
                    }
                    case 'C': {
                        asm.visitInsn(146);
                        break;
                    }
                    case 'B': {
                        asm.visitInsn(145);
                        break;
                    }
                    case 'S': {
                        asm.visitInsn(147);
                    }
                }
                break;
            }
            case 'J': {
                switch (t2.charAt(0)) {
                    case 'I': {
                        asm.visitInsn(136);
                        break;
                    }
                    case 'F': {
                        asm.visitInsn(137);
                        break;
                    }
                    case 'D': {
                        asm.visitInsn(138);
                    }
                }
                break;
            }
            case 'D': {
                switch (t2.charAt(0)) {
                    case 'I': {
                        asm.visitInsn(142);
                        break;
                    }
                    case 'F': {
                        asm.visitInsn(144);
                        break;
                    }
                    case 'J': {
                        asm.visitInsn(143);
                    }
                }
                break;
            }
            case 'F': {
                switch (t2.charAt(0)) {
                    case 'I': {
                        asm.visitInsn(139);
                        break block0;
                    }
                    case 'J': {
                        asm.visitInsn(140);
                        break block0;
                    }
                    case 'D': {
                        asm.visitInsn(141);
                    }
                }
            }
        }
    }
}

