/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer;

import com.googlecode.d2j.DexType;
import com.googlecode.d2j.dex.writer.ev.EncodedAnnotation;
import com.googlecode.d2j.dex.writer.ev.EncodedArray;
import com.googlecode.d2j.dex.writer.ev.EncodedValue;
import com.googlecode.d2j.dex.writer.item.ConstPool;
import com.googlecode.d2j.visitors.DexAnnotationVisitor;
import java.util.List;

class AnnotationWriter
extends DexAnnotationVisitor {
    ConstPool cp;
    List<EncodedAnnotation.AnnotationElement> elements;

    public AnnotationWriter(List<EncodedAnnotation.AnnotationElement> elements, ConstPool cp) {
        this.elements = elements;
        this.cp = cp;
    }

    EncodedAnnotation.AnnotationElement newAnnotationElement(String name) {
        EncodedAnnotation.AnnotationElement ae = new EncodedAnnotation.AnnotationElement();
        ae.name = this.cp.uniqString(name);
        this.elements.add(ae);
        return ae;
    }

    @Override
    public void visit(String name, Object value) {
        if (value instanceof Object[]) {
            DexAnnotationVisitor s2 = this.visitArray(name);
            if (s2 != null) {
                for (Object v : (Object[])value) {
                    s2.visit(null, v);
                }
                s2.visitEnd();
            }
        } else {
            EncodedAnnotation.AnnotationElement ae = this.newAnnotationElement(name);
            ae.value = EncodedValue.wrap(this.cp.wrapEncodedItem(value));
        }
    }

    @Override
    public DexAnnotationVisitor visitAnnotation(String name, String desc) {
        EncodedAnnotation encodedAnnotation = new EncodedAnnotation();
        encodedAnnotation.type = this.cp.uniqType(desc);
        EncodedValue encodedValue = new EncodedValue(29, encodedAnnotation);
        EncodedAnnotation.AnnotationElement ae = this.newAnnotationElement(name);
        ae.value = encodedValue;
        return new AnnotationWriter(encodedAnnotation.elements, this.cp);
    }

    @Override
    public DexAnnotationVisitor visitArray(String name) {
        EncodedAnnotation.AnnotationElement ae = this.newAnnotationElement(name);
        EncodedArray encodedArray = new EncodedArray();
        ae.value = new EncodedValue(28, encodedArray);
        return new EncodedArrayAnnWriter(encodedArray);
    }

    @Override
    public void visitEnum(String name, String fower, String fname) {
        EncodedAnnotation.AnnotationElement ae = this.newAnnotationElement(name);
        ae.value = new EncodedValue(27, this.cp.uniqField(fower, fname, fower));
    }

    class EncodedArrayAnnWriter
    extends DexAnnotationVisitor {
        final EncodedArray encodedArray;

        public EncodedArrayAnnWriter(EncodedArray encodedArray) {
            this.encodedArray = encodedArray;
        }

        @Override
        public void visit(String name, Object value) {
            EncodedValue encodedValue = value instanceof String ? new EncodedValue(23, AnnotationWriter.this.cp.uniqString((String)value)) : (value instanceof DexType ? new EncodedValue(24, AnnotationWriter.this.cp.uniqType(((DexType)value).desc)) : EncodedValue.wrap(value));
            this.encodedArray.values.add(encodedValue);
        }

        @Override
        public DexAnnotationVisitor visitAnnotation(String name, String desc) {
            EncodedAnnotation encodedAnnotation = new EncodedAnnotation();
            encodedAnnotation.type = AnnotationWriter.this.cp.uniqType(desc);
            EncodedValue encodedValue = new EncodedValue(29, encodedAnnotation);
            this.encodedArray.values.add(encodedValue);
            return new AnnotationWriter(encodedAnnotation.elements, AnnotationWriter.this.cp);
        }

        @Override
        public DexAnnotationVisitor visitArray(String name) {
            EncodedValue encodedValue = new EncodedValue(28, this.encodedArray);
            this.encodedArray.values.add(encodedValue);
            return new EncodedArrayAnnWriter(this.encodedArray);
        }

        @Override
        public void visitEnum(String name, String fower, String fname) {
            EncodedValue encodedValue = new EncodedValue(27, AnnotationWriter.this.cp.uniqField(fower, fname, fower));
            this.encodedArray.values.add(encodedValue);
        }
    }
}

