/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.jasmin;

import com.googlecode.d2j.jasmin.JasminLexer;
import com.googlecode.d2j.jasmin.JasminParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.objectweb.asm.tree.ClassNode;

public class Jasmins {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassNode parse(Path file) throws IOException {
        try (BufferedReader bufferedReader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            ClassNode classNode = Jasmins.parse(file.toString(), bufferedReader);
            return classNode;
        }
        catch (RecognitionException e) {
            throw new RuntimeException("Fail to assemble " + file, e);
        }
    }

    public static ClassNode parse(String fileName, Reader bufferedReader) throws IOException, RecognitionException {
        ANTLRReaderStream is = new ANTLRReaderStream(bufferedReader);
        is.name = fileName;
        JasminLexer lexer = new JasminLexer(is);
        CommonTokenStream ts = new CommonTokenStream(lexer);
        JasminParser parser = new JasminParser(ts);
        return parser.parse();
    }

    public static ClassNode parse(String fileName, InputStream is) throws IOException, RecognitionException {
        return Jasmins.parse(fileName, new InputStreamReader(is, "UTF-8"));
    }
}

