/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.node;

import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.Visibility;
import com.googlecode.d2j.node.DexAnnotationNode;
import com.googlecode.d2j.node.DexFieldNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.visitors.DexAnnotationVisitor;
import com.googlecode.d2j.visitors.DexClassVisitor;
import com.googlecode.d2j.visitors.DexFieldVisitor;
import com.googlecode.d2j.visitors.DexFileVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import java.util.ArrayList;
import java.util.List;

public class DexClassNode
extends DexClassVisitor {
    public int access;
    public List<DexAnnotationNode> anns;
    public String className;
    public List<DexFieldNode> fields;
    public String[] interfaceNames;
    public List<DexMethodNode> methods;
    public String source;
    public String superClass;

    public DexClassNode(DexClassVisitor v, int access, String className, String superClass, String[] interfaceNames) {
        super(v);
        this.access = access;
        this.className = className;
        this.superClass = superClass;
        this.interfaceNames = interfaceNames;
    }

    public DexClassNode(int access, String className, String superClass, String[] interfaceNames) {
        this.access = access;
        this.className = className;
        this.superClass = superClass;
        this.interfaceNames = interfaceNames;
    }

    public void accept(DexClassVisitor dcv) {
        if (this.anns != null) {
            for (DexAnnotationNode ann : this.anns) {
                ann.accept(dcv);
            }
        }
        if (this.methods != null) {
            for (DexMethodNode m3 : this.methods) {
                m3.accept(dcv);
            }
        }
        if (this.fields != null) {
            for (DexFieldNode f : this.fields) {
                f.accept(dcv);
            }
        }
        if (this.source != null) {
            dcv.visitSource(this.source);
        }
    }

    public void accept(DexFileVisitor dfv) {
        DexClassVisitor dcv = dfv.visit(this.access, this.className, this.superClass, this.interfaceNames);
        if (dcv != null) {
            this.accept(dcv);
            dcv.visitEnd();
        }
    }

    @Override
    public DexAnnotationVisitor visitAnnotation(String name, Visibility visibility) {
        if (this.anns == null) {
            this.anns = new ArrayList<DexAnnotationNode>(5);
        }
        DexAnnotationNode annotation = new DexAnnotationNode(name, visibility);
        this.anns.add(annotation);
        return annotation;
    }

    @Override
    public DexFieldVisitor visitField(int accessFlags, Field field, Object value) {
        if (this.fields == null) {
            this.fields = new ArrayList<DexFieldNode>();
        }
        DexFieldNode fieldNode = new DexFieldNode(accessFlags, field, value);
        this.fields.add(fieldNode);
        return fieldNode;
    }

    @Override
    public DexMethodVisitor visitMethod(int accessFlags, Method method) {
        if (this.methods == null) {
            this.methods = new ArrayList<DexMethodNode>();
        }
        DexMethodNode methodNode = new DexMethodNode(accessFlags, method);
        this.methods.add(methodNode);
        return methodNode;
    }

    @Override
    public void visitSource(String file) {
        this.source = file;
    }
}

