/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util;

import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;

public final class Mutf8 {
    private Mutf8() {
    }

    public static String decode(ByteBuffer in, StringBuilder sb) throws UTFDataFormatException {
        while (true) {
            int b;
            char a;
            if ((a = (char)(in.get() & 0xFF)) == '\u0000') {
                return sb.toString();
            }
            if (a < '\u0080') {
                sb.append(a);
                continue;
            }
            if ((a & 0xE0) == 192) {
                b = in.get() & 0xFF;
                if ((b & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                sb.append((char)((a & 0x1F) << 6 | b & 0x3F));
                continue;
            }
            if ((a & 0xF0) != 224) break;
            b = in.get() & 0xFF;
            int c = in.get() & 0xFF;
            if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            sb.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
        }
        throw new UTFDataFormatException("bad byte");
    }

    private static long countBytes(String s2, boolean shortLength) throws UTFDataFormatException {
        long result = 0L;
        int length = s2.length();
        for (int i = 0; i < length; ++i) {
            char ch = s2.charAt(i);
            result = ch != '\u0000' && ch <= '\u007f' ? ++result : (ch <= '\u07ff' ? (result += 2L) : (result += 3L));
            if (!shortLength || result <= 65535L) continue;
            throw new UTFDataFormatException("String more than 65535 UTF bytes long");
        }
        return result;
    }

    public static void encode(byte[] dst, int offset, String s2) {
        int length = s2.length();
        for (int i = 0; i < length; ++i) {
            char ch = s2.charAt(i);
            if (ch != '\u0000' && ch <= '\u007f') {
                dst[offset++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                dst[offset++] = (byte)(0xC0 | 0x1F & ch >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch);
                continue;
            }
            dst[offset++] = (byte)(0xE0 | 0xF & ch >> 12);
            dst[offset++] = (byte)(0x80 | 0x3F & ch >> 6);
            dst[offset++] = (byte)(0x80 | 0x3F & ch);
        }
    }

    public static byte[] encode(String s2) throws UTFDataFormatException {
        int utfCount = (int)Mutf8.countBytes(s2, true);
        byte[] result = new byte[utfCount];
        Mutf8.encode(result, 0, s2);
        return result;
    }
}

