/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util;

import com.googlecode.d2j.DexException;
import java.util.ArrayList;
import java.util.List;

public class Types {
    public static String[] getParameterTypeDesc(String desc) {
        if (desc.charAt(0) != '(') {
            throw new DexException("not a validate Method Desc %s", desc);
        }
        int x = desc.lastIndexOf(41);
        if (x < 0) {
            throw new DexException("not a validate Method Desc %s", desc);
        }
        List<String> ps = Types.listDesc(desc.substring(1, x - 1));
        return ps.toArray(new String[ps.size()]);
    }

    public static String getReturnTypeDesc(String desc) {
        int x = desc.lastIndexOf(41);
        if (x < 0) {
            throw new DexException("not a validate Method Desc %s", desc);
        }
        return desc.substring(x + 1);
    }

    public static List<String> listDesc(String desc) {
        ArrayList<String> list = new ArrayList<String>(5);
        if (desc == null) {
            return list;
        }
        char[] chars = desc.toCharArray();
        int i = 0;
        block5: while (i < chars.length) {
            switch (chars[i]) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    list.add(Character.toString(chars[i]));
                    ++i;
                    continue block5;
                }
                case '[': {
                    int count = 1;
                    while (chars[i + count] == '[') {
                        ++count;
                    }
                    if (chars[i + count] == 'L') {
                        ++count;
                        while (chars[i + count] != ';') {
                            ++count;
                        }
                    }
                    list.add(new String(chars, i, ++count));
                    i += count;
                    continue block5;
                }
                case 'L': {
                    int count = 1;
                    while (chars[i + count] != ';') {
                        ++count;
                    }
                    list.add(new String(chars, i, ++count));
                    i += count;
                    continue block5;
                }
            }
            throw new RuntimeException("can't parse type list: " + desc);
        }
        return list;
    }

    public static Object[] buildDexStyleSignature(String signature) {
        int rawLength = signature.length();
        ArrayList<String> pieces = new ArrayList<String>(20);
        int at = 0;
        while (at < rawLength) {
            int endAt;
            char c = signature.charAt(at);
            if (c == 'L') {
                for (endAt = at + 1; endAt < rawLength; ++endAt) {
                    c = signature.charAt(endAt);
                    if (c == ';') {
                        ++endAt;
                    } else if (c != '<') {
                        continue;
                    }
                    break;
                }
            } else {
                while (endAt < rawLength && (c = signature.charAt(endAt)) != 'L') {
                    ++endAt;
                }
            }
            pieces.add(signature.substring(at, endAt));
            at = endAt;
        }
        return pieces.toArray(new Object[pieces.size()]);
    }
}

