/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.dex.writer.DexFileWriter;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@BaseCmd.Syntax(cmd="d2j-dex-recompute-checksum", syntax="[options] dex", desc="recompute crc and sha1 of dex.")
public class DexRecomputeChecksum
extends BaseCmd {
    @BaseCmd.Opt(opt="f", longOpt="force", hasArg=false, description="force overwrite")
    private boolean forceOverwrite = false;
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .dex file, default is [dex-name]-rechecksum.dex", argName="out-dex-file")
    private Path output;

    public static void main(String ... args) {
        new DexRecomputeChecksum().doMain(args);
    }

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length != 1) {
            this.usage();
            return;
        }
        Path jar = new File(this.remainingArgs[0]).toPath();
        if (!Files.exists(jar, new LinkOption[0])) {
            System.err.println(jar + " doesn't exist");
            this.usage();
            return;
        }
        if (this.output == null) {
            this.output = Files.isDirectory(jar, new LinkOption[0]) ? new File(jar.getFileName() + "-rechecksum.dex").toPath() : new File(DexRecomputeChecksum.getBaseName(jar.getFileName().toString()) + "-rechecksum.dex").toPath();
        }
        if (Files.exists(this.output, new LinkOption[0]) && !this.forceOverwrite) {
            System.err.println(this.output + " exists, use --force to overwrite");
            this.usage();
            return;
        }
        byte[] data = Files.readAllBytes(jar);
        ByteBuffer b = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
        b.putInt(32, data.length);
        DexFileWriter.updateChecksum(b, data.length);
        Files.write(this.output, data, new OpenOption[0]);
    }
}

