/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.tools.jar.InvocationWeaver;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

@BaseCmd.Syntax(cmd="d2j-jar-weaver", syntax="[options] jar", desc="replace invoke in jar", onlineHelp="https://sourceforge.net/p/dex2jar/wiki/JarWeaver")
public class JarWeaverCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="o", longOpt="output", description="output .jar file", argName="out-jar-file", required=true)
    private Path output;
    @BaseCmd.Opt(opt="c", longOpt="config", description="config file", argName="config", required=true)
    private Path config;
    @BaseCmd.Opt(opt="s", longOpt="stub-jar", description="stub jar", argName="stub")
    private Path stub;

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length == 0) {
            throw new BaseCmd.HelpException("no jar");
        }
        InvocationWeaver invocationWeaver = (InvocationWeaver)new InvocationWeaver().withConfig(this.config);
        try (FileSystem fs = JarWeaverCmd.createZip(this.output);){
            final Path outRoot = fs.getPath("/", new String[0]);
            for (String str : this.remainingArgs) {
                Path p = new File(str).toPath();
                System.err.println(p + " -> " + this.output);
                if (Files.isDirectory(p, new LinkOption[0])) {
                    invocationWeaver.wave(p, outRoot);
                    continue;
                }
                try (FileSystem fs2 = JarWeaverCmd.openZip(p);){
                    invocationWeaver.wave(fs2.getPath("/", new String[0]), outRoot);
                }
            }
            if (this.stub != null) {
                System.err.println(this.stub + " -> " + this.output);
                JarWeaverCmd.walkJarOrDir(this.stub, new BaseCmd.FileVisitorX(){

                    @Override
                    public void visitFile(Path file, String relative) throws IOException {
                        Path out = outRoot.resolve(relative);
                        if (Files.exists(out, new LinkOption[0])) {
                            System.err.println("skip " + relative + " in " + JarWeaverCmd.this.stub);
                        } else {
                            BaseCmd.createParentDirectories(out);
                            Files.copy(file, out, new CopyOption[0]);
                        }
                    }
                });
            }
        }
    }

    public static void main(String[] args) {
        new JarWeaverCmd().doMain(args);
    }
}

