/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.NonLLStarDecisionException;
import org.antlr.analysis.PredicateLabel;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.misc.BitSet;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.Token;
import org.antlr.tool.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFAToDFAConverter {
    protected List<DFAState> work = new LinkedList<DFAState>();
    protected NFAContext[] contextTrees;
    protected DFA dfa;
    public static boolean debug = false;
    public static boolean SINGLE_THREADED_NFA_CONVERSION = true;
    protected boolean computingStartState = false;

    public NFAToDFAConverter(DFA dfa) {
        this.dfa = dfa;
        int nAlts = dfa.getNumberOfAlts();
        this.initContextTrees(nAlts);
    }

    public void convert() {
        this.dfa.startState = this.computeStartState();
        while (this.work.size() > 0 && !this.dfa.nfa.grammar.NFAToDFAConversionExternallyAborted()) {
            int k;
            DFAState d = this.work.get(0);
            if (this.dfa.nfa.grammar.composite.watchNFAConversion) {
                System.out.println("convert DFA state " + d.stateNumber + " (" + d.nfaConfigurations.size() + " nfa states)");
            }
            if ((k = this.dfa.getUserMaxLookahead()) > 0 && k == d.getLookaheadDepth()) {
                this.resolveNonDeterminisms(d);
                if (d.isResolvedWithPredicates()) {
                    this.addPredicateTransitions(d);
                } else {
                    d.setAcceptState(true);
                }
            } else {
                this.findNewDFAStatesAndAddDFATransitions(d);
            }
            this.work.remove(0);
        }
        this.dfa.findAllGatedSynPredsUsedInDFAAcceptStates();
    }

    protected DFAState computeStartState() {
        NFAState alt = this.dfa.decisionNFAStartState;
        DFAState startState = this.dfa.newState();
        this.computingStartState = true;
        int i = 0;
        int altNum = 1;
        while (alt != null) {
            NFAContext initialContext = this.contextTrees[i];
            if (i == 0 && this.dfa.getNFADecisionStartState().decisionStateType == 1) {
                int numAltsIncludingExitBranch;
                altNum = numAltsIncludingExitBranch = this.dfa.nfa.grammar.getNumberOfAltsForDecisionNFA(this.dfa.decisionNFAStartState);
                this.closure((NFAState)alt.transition[0].target, altNum, initialContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, startState, true);
                altNum = 1;
            } else {
                this.closure((NFAState)alt.transition[0].target, altNum, initialContext, SemanticContext.EMPTY_SEMANTIC_CONTEXT, startState, true);
                ++altNum;
            }
            ++i;
            if (alt.transition[1] == null) break;
            alt = (NFAState)alt.transition[1].target;
        }
        this.dfa.addState(startState);
        this.work.add(startState);
        this.computingStartState = false;
        return startState;
    }

    protected void findNewDFAStatesAndAddDFATransitions(DFAState d) {
        boolean containsEOT;
        OrderedHashSet<Label> labels = d.getReachableLabels();
        Label EOTLabel = new Label(-2);
        boolean bl = containsEOT = labels != null && labels.contains(EOTLabel);
        if (!this.dfa.isGreedy() && containsEOT) {
            this.convertToEOTAcceptState(d);
            return;
        }
        int numberOfEdgesEmanating = 0;
        HashMap<Integer, Transition> targetToLabelMap = new HashMap<Integer, Transition>();
        int numLabels = 0;
        if (labels != null) {
            numLabels = labels.size();
        }
        for (int i = 0; i < numLabels; ++i) {
            Label label = labels.get(i);
            DFAState t = this.reach(d, label);
            if (debug) {
                System.out.println("DFA state after reach " + label + " " + d + "-" + label.toString(this.dfa.nfa.grammar) + "->" + t);
            }
            if (t == null) continue;
            if (t.getUniqueAlt() == -1) {
                this.closure(t);
            }
            DFAState targetState = this.addDFAStateToWorkList(t);
            numberOfEdgesEmanating += NFAToDFAConverter.addTransition(d, label, targetState, targetToLabelMap);
            targetState.setLookaheadDepth(d.getLookaheadDepth() + 1);
        }
        if (!d.isResolvedWithPredicates() && numberOfEdgesEmanating == 0) {
            this.dfa.probe.reportDanglingState(d);
            int minAlt = this.resolveByPickingMinAlt(d, null);
            d.setAcceptState(true);
            this.dfa.setAcceptState(minAlt, d);
        }
        if (d.isResolvedWithPredicates()) {
            this.addPredicateTransitions(d);
        }
    }

    protected static int addTransition(DFAState d, Label label, DFAState targetState, Map<Integer, Transition> targetToLabelMap) {
        int n = 0;
        if (DFAOptimizer.COLLAPSE_ALL_PARALLEL_EDGES) {
            Integer tI = Utils.integer(targetState.stateNumber);
            Transition oldTransition = targetToLabelMap.get(tI);
            if (oldTransition != null) {
                if (label.getAtom() == -2) {
                    oldTransition.label = new Label(-2);
                } else if (oldTransition.label.getAtom() != -2) {
                    oldTransition.label.add(label);
                }
            } else {
                n = 1;
                label = (Label)label.clone();
                int transitionIndex = d.addTransition(targetState, label);
                Transition trans = d.getTransition(transitionIndex);
                targetToLabelMap.put(tI, trans);
            }
        } else {
            n = 1;
            d.addTransition(targetState, label);
        }
        return n;
    }

    public void closure(DFAState d) {
        if (debug) {
            System.out.println("closure(" + d + ")");
        }
        ArrayList<NFAConfiguration> configs = new ArrayList<NFAConfiguration>();
        configs.addAll(d.nfaConfigurations);
        int numConfigs = configs.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration c = (NFAConfiguration)configs.get(i);
            if (c.singleAtomTransitionEmanating) continue;
            this.closure(this.dfa.nfa.getState(c.state), c.alt, c.context, c.semanticContext, d, false);
        }
        d.closureBusy = null;
    }

    public void closure(NFAState p, int alt, NFAContext context, SemanticContext semanticContext, DFAState d, boolean collectPredicates) {
        NFAConfiguration proposedNFAConfiguration;
        if (debug) {
            System.out.println("closure at " + p.enclosingRule.name + " state " + p.stateNumber + "|" + alt + " filling DFA state " + d.stateNumber + " with context " + context);
        }
        if (NFAToDFAConverter.closureIsBusy(d, proposedNFAConfiguration = new NFAConfiguration(p.stateNumber, alt, context, semanticContext))) {
            if (debug) {
                System.out.println("avoid visiting exact closure computation NFA config: " + proposedNFAConfiguration + " in " + p.enclosingRule.name);
                System.out.println("state is " + d.dfa.decisionNumber + "." + d.stateNumber);
            }
            return;
        }
        d.closureBusy.add(proposedNFAConfiguration);
        d.addNFAConfiguration(p, proposedNFAConfiguration);
        Transition transition0 = p.transition[0];
        if (transition0 instanceof RuleClosureTransition) {
            int depth = context.recursionDepthEmanatingFromState(p.stateNumber);
            if (depth == 1 && d.dfa.getUserMaxLookahead() == 0) {
                d.dfa.recursiveAltSet.add(alt);
                if (d.dfa.recursiveAltSet.size() > 1) {
                    d.abortedDueToMultipleRecursiveAlts = true;
                    throw new NonLLStarDecisionException(d.dfa);
                }
            }
            if (depth >= NFAContext.MAX_SAME_RULE_INVOCATIONS_PER_NFA_CONFIG_STACK) {
                d.abortedDueToRecursionOverflow = true;
                d.dfa.probe.reportRecursionOverflow(d, proposedNFAConfiguration);
                if (debug) {
                    System.out.println("analysis overflow in closure(" + d.stateNumber + ")");
                }
                return;
            }
            RuleClosureTransition ref = (RuleClosureTransition)transition0;
            NFAContext newContext = new NFAContext(context, p);
            NFAState ruleTarget = (NFAState)ref.target;
            this.closure(ruleTarget, alt, newContext, semanticContext, d, collectPredicates);
        } else if (p.isAcceptState() && context.parent != null) {
            NFAState whichStateInvokedRule = context.invokingState;
            RuleClosureTransition edgeToRule = (RuleClosureTransition)whichStateInvokedRule.transition[0];
            NFAState continueState = edgeToRule.followState;
            NFAContext newContext = context.parent;
            this.closure(continueState, alt, newContext, semanticContext, d, collectPredicates);
        } else {
            if (transition0 != null && transition0.isEpsilon()) {
                boolean collectPredicatesAfterAction = collectPredicates;
                if (transition0.isAction() && collectPredicates) {
                    collectPredicatesAfterAction = false;
                }
                this.closure((NFAState)transition0.target, alt, context, semanticContext, d, collectPredicatesAfterAction);
            } else if (transition0 != null && transition0.isSemanticPredicate()) {
                SemanticContext labelContext = transition0.label.getSemanticContext();
                if (this.computingStartState) {
                    if (collectPredicates) {
                        this.dfa.predicateVisible = true;
                    } else {
                        this.dfa.hasPredicateBlockedByAction = true;
                    }
                }
                SemanticContext newSemanticContext = semanticContext;
                if (collectPredicates) {
                    int walkAlt = this.dfa.decisionNFAStartState.translateDisplayAltToWalkAlt(alt);
                    NFAState altLeftEdge = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(this.dfa.decisionNFAStartState, walkAlt);
                    if (!labelContext.isSyntacticPredicate() || p == altLeftEdge.transition[0].target) {
                        newSemanticContext = SemanticContext.and(semanticContext, labelContext);
                    }
                }
                this.closure((NFAState)transition0.target, alt, context, newSemanticContext, d, collectPredicates);
            }
            Transition transition1 = p.transition[1];
            if (transition1 != null && transition1.isEpsilon()) {
                this.closure((NFAState)transition1.target, alt, context, semanticContext, d, collectPredicates);
            }
        }
    }

    public static boolean closureIsBusy(DFAState d, NFAConfiguration proposedNFAConfiguration) {
        return d.closureBusy.contains(proposedNFAConfiguration);
    }

    public DFAState reach(DFAState d, Label label) {
        DFAState labelDFATarget = this.dfa.newState();
        List<NFAConfiguration> configs = d.configurationsWithLabeledEdges;
        int numConfigs = configs.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration c = configs.get(i);
            if (c.resolved || c.resolveWithPredicate) continue;
            NFAState p = this.dfa.nfa.getState(c.state);
            Transition edge = p.transition[0];
            if (edge == null || !c.singleAtomTransitionEmanating) continue;
            Label edgeLabel = edge.label;
            if (c.context.parent != null && edgeLabel.label == -2 || !Label.intersect(label, edgeLabel)) continue;
            NFAConfiguration newC = labelDFATarget.addNFAConfiguration((NFAState)edge.target, c.alt, c.context, c.semanticContext);
        }
        if (labelDFATarget.nfaConfigurations.size() == 0) {
            this.dfa.setState(labelDFATarget.stateNumber, null);
            labelDFATarget = null;
        }
        return labelDFATarget;
    }

    protected void convertToEOTAcceptState(DFAState d) {
        Label eot = new Label(-2);
        int numConfigs = d.nfaConfigurations.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration c = d.nfaConfigurations.get(i);
            if (c.resolved || c.resolveWithPredicate) continue;
            NFAState p = this.dfa.nfa.getState(c.state);
            Transition edge = p.transition[0];
            Label edgeLabel = edge.label;
            if (!edgeLabel.equals(eot)) continue;
            d.setAcceptState(true);
            d.nfaConfigurations.clear();
            d.addNFAConfiguration(p, c.alt, c.context, c.semanticContext);
            return;
        }
    }

    protected DFAState addDFAStateToWorkList(DFAState d) {
        DFAState existingState = this.dfa.addState(d);
        if (d != existingState) {
            this.dfa.setState(d.stateNumber, existingState);
            return existingState;
        }
        this.resolveNonDeterminisms(d);
        int alt = d.getUniquelyPredictedAlt();
        if (alt != -1) {
            d = this.convertToAcceptState(d, alt);
        } else {
            this.work.add(d);
        }
        return d;
    }

    protected DFAState convertToAcceptState(DFAState d, int alt) {
        DFAState acceptStateForAlt;
        if (DFAOptimizer.MERGE_STOP_STATES && d.getNonDeterministicAlts() == null && !d.abortedDueToRecursionOverflow && !d.abortedDueToMultipleRecursiveAlts && (acceptStateForAlt = this.dfa.getAcceptState(alt)) != null) {
            SemanticContext gatedPreds = d.getGatedPredicatesInNFAConfigurations();
            SemanticContext existingStateGatedPreds = acceptStateForAlt.getGatedPredicatesInNFAConfigurations();
            if (gatedPreds == null && existingStateGatedPreds == null || gatedPreds != null && existingStateGatedPreds != null && gatedPreds.equals(existingStateGatedPreds)) {
                this.dfa.setState(d.stateNumber, acceptStateForAlt);
                this.dfa.removeState(d);
                d = acceptStateForAlt;
                return d;
            }
        }
        d.setAcceptState(true);
        this.dfa.setAcceptState(alt, d);
        return d;
    }

    public void resolveNonDeterminisms(DFAState d) {
        boolean resolved;
        Set<Integer> allAlts;
        if (debug) {
            System.out.println("resolveNonDeterminisms " + d.toString());
        }
        boolean conflictingLexerRules = false;
        Set<Integer> nondeterministicAlts = d.getNonDeterministicAlts();
        if (debug && nondeterministicAlts != null) {
            System.out.println("nondet alts=" + nondeterministicAlts);
        }
        NFAConfiguration anyConfig = d.nfaConfigurations.get(0);
        NFAState anyState = this.dfa.nfa.getState(anyConfig.state);
        if (anyState.isEOTTargetState() && (allAlts = d.getAltSet()) != null && allAlts.size() > 1) {
            nondeterministicAlts = allAlts;
            if (d.dfa.isTokensRuleDecision()) {
                this.dfa.probe.reportLexerRuleNondeterminism(d, allAlts);
                conflictingLexerRules = true;
            }
        }
        if (!d.abortedDueToRecursionOverflow && nondeterministicAlts == null) {
            return;
        }
        if (!d.abortedDueToRecursionOverflow && !conflictingLexerRules) {
            this.dfa.probe.reportNondeterminism(d, nondeterministicAlts);
        }
        if (resolved = this.tryToResolveWithSemanticPredicates(d, nondeterministicAlts)) {
            if (debug) {
                System.out.println("resolved DFA state " + d.stateNumber + " with pred");
            }
            d.resolvedWithPredicates = true;
            this.dfa.probe.reportNondeterminismResolvedWithSemanticPredicate(d);
            return;
        }
        this.resolveByChoosingFirstAlt(d, nondeterministicAlts);
    }

    protected int resolveByChoosingFirstAlt(DFAState d, Set<Integer> nondeterministicAlts) {
        int exitAlt;
        int winningAlt = this.dfa.isGreedy() ? this.resolveByPickingMinAlt(d, nondeterministicAlts) : (nondeterministicAlts.contains(Utils.integer(exitAlt = this.dfa.getNumberOfAlts())) ? this.resolveByPickingExitAlt(d, nondeterministicAlts) : this.resolveByPickingMinAlt(d, nondeterministicAlts));
        return winningAlt;
    }

    protected int resolveByPickingMinAlt(DFAState d, Set<Integer> nondeterministicAlts) {
        int min2 = nondeterministicAlts != null ? NFAToDFAConverter.getMinAlt(nondeterministicAlts) : d.minAltInConfigurations;
        NFAToDFAConverter.turnOffOtherAlts(d, min2, nondeterministicAlts);
        return min2;
    }

    protected int resolveByPickingExitAlt(DFAState d, Set<Integer> nondeterministicAlts) {
        int exitAlt = this.dfa.getNumberOfAlts();
        NFAToDFAConverter.turnOffOtherAlts(d, exitAlt, nondeterministicAlts);
        return exitAlt;
    }

    protected static void turnOffOtherAlts(DFAState d, int min2, Set<Integer> nondeterministicAlts) {
        int numConfigs = d.nfaConfigurations.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = d.nfaConfigurations.get(i);
            if (configuration.alt == min2 || nondeterministicAlts != null && !nondeterministicAlts.contains(Utils.integer(configuration.alt))) continue;
            configuration.resolved = true;
        }
    }

    protected static int getMinAlt(Set<Integer> nondeterministicAlts) {
        int min2 = Integer.MAX_VALUE;
        for (Integer altI : nondeterministicAlts) {
            int alt = altI;
            if (alt >= min2) continue;
            min2 = alt;
        }
        return min2;
    }

    protected boolean tryToResolveWithSemanticPredicates(DFAState d, Set<Integer> nondeterministicAlts) {
        Map<Integer, SemanticContext> altToPredMap = this.getPredicatesPerNonDeterministicAlt(d, nondeterministicAlts);
        if (altToPredMap.isEmpty()) {
            return false;
        }
        this.dfa.probe.reportAltPredicateContext(d, altToPredMap);
        if (nondeterministicAlts.size() - altToPredMap.size() > 1) {
            return false;
        }
        if (altToPredMap.size() == nondeterministicAlts.size() - 1) {
            SemanticContext unionOfPredicatesFromAllAlts;
            BitSet predSet;
            BitSet ndSet = BitSet.of(nondeterministicAlts);
            int nakedAlt = ndSet.subtract(predSet = BitSet.of(altToPredMap)).getSingleElement();
            SemanticContext nakedAltPred = nakedAlt == NFAToDFAConverter.max(nondeterministicAlts) ? new SemanticContext.TruePredicate() : ((unionOfPredicatesFromAllAlts = NFAToDFAConverter.getUnionOfPredicates(altToPredMap)).isSyntacticPredicate() ? new SemanticContext.TruePredicate() : SemanticContext.not(unionOfPredicatesFromAllAlts));
            altToPredMap.put(Utils.integer(nakedAlt), nakedAltPred);
            int numConfigs = d.nfaConfigurations.size();
            for (int i = 0; i < numConfigs; ++i) {
                NFAConfiguration configuration = d.nfaConfigurations.get(i);
                if (configuration.alt != nakedAlt) continue;
                configuration.semanticContext = nakedAltPred;
            }
        }
        if (altToPredMap.size() == nondeterministicAlts.size()) {
            if (d.abortedDueToRecursionOverflow) {
                d.dfa.probe.removeRecursiveOverflowState(d);
            }
            int numConfigs = d.nfaConfigurations.size();
            for (int i = 0; i < numConfigs; ++i) {
                NFAConfiguration configuration = d.nfaConfigurations.get(i);
                SemanticContext semCtx = altToPredMap.get(Utils.integer(configuration.alt));
                if (semCtx != null) {
                    configuration.resolveWithPredicate = true;
                    configuration.semanticContext = semCtx;
                    altToPredMap.remove(Utils.integer(configuration.alt));
                    if (!semCtx.isSyntacticPredicate()) continue;
                    this.dfa.nfa.grammar.synPredUsedInDFA(this.dfa, semCtx);
                    continue;
                }
                if (!nondeterministicAlts.contains(Utils.integer(configuration.alt))) continue;
                configuration.resolved = true;
            }
            return true;
        }
        return false;
    }

    protected Map<Integer, SemanticContext> getPredicatesPerNonDeterministicAlt(DFAState d, Set<Integer> nondeterministicAlts) {
        HashMap<Integer, SemanticContext> altToPredicateContextMap = new HashMap<Integer, SemanticContext>();
        HashMap altToSetOfContextsMap = new HashMap();
        for (Integer altI : nondeterministicAlts) {
            altToSetOfContextsMap.put(altI, new OrderedHashSet());
        }
        HashMap<Integer, Set<Token>> altToLocationsReachableWithoutPredicate = new HashMap<Integer, Set<Token>>();
        HashSet<Integer> nondetAltsWithUncoveredConfiguration = new HashSet<Integer>();
        int numConfigs = d.nfaConfigurations.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration configuration = d.nfaConfigurations.get(i);
            Integer altI = Utils.integer(configuration.alt);
            if (!nondeterministicAlts.contains(altI)) continue;
            if (configuration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
                Set predSet = (Set)altToSetOfContextsMap.get(altI);
                predSet.add(configuration.semanticContext);
                continue;
            }
            nondetAltsWithUncoveredConfiguration.add(altI);
        }
        ArrayList<Integer> incompletelyCoveredAlts = new ArrayList<Integer>();
        for (Integer altI : nondeterministicAlts) {
            Set contextsForThisAlt = (Set)altToSetOfContextsMap.get(altI);
            if (nondetAltsWithUncoveredConfiguration.contains(altI)) {
                if (contextsForThisAlt.size() <= 0) continue;
                incompletelyCoveredAlts.add(altI);
                continue;
            }
            SemanticContext combinedContext = null;
            for (SemanticContext ctx : contextsForThisAlt) {
                combinedContext = SemanticContext.or(combinedContext, ctx);
            }
            altToPredicateContextMap.put(altI, combinedContext);
        }
        if (incompletelyCoveredAlts.size() > 0) {
            for (int i = 0; i < numConfigs; ++i) {
                NFAConfiguration configuration = d.nfaConfigurations.get(i);
                Integer altI = Utils.integer(configuration.alt);
                if (!incompletelyCoveredAlts.contains(altI) || configuration.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) continue;
                NFAState s2 = this.dfa.nfa.getState(configuration.state);
                if (s2.incidentEdgeLabel == null || s2.incidentEdgeLabel.label == -1) continue;
                if (s2.associatedASTNode == null || s2.associatedASTNode.token == null) {
                    ErrorManager.internalError("no AST/token for nonepsilon target w/o predicate");
                    continue;
                }
                HashSet<Token> locations = (HashSet<Token>)altToLocationsReachableWithoutPredicate.get(altI);
                if (locations == null) {
                    locations = new HashSet<Token>();
                    altToLocationsReachableWithoutPredicate.put(altI, locations);
                }
                locations.add(s2.associatedASTNode.token);
            }
            this.dfa.probe.reportIncompletelyCoveredAlts(d, altToLocationsReachableWithoutPredicate);
        }
        return altToPredicateContextMap;
    }

    protected static SemanticContext getUnionOfPredicates(Map<?, SemanticContext> altToPredMap) {
        SemanticContext unionOfPredicatesFromAllAlts = null;
        for (SemanticContext semCtx : altToPredMap.values()) {
            if (unionOfPredicatesFromAllAlts == null) {
                unionOfPredicatesFromAllAlts = semCtx;
                continue;
            }
            unionOfPredicatesFromAllAlts = SemanticContext.or(unionOfPredicatesFromAllAlts, semCtx);
        }
        return unionOfPredicatesFromAllAlts;
    }

    protected void addPredicateTransitions(DFAState d) {
        ArrayList<NFAConfiguration> configsWithPreds = new ArrayList<NFAConfiguration>();
        int numConfigs = d.nfaConfigurations.size();
        for (int i = 0; i < numConfigs; ++i) {
            NFAConfiguration c = d.nfaConfigurations.get(i);
            if (!c.resolveWithPredicate) continue;
            configsWithPreds.add(c);
        }
        Collections.sort(configsWithPreds, new Comparator<NFAConfiguration>(){

            @Override
            public int compare(NFAConfiguration a, NFAConfiguration b) {
                if (a.alt < b.alt) {
                    return -1;
                }
                if (a.alt > b.alt) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<NFAConfiguration> predConfigsSortedByAlt = configsWithPreds;
        for (int i = 0; i < predConfigsSortedByAlt.size(); ++i) {
            NFAConfiguration c = (NFAConfiguration)predConfigsSortedByAlt.get(i);
            DFAState predDFATarget = d.dfa.getAcceptState(c.alt);
            if (predDFATarget == null) {
                predDFATarget = this.dfa.newState();
                predDFATarget.addNFAConfiguration(this.dfa.nfa.getState(c.state), c.alt, c.context, c.semanticContext);
                predDFATarget.setAcceptState(true);
                this.dfa.setAcceptState(c.alt, predDFATarget);
                DFAState existingState = this.dfa.addState(predDFATarget);
                if (predDFATarget != existingState) {
                    this.dfa.setState(predDFATarget.stateNumber, existingState);
                    predDFATarget = existingState;
                }
            }
            d.addTransition(predDFATarget, new PredicateLabel(c.semanticContext));
        }
    }

    protected void initContextTrees(int numberOfAlts) {
        this.contextTrees = new NFAContext[numberOfAlts];
        for (int i = 0; i < this.contextTrees.length; ++i) {
            int alt = i + 1;
            this.contextTrees[i] = new NFAContext(null, null);
        }
    }

    public static int max(Set<Integer> s2) {
        if (s2 == null) {
            return Integer.MIN_VALUE;
        }
        int i = 0;
        int m3 = 0;
        for (Integer value : s2) {
            Integer I2 = value;
            if (++i == 1) {
                m3 = I2;
                continue;
            }
            if (I2 <= m3) continue;
            m3 = I2;
        }
        return m3;
    }
}

