/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

public class DOTGenerator {
    public static final boolean STRIP_NONREDUCED_STATES = false;
    protected String arrowhead = "normal";
    protected String rankdir = "LR";
    public static STGroup stlib = new STGroupFile("org/antlr/tool/templates/dot/dot.stg");
    protected Set<Object> markedStates = null;
    protected Grammar grammar;

    public DOTGenerator(Grammar grammar) {
        this.grammar = grammar;
    }

    public String getDOT(State startState) {
        ST dot;
        if (startState == null) {
            return null;
        }
        this.markedStates = new HashSet<Object>();
        if (startState instanceof DFAState) {
            dot = stlib.getInstanceOf("dfa");
            dot.add("startState", Utils.integer(startState.stateNumber));
            dot.add("useBox", Tool.internalOption_ShowNFAConfigsInDFA);
            this.walkCreatingDFADOT(dot, (DFAState)startState);
        } else {
            dot = stlib.getInstanceOf("nfa");
            dot.add("startState", Utils.integer(startState.stateNumber));
            this.walkRuleNFACreatingDOT(dot, startState);
        }
        dot.add("rankdir", this.rankdir);
        return dot.render();
    }

    protected void walkCreatingDFADOT(ST dot, DFAState s2) {
        if (this.markedStates.contains(Utils.integer(s2.stateNumber))) {
            return;
        }
        this.markedStates.add(Utils.integer(s2.stateNumber));
        ST st = s2.isAcceptState() ? stlib.getInstanceOf("stopstate") : stlib.getInstanceOf("state");
        st.add("name", this.getStateLabel(s2));
        dot.add("states", st);
        for (int i = 0; i < s2.getNumberOfTransitions(); ++i) {
            Transition edge = s2.transition(i);
            st = stlib.getInstanceOf("edge");
            st.add("label", this.getEdgeLabel(edge));
            st.add("src", this.getStateLabel(s2));
            st.add("target", this.getStateLabel(edge.target));
            st.add("arrowhead", this.arrowhead);
            dot.add("edges", st);
            this.walkCreatingDFADOT(dot, (DFAState)edge.target);
        }
    }

    protected void walkRuleNFACreatingDOT(ST dot, State s2) {
        GrammarAST n;
        if (this.markedStates.contains(s2)) {
            return;
        }
        this.markedStates.add(s2);
        ST stateST = s2.isAcceptState() ? stlib.getInstanceOf("stopstate") : stlib.getInstanceOf("state");
        stateST.add("name", this.getStateLabel(s2));
        dot.add("states", stateST);
        if (s2.isAcceptState()) {
            return;
        }
        if (((NFAState)s2).isDecisionState() && (n = ((NFAState)s2).associatedASTNode) != null && n.getType() != 33) {
            ST rankST = stlib.getInstanceOf("decision-rank");
            NFAState alt = (NFAState)s2;
            while (alt != null) {
                rankST.add("states", this.getStateLabel(alt));
                if (alt.transition[1] != null) {
                    alt = (NFAState)alt.transition[1].target;
                    continue;
                }
                alt = null;
            }
            dot.add("decisionRanks", rankST);
        }
        for (int i = 0; i < s2.getNumberOfTransitions(); ++i) {
            ST edgeST;
            Transition edge = s2.transition(i);
            if (edge instanceof RuleClosureTransition) {
                RuleClosureTransition rr = (RuleClosureTransition)edge;
                edgeST = stlib.getInstanceOf("edge");
                if (rr.rule.grammar != this.grammar) {
                    edgeST.add("label", "<" + rr.rule.grammar.name + "." + rr.rule.name + ">");
                } else {
                    edgeST.add("label", "<" + rr.rule.name + ">");
                }
                edgeST.add("src", this.getStateLabel(s2));
                edgeST.add("target", this.getStateLabel(rr.followState));
                edgeST.add("arrowhead", this.arrowhead);
                dot.add("edges", edgeST);
                this.walkRuleNFACreatingDOT(dot, rr.followState);
                continue;
            }
            edgeST = edge.isAction() ? stlib.getInstanceOf("action-edge") : (edge.isEpsilon() ? stlib.getInstanceOf("epsilon-edge") : stlib.getInstanceOf("edge"));
            edgeST.add("label", this.getEdgeLabel(edge));
            edgeST.add("src", this.getStateLabel(s2));
            edgeST.add("target", this.getStateLabel(edge.target));
            edgeST.add("arrowhead", this.arrowhead);
            dot.add("edges", edgeST);
            this.walkRuleNFACreatingDOT(dot, edge.target);
        }
    }

    protected String getEdgeLabel(Transition edge) {
        SemanticContext preds;
        String label = edge.label.toString(this.grammar);
        label = Utils.replace(label, "\\", "\\\\");
        label = Utils.replace(label, "\"", "\\\"");
        label = Utils.replace(label, "\n", "\\\\n");
        if ((label = Utils.replace(label, "\r", "")).equals("<EPSILON>")) {
            label = "e";
        }
        State target = edge.target;
        if (!edge.isSemanticPredicate() && target instanceof DFAState && (preds = ((DFAState)target).getGatedPredicatesInNFAConfigurations()) != null) {
            String predsStr = "&&{" + preds.genExpr(this.grammar.generator, this.grammar.generator.getTemplates(), null).render() + "}?";
            label = label + predsStr;
        }
        return label;
    }

    protected String getStateLabel(State s2) {
        if (s2 == null) {
            return "null";
        }
        String stateLabel = String.valueOf(s2.stateNumber);
        if (s2 instanceof DFAState) {
            StringBuilder buf = new StringBuilder(250);
            buf.append('s');
            buf.append(s2.stateNumber);
            if (Tool.internalOption_ShowNFAConfigsInDFA) {
                Set<Integer> alts;
                if (s2 instanceof DFAState && ((DFAState)s2).abortedDueToRecursionOverflow) {
                    buf.append("\\n");
                    buf.append("abortedDueToRecursionOverflow");
                }
                if ((alts = ((DFAState)s2).getAltSet()) != null) {
                    buf.append("\\n");
                    ArrayList<Integer> altList = new ArrayList<Integer>();
                    altList.addAll(alts);
                    Collections.sort(altList);
                    OrderedHashSet<NFAConfiguration> configurations = ((DFAState)s2).nfaConfigurations;
                    for (int altIndex = 0; altIndex < altList.size(); ++altIndex) {
                        Integer altI = (Integer)altList.get(altIndex);
                        int alt = altI;
                        if (altIndex > 0) {
                            buf.append("\\n");
                        }
                        buf.append("alt");
                        buf.append(alt);
                        buf.append(':');
                        ArrayList<NFAConfiguration> configsInAlt = new ArrayList<NFAConfiguration>();
                        for (NFAConfiguration c : configurations) {
                            if (c.alt != alt) continue;
                            configsInAlt.add(c);
                        }
                        int n = 0;
                        for (int cIndex = 0; cIndex < configsInAlt.size(); ++cIndex) {
                            NFAConfiguration c = (NFAConfiguration)configsInAlt.get(cIndex);
                            ++n;
                            buf.append(c.toString(false));
                            if (cIndex + 1 < configsInAlt.size()) {
                                buf.append(", ");
                            }
                            if (n % 5 != 0 || configsInAlt.size() - cIndex <= 3) continue;
                            buf.append("\\n");
                        }
                    }
                }
            }
            stateLabel = buf.toString();
        }
        if (s2 instanceof NFAState && ((NFAState)s2).isDecisionState()) {
            stateLabel = stateLabel + ",d=" + ((NFAState)s2).getDecisionNumber();
            if (((NFAState)s2).endOfBlockStateNumber != -1) {
                stateLabel = stateLabel + ",eob=" + ((NFAState)s2).endOfBlockStateNumber;
            }
        } else if (s2 instanceof NFAState && ((NFAState)s2).endOfBlockStateNumber != -1) {
            NFAState n = (NFAState)s2;
            stateLabel = stateLabel + ",eob=" + n.endOfBlockStateNumber;
        } else if (s2 instanceof DFAState && ((DFAState)s2).isAcceptState()) {
            stateLabel = stateLabel + "=>" + ((DFAState)s2).getUniquelyPredictedAlt();
        }
        return '\"' + stateLabel + '\"';
    }

    public String getArrowheadType() {
        return this.arrowhead;
    }

    public void setArrowheadType(String arrowhead) {
        this.arrowhead = arrowhead;
    }

    public String getRankdir() {
        return this.rankdir;
    }

    public void setRankdir(String rankdir) {
        this.rankdir = rankdir;
    }
}

