/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.tour;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.HamiltonianCycleAlgorithm;
import org.jgrapht.graph.GraphWalk;

public class TwoOptHeuristicTSP<V, E>
implements HamiltonianCycleAlgorithm<V, E> {
    private int k;
    private Random rng;
    private Graph<V, E> graph;
    private int n;
    private double[][] dist;
    private Map<V, Integer> index;
    private Map<Integer, V> revIndex;

    public TwoOptHeuristicTSP() {
        this(1, new Random());
    }

    public TwoOptHeuristicTSP(int k) {
        this(k, new Random());
    }

    public TwoOptHeuristicTSP(int k, long seed) {
        this(k, new Random(seed));
    }

    public TwoOptHeuristicTSP(int k, Random rng) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be at least one");
        }
        this.k = k;
        this.rng = Objects.requireNonNull(rng, "Random number generator cannot be null");
    }

    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        this.init(graph);
        if (graph.vertexSet().size() == 1) {
            V start = graph.vertexSet().iterator().next();
            return new GraphWalk<V, E>(graph, start, start, Collections.singletonList(start), Collections.emptyList(), 0.0);
        }
        GraphPath<V, E> best = this.tourToPath(this.improve(this.createRandomTour()));
        for (int i = 1; i < this.k; ++i) {
            GraphPath<V, E> other = this.tourToPath(this.improve(this.createRandomTour()));
            if (!(other.getWeight() < best.getWeight())) continue;
            best = other;
        }
        return best;
    }

    public GraphPath<V, E> improveTour(GraphPath<V, E> tour) {
        this.init(tour.getGraph());
        return this.tourToPath(this.improve(this.pathToTour(tour)));
    }

    private void init(Graph<V, E> graph) {
        this.graph = GraphTests.requireUndirected(graph);
        if (!GraphTests.isComplete(graph)) {
            throw new IllegalArgumentException("Graph is not complete");
        }
        if (graph.vertexSet().isEmpty()) {
            throw new IllegalArgumentException("Graph contains no vertices");
        }
        this.n = graph.vertexSet().size();
        this.dist = new double[this.n][this.n];
        this.index = new HashMap<V, Integer>();
        this.revIndex = new HashMap<Integer, V>();
        int i = 0;
        for (V v : graph.vertexSet()) {
            this.index.put((Integer)v, i);
            this.revIndex.put(i, v);
            ++i;
        }
        for (Object e : graph.edgeSet()) {
            double weight;
            V s2 = graph.getEdgeSource(e);
            int si = this.index.get(s2);
            V t = graph.getEdgeTarget(e);
            int ti = this.index.get(t);
            this.dist[si][ti] = weight = graph.getEdgeWeight(e);
            this.dist[ti][si] = weight;
        }
    }

    private int[] createRandomTour() {
        int i;
        int[] tour = new int[this.n + 1];
        for (i = 0; i < this.n; ++i) {
            tour[i] = i;
        }
        for (i = this.n; i > 1; --i) {
            int j = this.rng.nextInt(i);
            int tmp = tour[i - 1];
            tour[i - 1] = tour[j];
            tour[j] = tmp;
        }
        tour[this.n] = tour[0];
        return tour;
    }

    private int[] improve(int[] tour) {
        double minChange;
        int[] newTour = new int[this.n + 1];
        do {
            int k;
            minChange = 0.0;
            int mini = -1;
            int minj = -1;
            for (int i = 0; i < this.n - 2; ++i) {
                for (int j = i + 2; j < this.n; ++j) {
                    int ci = tour[i];
                    int cj = tour[j];
                    int ci1 = tour[i + 1];
                    int cj1 = tour[j + 1];
                    double change = this.dist[ci][cj] + this.dist[ci1][cj1] - this.dist[ci][ci1] - this.dist[cj][cj1];
                    if (!(change < minChange)) continue;
                    minChange = change;
                    mini = i;
                    minj = j;
                }
            }
            if (mini == -1 || minj == -1) continue;
            int a = 0;
            for (k = 0; k <= mini; ++k) {
                newTour[a++] = tour[k];
            }
            for (k = minj; k >= mini + 1; --k) {
                newTour[a++] = tour[k];
            }
            for (k = minj + 1; k < this.n + 1; ++k) {
                newTour[a++] = tour[k];
            }
            int[] tmp = tour;
            tour = newTour;
            newTour = tmp;
        } while (minChange < 0.0);
        return tour;
    }

    private GraphPath<V, E> tourToPath(int[] tour) {
        ArrayList<E> tourEdges = new ArrayList<E>(this.n);
        ArrayList<V> tourVertices = new ArrayList<V>(this.n + 1);
        double tourWeight = 0.0;
        V start = this.revIndex.get(tour[0]);
        tourVertices.add(start);
        for (int i = 1; i < this.n + 1; ++i) {
            V u = this.revIndex.get(tour[i - 1]);
            V v = this.revIndex.get(tour[i]);
            tourVertices.add(v);
            E e = this.graph.getEdge(u, v);
            tourEdges.add(e);
            tourWeight += this.graph.getEdgeWeight(e);
        }
        return new GraphWalk<V, E>(this.graph, start, start, tourVertices, tourEdges, tourWeight);
    }

    private int[] pathToTour(GraphPath<V, E> path) {
        HashSet<V> visited = new HashSet<V>();
        int i = 0;
        int[] tour = new int[this.n + 1];
        V v = path.getStartVertex();
        tour[i++] = this.index.get(v);
        for (E e : path.getEdgeList()) {
            v = Graphs.getOppositeVertex(this.graph, e, v);
            if (!visited.add(v)) {
                throw new IllegalArgumentException("Not a valid tour");
            }
            tour[i++] = this.index.get(v);
        }
        if (i < this.n + 1) {
            throw new IllegalArgumentException("Not a valid tour");
        }
        return tour;
    }
}

